/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayGuards;
import org.jruby.truffle.core.array.ArraySliceNode;
import org.jruby.truffle.core.array.ArrayStrategy;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=ArraySliceNode.class)
public final class ArraySliceNodeGen
extends ArraySliceNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private BaseNode_ specialization_;

    private ArraySliceNodeGen(RubyContext context, SourceSection sourceSection, int from, int to, RubyNode array) {
        super(context, sourceSection, from, to);
        this.array_ = array;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static ArraySliceNode create(RubyContext context, SourceSection sourceSection, int from, int to, RubyNode array) {
        return new ArraySliceNodeGen(context, sourceSection, from, to, array);
    }

    @GeneratedBy(methodName="readInBounds(DynamicObject, ArrayStrategy, ConditionProfile)", value=ArraySliceNode.class)
    private static final class ReadInBoundsNode_
    extends BaseNode_ {
        private final ArrayStrategy strategy;
        private final ConditionProfile emptyArray;

        ReadInBoundsNode_(ArraySliceNodeGen root, ArrayStrategy strategy, ConditionProfile emptyArray) {
            super(root, 2);
            this.strategy = strategy;
            this.emptyArray = emptyArray;
        }

        public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            return arrayValue instanceof DynamicObject && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && this.strategy.matches(arrayValue_ = (DynamicObject)arrayValue)) {
                return this.root.readInBounds(arrayValue_, this.strategy, this.emptyArray);
            }
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArraySliceNodeGen root, ArrayStrategy strategy, ConditionProfile emptyArray) {
            return new ReadInBoundsNode_(root, strategy, emptyArray);
        }
    }

    @GeneratedBy(methodName="sliceNull(DynamicObject)", value=ArraySliceNode.class)
    private static final class SliceNullNode_
    extends BaseNode_ {
        SliceNullNode_(ArraySliceNodeGen root) {
            super(root, 1);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            DynamicObject arrayValue_;
            if (arrayValue instanceof DynamicObject && ArrayGuards.isNullArray(arrayValue_ = (DynamicObject)arrayValue)) {
                return this.root.sliceNull(arrayValue_);
            }
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArraySliceNodeGen root) {
            return new SliceNullNode_(root);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ArraySliceNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue));
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            return this.getNext().executeDynamicObject_(frameValue, arrayValue);
        }

        static BaseNode_ create(ArraySliceNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ArraySliceNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arrayValue) {
            return (DynamicObject)this.uninitialized((Frame)frameValue, arrayValue);
        }

        static BaseNode_ create(ArraySliceNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ArraySliceNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ArraySliceNodeGen root;

        BaseNode_(ArraySliceNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final void setRoot(Node root) {
            this.root = (ArraySliceNodeGen)root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue) {
            return this.executeDynamicObject_((VirtualFrame)frameValue, arrayValue);
        }

        public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            return this.executeDynamicObject_(frameValue, arrayValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue) {
            if (arrayValue instanceof DynamicObject) {
                ConditionProfile emptyArray2;
                BaseNode_ s;
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (ArrayGuards.isNullArray(arrayValue_)) {
                    return SliceNullNode_.create(this.root);
                }
                ArrayStrategy strategy2 = ArrayStrategy.of(arrayValue_);
                if (strategy2.matches(arrayValue_) && this.countSame(s = ReadInBoundsNode_.create(this.root, strategy2, emptyArray2 = ConditionProfile.createBinaryProfile())) < 25) {
                    return s;
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }
    }
}

