/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.tools.callgraph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.tools.callgraph.Method;
import org.jruby.truffle.tools.callgraph.MethodVersion;

public class CallGraph {
    private final Map<SharedMethodInfo, Method> sharedMethodInfoToMethod = new HashMap<SharedMethodInfo, Method>();
    private final Map<RubyRootNode, MethodVersion> rootNodeToMethodVersion = new HashMap<RubyRootNode, MethodVersion>();
    private final Map<RubyRootNode, Map<String, Set<String>>> localTypes = new HashMap<RubyRootNode, Map<String, Set<String>>>();

    public synchronized void registerRootNode(RubyRootNode rootNode) {
        this.rootNodeToMethodVersion(rootNode);
    }

    public synchronized void recordLocalWrite(RubyRootNode rootNode, String name, String type) {
        if (name.equals("foo_a") && type.equals("Object")) {
            throw new UnsupportedOperationException();
        }
        Map rootNodeLocalTypes = this.localTypes.computeIfAbsent(rootNode, k -> new HashMap());
        Set rootNodeLocalTypeSet = rootNodeLocalTypes.computeIfAbsent(name, k -> new HashSet());
        rootNodeLocalTypeSet.add(type);
    }

    public Method sharedMethodInfoToMethod(SharedMethodInfo sharedMethodInfo) {
        Method method = this.sharedMethodInfoToMethod.get(sharedMethodInfo);
        if (method == null) {
            method = new Method(this, sharedMethodInfo);
            this.sharedMethodInfoToMethod.put(sharedMethodInfo, method);
        }
        return method;
    }

    public MethodVersion rootNodeToMethodVersion(RubyRootNode rootNode) {
        MethodVersion methodVersion = this.rootNodeToMethodVersion.get((Object)rootNode);
        if (methodVersion == null) {
            methodVersion = new MethodVersion(this.sharedMethodInfoToMethod(rootNode.getSharedMethodInfo()), rootNode);
            this.rootNodeToMethodVersion.put(rootNode, methodVersion);
        }
        return methodVersion;
    }

    public Collection<Method> getMethods() {
        return Collections.unmodifiableCollection(this.sharedMethodInfoToMethod.values());
    }

    public Map<String, Set<String>> getLocalTypes(RubyRootNode rootNode) {
        Map<String, Set<String>> rootNodeLocalTypes = this.localTypes.get((Object)rootNode);
        if (rootNodeLocalTypes == null) {
            return Collections.emptyMap();
        }
        return rootNodeLocalTypes;
    }

    public void resolve() {
        this.rootNodeToMethodVersion.values().forEach(MethodVersion::resolve);
    }
}

