/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.joni.Region;
import org.joni.exception.ValueException;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.UnaryCoreMethodNode;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.core.array.ArrayUtils;
import org.jruby.truffle.core.cast.TaintResultNode;
import org.jruby.truffle.core.cast.ToIntNode;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringGuards;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.util.StringUtils;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

@CoreClass(value="MatchData")
public abstract class MatchDataNodes {
    public static Object[] getCaptures(DynamicObject matchData) {
        assert (RubyGuards.isRubyMatchData(matchData));
        return ArrayUtils.extractRange(Layouts.MATCH_DATA.getValues(matchData), 1, Layouts.MATCH_DATA.getValues(matchData).length);
    }

    public static Object begin(RubyContext context, DynamicObject matchData, int index) {
        int b = Layouts.MATCH_DATA.getRegion((DynamicObject)matchData).beg[index];
        if (b < 0) {
            return context.getCoreLibrary().getNilObject();
        }
        if (!StringGuards.isSingleByteOptimizable(Layouts.MATCH_DATA.getSource(matchData))) {
            b = MatchDataNodes.getCharOffsets((DynamicObject)matchData).beg[index];
        }
        return b;
    }

    public static Object end(RubyContext context, DynamicObject matchData, int index) {
        int e = Layouts.MATCH_DATA.getRegion((DynamicObject)matchData).end[index];
        if (e < 0) {
            return context.getCoreLibrary().getNilObject();
        }
        if (!StringGuards.isSingleByteOptimizable(Layouts.MATCH_DATA.getSource(matchData))) {
            e = MatchDataNodes.getCharOffsets((DynamicObject)matchData).end[index];
        }
        return e;
    }

    private static void updatePairs(ByteList source, Encoding encoding, Pair[] pairs) {
        int p;
        Arrays.sort(pairs);
        int length = pairs.length;
        byte[] bytes = source.getUnsafeBytes();
        int s = p = source.getBegin();
        int c = 0;
        for (int i = 0; i < length; ++i) {
            int q = s + pairs[i].bytePos;
            pairs[i].charPos = c += StringSupport.strLength((Encoding)encoding, (byte[])bytes, (int)p, (int)q);
            p = q;
        }
    }

    private static Region getCharOffsetsManyRegs(DynamicObject matchData, ByteList source, Encoding encoding) {
        Region regs = Layouts.MATCH_DATA.getRegion(matchData);
        int numRegs = regs.numRegs;
        Region charOffsets = new Region(numRegs);
        if (encoding.maxLength() == 1) {
            for (int i = 0; i < numRegs; ++i) {
                charOffsets.beg[i] = regs.beg[i];
                charOffsets.end[i] = regs.end[i];
            }
            return charOffsets;
        }
        Object[] pairs = new Pair[numRegs * 2];
        for (int i = 0; i < pairs.length; ++i) {
            pairs[i] = new Pair();
        }
        int numPos = 0;
        for (int i = 0; i < numRegs; ++i) {
            if (regs.beg[i] < 0) continue;
            pairs[numPos++].bytePos = regs.beg[i];
            pairs[numPos++].bytePos = regs.end[i];
        }
        MatchDataNodes.updatePairs(source, encoding, (Pair[])pairs);
        Pair key = new Pair();
        for (int i = 0; i < regs.numRegs; ++i) {
            if (regs.beg[i] < 0) {
                charOffsets.end[i] = -1;
                charOffsets.beg[i] = -1;
                continue;
            }
            key.bytePos = regs.beg[i];
            charOffsets.beg[i] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key)]).charPos;
            key.bytePos = regs.end[i];
            charOffsets.end[i] = ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key)]).charPos;
        }
        return charOffsets;
    }

    public static Region getCharOffsets(DynamicObject matchData) {
        Region charOffsets = Layouts.MATCH_DATA.getCharOffsets(matchData);
        if (charOffsets != null) {
            return charOffsets;
        }
        return MatchDataNodes.createCharOffsets(matchData);
    }

    @CompilerDirectives.TruffleBoundary
    private static Region createCharOffsets(DynamicObject matchData) {
        ByteList source = StringOperations.getByteListReadOnly(Layouts.MATCH_DATA.getSource(matchData));
        Encoding enc = source.getEncoding();
        Region charOffsets = MatchDataNodes.getCharOffsetsManyRegs(matchData, source, enc);
        Layouts.MATCH_DATA.setCharOffsets(matchData, charOffsets);
        return charOffsets;
    }

    public static final class Pair
    implements Comparable<Pair> {
        int bytePos;
        int charPos;

        @Override
        public int compareTo(Pair pair) {
            return this.bytePos - pair.bytePos;
        }
    }

    @NodeChild(value="self")
    public static abstract class RubiniusSourceNode
    extends RubyNode {
        @Specialization
        public DynamicObject rubiniusSource(DynamicObject matchData) {
            return Layouts.MATCH_DATA.getSource(matchData);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"regexp"})
    public static abstract class RegexpNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject regexp(DynamicObject matchData) {
            return Layouts.MATCH_DATA.getRegexp(matchData);
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject toS(DynamicObject matchData) {
            Rope rope = StringOperations.rope(Layouts.MATCH_DATA.getGlobal(matchData));
            return this.createString(rope);
        }
    }

    @CoreMethod(names={"to_a"})
    public static abstract class ToANode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject toA(DynamicObject matchData) {
            Object[] objects = ArrayUtils.copy(Layouts.MATCH_DATA.getValues(matchData));
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"post_match"})
    public static abstract class PostMatchNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintResultNode taintResultNode = new TaintResultNode(this.getContext(), this.getSourceSection());

        public PostMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object postMatch(DynamicObject matchData) {
            return this.taintResultNode.maybeTaint(Layouts.MATCH_DATA.getSource(matchData), Layouts.MATCH_DATA.getPost(matchData));
        }
    }

    @CoreMethod(names={"pre_match"})
    public static abstract class PreMatchNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TaintResultNode taintResultNode = new TaintResultNode(this.getContext(), this.getSourceSection());

        public PreMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object preMatch(DynamicObject matchData) {
            return this.taintResultNode.maybeTaint(Layouts.MATCH_DATA.getSource(matchData), Layouts.MATCH_DATA.getPre(matchData));
        }
    }

    @CoreMethod(names={"length", "size"})
    public static abstract class LengthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int length(DynamicObject matchData) {
            return Layouts.MATCH_DATA.getValues(matchData).length;
        }
    }

    @CoreMethod(names={"byte_end"}, required=1, lowerFixnum={1})
    public static abstract class ByteEndNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"inBounds(matchData, index)"})
        public Object byteEnd(DynamicObject matchData, int index) {
            int e = Layouts.MATCH_DATA.getRegion((DynamicObject)matchData).end[index];
            if (e < 0) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return e;
        }

        protected boolean inBounds(DynamicObject matchData, int index) {
            return index >= 0 && index < Layouts.MATCH_DATA.getRegion((DynamicObject)matchData).numRegs;
        }
    }

    @CoreMethod(names={"byte_begin"}, required=1, lowerFixnum={1})
    public static abstract class ByteBeginNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"inBounds(matchData, index)"})
        public Object byteBegin(DynamicObject matchData, int index) {
            int b = Layouts.MATCH_DATA.getRegion((DynamicObject)matchData).beg[index];
            if (b < 0) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return b;
        }

        protected boolean inBounds(DynamicObject matchData, int index) {
            return index >= 0 && index < Layouts.MATCH_DATA.getRegion((DynamicObject)matchData).numRegs;
        }
    }

    @CoreMethod(names={"end"}, required=1, lowerFixnum={1})
    public static abstract class EndNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"inBounds(matchData, index)"})
        public Object end(DynamicObject matchData, int index) {
            return MatchDataNodes.end(this.getContext(), matchData, index);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!inBounds(matchData, index)"})
        public Object endError(DynamicObject matchData, int index) {
            throw new RaiseException(this.coreExceptions().indexError(StringUtils.format("index %d out of matches", index), this));
        }

        protected boolean inBounds(DynamicObject matchData, int index) {
            return index >= 0 && index < Layouts.MATCH_DATA.getRegion((DynamicObject)matchData).numRegs;
        }
    }

    @CoreMethod(names={"captures"})
    public static abstract class CapturesNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toA(DynamicObject matchData) {
            Object[] objects = MatchDataNodes.getCaptures(matchData);
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"begin"}, required=1, lowerFixnum={1})
    public static abstract class BeginNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"inBounds(matchData, index)"})
        public Object begin(DynamicObject matchData, int index) {
            return MatchDataNodes.begin(this.getContext(), matchData, index);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!inBounds(matchData, index)"})
        public Object beginError(DynamicObject matchData, int index) {
            throw new RaiseException(this.coreExceptions().indexError(StringUtils.format("index %d out of matches", index), this));
        }

        protected boolean inBounds(DynamicObject matchData, int index) {
            return index >= 0 && index < Layouts.MATCH_DATA.getRegion((DynamicObject)matchData).numRegs;
        }
    }

    @CoreMethod(names={"[]"}, required=1, optional=1, lowerFixnum={1}, taintFrom=0)
    public static abstract class GetIndexNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToIntNode toIntNode;

        @Specialization
        public Object getIndex(DynamicObject matchData, int index, NotProvided length, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile) {
            Object[] values = Layouts.MATCH_DATA.getValues(matchData);
            int normalizedIndex = ArrayOperations.normalizeIndex(values.length, index);
            if (indexOutOfBoundsProfile.profile(normalizedIndex < 0 || normalizedIndex >= values.length)) {
                return this.nil();
            }
            return values[normalizedIndex];
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object getIndex(DynamicObject matchData, int index, int length) {
            Object[] values = Layouts.MATCH_DATA.getValues(matchData);
            int normalizedIndex = ArrayOperations.normalizeIndex(values.length, index);
            Object[] store = Arrays.copyOfRange(values, normalizedIndex, normalizedIndex + length);
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, length);
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubySymbol(index)"})
        public Object getIndexSymbol(DynamicObject matchData, DynamicObject index, NotProvided length, @Cached(value="create()") BranchProfile errorProfile, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile) {
            try {
                Rope value = Layouts.SYMBOL.getRope(index);
                int i = Layouts.REGEXP.getRegex(Layouts.MATCH_DATA.getRegexp(matchData)).nameToBackrefNumber(value.getBytes(), 0, value.byteLength(), Layouts.MATCH_DATA.getRegion(matchData));
                return this.getIndex(matchData, i, NotProvided.INSTANCE, indexOutOfBoundsProfile);
            }
            catch (ValueException e) {
                throw new RaiseException(this.coreExceptions().indexError(StringUtils.format("undefined group name reference: %s", Layouts.SYMBOL.getString(index)), this));
            }
        }

        @CompilerDirectives.TruffleBoundary(throwsControlFlowException=true)
        @Specialization(guards={"isRubyString(index)"})
        public Object getIndexString(DynamicObject matchData, DynamicObject index, NotProvided length, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile) {
            try {
                Rope value = StringOperations.rope(index);
                int i = Layouts.REGEXP.getRegex(Layouts.MATCH_DATA.getRegexp(matchData)).nameToBackrefNumber(value.getBytes(), 0, value.byteLength(), Layouts.MATCH_DATA.getRegion(matchData));
                return this.getIndex(matchData, i, NotProvided.INSTANCE, indexOutOfBoundsProfile);
            }
            catch (ValueException e) {
                throw new RaiseException(this.coreExceptions().indexError(StringUtils.format("undefined group name reference: %s", index.toString()), this));
            }
        }

        @Specialization(guards={"!isRubySymbol(index)", "!isRubyString(index)", "!isIntRange(index)"})
        public Object getIndex(VirtualFrame frame, DynamicObject matchData, Object index, NotProvided length, @Cached(value="createBinaryProfile()") ConditionProfile indexOutOfBoundsProfile) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toIntNode = (ToIntNode)this.insert(ToIntNode.create());
            }
            return this.getIndex(matchData, this.toIntNode.doInt(frame, index), NotProvided.INSTANCE, indexOutOfBoundsProfile);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isIntRange(range)"})
        public Object getIndex(DynamicObject matchData, DynamicObject range, NotProvided len) {
            Object[] values = Layouts.MATCH_DATA.getValues(matchData);
            int normalizedIndex = ArrayOperations.normalizeIndex(values.length, Layouts.INT_RANGE.getBegin(range));
            int end = ArrayOperations.normalizeIndex(values.length, Layouts.INT_RANGE.getEnd(range));
            int exclusiveEnd = ArrayOperations.clampExclusiveIndex(values.length, Layouts.INT_RANGE.getExcludedEnd(range) ? end : end + 1);
            int length = exclusiveEnd - normalizedIndex;
            Object[] store = Arrays.copyOfRange(values, normalizedIndex, normalizedIndex + length);
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, length);
        }
    }
}

