/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.locals.ReadFrameSlotNode;
import org.jruby.truffle.language.locals.ReadFrameSlotNodeGen;
import org.jruby.truffle.language.locals.WriteFrameSlotNode;
import org.jruby.truffle.language.locals.WriteFrameSlotNodeGen;

public class RunBlockKWArgsHelperNode
extends RubyNode {
    @Node.Child
    private ReadFrameSlotNode readArrayNode;
    @Node.Child
    private WriteFrameSlotNode writeArrayNode;
    @Node.Child
    private SnippetNode snippetNode;
    private final Object kwrestName;

    public RunBlockKWArgsHelperNode(FrameSlot arrayFrameSlot, Object kwrestName) {
        this.readArrayNode = ReadFrameSlotNodeGen.create(arrayFrameSlot);
        this.writeArrayNode = WriteFrameSlotNodeGen.create(arrayFrameSlot);
        this.kwrestName = kwrestName;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.bailout((String)"blocks with kwargs are not optimized yet");
        Object array = this.readArrayNode.executeRead((Frame)frame);
        if (this.snippetNode == null) {
            this.snippetNode = (SnippetNode)this.insert(new SnippetNode());
        }
        Object remainingArray = this.snippetNode.execute(frame, "Truffle.load_arguments_from_array_kw_helper(array, kwrest_name, binding)", "array", array, "kwrest_name", this.kwrestName, "binding", Layouts.BINDING.createBinding(this.coreLibrary().getBindingFactory(), frame.materialize()));
        this.writeArrayNode.executeWrite((Frame)frame, remainingArray);
        return this.nil();
    }
}

