/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DoesRespondDispatchHeadNode;

public class ReadUserKeywordsHashNode
extends RubyNode {
    private final int minArgumentCount;
    @Node.Child
    private DoesRespondDispatchHeadNode respondToToHashNode;
    @Node.Child
    private CallDispatchHeadNode callToHashNode;
    private final ConditionProfile notEnoughArgumentsProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile lastArgumentIsHashProfile = ConditionProfile.createBinaryProfile();

    public ReadUserKeywordsHashNode(int minArgumentCount) {
        this.minArgumentCount = minArgumentCount;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int argumentCount = RubyArguments.getArgumentsCount((Frame)frame);
        if (this.notEnoughArgumentsProfile.profile(argumentCount <= this.minArgumentCount)) {
            return null;
        }
        Object lastArgument = RubyArguments.getArgument((Frame)frame, argumentCount - 1);
        if (this.lastArgumentIsHashProfile.profile(RubyGuards.isRubyHash(lastArgument))) {
            return lastArgument;
        }
        CompilerDirectives.bailout((String)"Ruby keyword arguments aren't optimized yet");
        if (this.respondToToHashNode == null) {
            this.respondToToHashNode = (DoesRespondDispatchHeadNode)this.insert(new DoesRespondDispatchHeadNode(this.getContext(), false));
        }
        if (this.respondToToHashNode.doesRespondTo(frame, "to_hash", lastArgument)) {
            Object converted;
            if (this.callToHashNode == null) {
                this.callToHashNode = (CallDispatchHeadNode)this.insert(CallDispatchHeadNode.createMethodCall());
            }
            if (RubyGuards.isRubyHash(converted = this.callToHashNode.call(frame, lastArgument, "to_hash", null, new Object[0]))) {
                RubyArguments.setArgument((Frame)frame, argumentCount - 1, converted);
                return converted;
            }
        }
        return null;
    }
}

