/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.bigdecimal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.cast.IntegerCastNode;
import org.jruby.truffle.core.cast.IntegerCastNodeGen;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.stdlib.bigdecimal.AbstractAddNode;
import org.jruby.truffle.stdlib.bigdecimal.AbstractDivNode;
import org.jruby.truffle.stdlib.bigdecimal.AbstractMultNode;
import org.jruby.truffle.stdlib.bigdecimal.AbstractSubNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalCoreMethodArrayArgumentsNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalCoreMethodNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalOpNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalType;
import org.jruby.truffle.stdlib.bigdecimal.GetIntegerConstantNode;
import org.jruby.truffle.stdlib.bigdecimal.GetIntegerConstantNodeGen;

@CoreClass(value="Truffle::BigDecimal")
public abstract class BigDecimalNodes {

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return Layouts.BIG_DECIMAL.createBigDecimal(Layouts.CLASS.getInstanceFactory(rubyClass), BigDecimal.ZERO, BigDecimalType.NORMAL);
        }
    }

    @CoreMethod(names={"to_i", "to_int"})
    public static abstract class ToINode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        private BigInteger toBigInteger(BigDecimal bigDecimal) {
            return bigDecimal.toBigInteger();
        }

        @Specialization(guards={"isNormal(value)"})
        public Object toINormal(DynamicObject value, @Cached(value="new()") FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.fixnumOrBignum(this.toBigInteger(Layouts.BIG_DECIMAL.getValue(value)));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isNormal(value)"})
        public int toISpecial(DynamicObject value) {
            BigDecimalType type = Layouts.BIG_DECIMAL.getType(value);
            switch (type) {
                case NEGATIVE_INFINITY: {
                    throw new RaiseException(this.coreExceptions().floatDomainError(type.getRepresentation(), this));
                }
                case POSITIVE_INFINITY: {
                    throw new RaiseException(this.coreExceptions().floatDomainError(type.getRepresentation(), this));
                }
                case NAN: {
                    throw new RaiseException(this.coreExceptions().floatDomainError(type.getRepresentation(), this));
                }
                case NEGATIVE_ZERO: {
                    return 0;
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(value)));
        }
    }

    @CoreMethod(names={"unscaled"}, visibility=Visibility.PRIVATE)
    public static abstract class UnscaledNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public Object unscaled(DynamicObject value) {
            return this.createString(StringOperations.encodeRope(Layouts.BIG_DECIMAL.getValue(value).abs().stripTrailingZeros().unscaledValue().toString(), (Encoding)UTF8Encoding.INSTANCE));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isNormal(value)"})
        public Object unscaledSpecial(DynamicObject value) {
            String type = Layouts.BIG_DECIMAL.getType(value).getRepresentation();
            String string = type.startsWith("-") ? type.substring(1) : type;
            return this.createString(StringOperations.encodeRope(string, (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public double toFNormal(DynamicObject value) {
            return Layouts.BIG_DECIMAL.getValue(value).doubleValue();
        }

        @Specialization(guards={"!isNormal(value)"})
        public double toFSpecial(DynamicObject value, @Cached(value="create()") BranchProfile negInfinityProfile, @Cached(value="create()") BranchProfile posInfinityProfile, @Cached(value="create()") BranchProfile negZeroProfile, @Cached(value="create()") BranchProfile nanProfile) {
            switch (Layouts.BIG_DECIMAL.getType(value)) {
                case NEGATIVE_INFINITY: {
                    negInfinityProfile.enter();
                    return Double.NEGATIVE_INFINITY;
                }
                case POSITIVE_INFINITY: {
                    posInfinityProfile.enter();
                    return Double.POSITIVE_INFINITY;
                }
                case NEGATIVE_ZERO: {
                    negZeroProfile.enter();
                    return 0.0;
                }
                case NAN: {
                    nanProfile.enter();
                    return Double.NaN;
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(value)));
        }
    }

    @CoreMethod(names={"precs"})
    public static abstract class PrecsNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)"})
        public Object precsNormal(DynamicObject value) {
            BigDecimal bigDecimalValue = Layouts.BIG_DECIMAL.getValue(value).abs();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new int[]{bigDecimalValue.stripTrailingZeros().unscaledValue().toString().length(), PrecsNode.nearestBiggerMultipleOf4(bigDecimalValue.unscaledValue().toString().length())}, 2);
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object precsSpecial(DynamicObject value) {
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new int[]{1, 1}, 2);
        }
    }

    @CoreMethod(names={"infinite?"})
    public static abstract class InfiniteNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNormal(value)"})
        public Object infiniteNormal(DynamicObject value) {
            return this.nil();
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object infiniteSpecial(DynamicObject value) {
            switch (Layouts.BIG_DECIMAL.getType(value)) {
                case POSITIVE_INFINITY: {
                    return 1;
                }
                case NEGATIVE_INFINITY: {
                    return -1;
                }
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"finite?"})
    public static abstract class FiniteNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNormal(value)"})
        public boolean finiteNormal(DynamicObject value) {
            return true;
        }

        @Specialization(guards={"!isNormal(value)"})
        public boolean finiteSpecial(DynamicObject value) {
            switch (Layouts.BIG_DECIMAL.getType(value)) {
                case NAN: 
                case POSITIVE_INFINITY: 
                case NEGATIVE_INFINITY: {
                    return false;
                }
            }
            return true;
        }
    }

    @CoreMethod(names={"round"}, optional=2)
    public static abstract class RoundNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        private BigDecimal round(DynamicObject value, int digit, RoundingMode roundingMode) {
            BigDecimal valueBigDecimal = Layouts.BIG_DECIMAL.getValue(value);
            if (digit <= valueBigDecimal.scale()) {
                return valueBigDecimal.movePointRight(digit).setScale(0, roundingMode).movePointLeft(digit);
            }
            return valueBigDecimal;
        }

        @Specialization(guards={"isNormal(value)"})
        public Object round(VirtualFrame frame, DynamicObject value, NotProvided digit, NotProvided roundingMode, @Cached(value="new()") FixnumOrBignumNode fixnumOrBignumNode) {
            return fixnumOrBignumNode.fixnumOrBignum(this.round(value, 0, this.getRoundMode(frame)));
        }

        @Specialization(guards={"isNormal(value)"})
        public Object round(VirtualFrame frame, DynamicObject value, int digit, NotProvided roundingMode) {
            return this.createBigDecimal(frame, this.round(value, digit, this.getRoundMode(frame)));
        }

        @Specialization(guards={"isNormal(value)"})
        public Object round(VirtualFrame frame, DynamicObject value, int digit, int roundingMode) {
            return this.createBigDecimal(frame, this.round(value, digit, RoundNode.toRoundingMode(roundingMode)));
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object roundSpecial(DynamicObject value, NotProvided precision, Object unusedRoundingMode, @Cached(value="new()") FixnumOrBignumNode fixnumOrBignumNode, @Cached(value="create()") BranchProfile negInfinityProfile, @Cached(value="create()") BranchProfile posInfinityProfile, @Cached(value="create()") BranchProfile negZeroProfile, @Cached(value="create()") BranchProfile nanProfile) {
            switch (Layouts.BIG_DECIMAL.getType(value)) {
                case NEGATIVE_INFINITY: {
                    negInfinityProfile.enter();
                    throw new RaiseException(this.coreExceptions().floatDomainErrorResultsToNegInfinity(this));
                }
                case POSITIVE_INFINITY: {
                    posInfinityProfile.enter();
                    throw new RaiseException(this.coreExceptions().floatDomainErrorResultsToInfinity(this));
                }
                case NEGATIVE_ZERO: {
                    negZeroProfile.enter();
                    return fixnumOrBignumNode.fixnumOrBignum(Layouts.BIG_DECIMAL.getValue(value));
                }
                case NAN: {
                    nanProfile.enter();
                    throw new RaiseException(this.coreExceptions().floatDomainErrorResultsToNaN(this));
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(value)));
        }

        @Specialization(guards={"!isNormal(value)", "wasProvided(precision)"})
        public Object roundSpecial(DynamicObject value, Object precision, Object unusedRoundingMode) {
            return value;
        }
    }

    @CoreMethod(names={"abs"})
    public static abstract class AbsNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        private BigDecimal abs(DynamicObject value) {
            return Layouts.BIG_DECIMAL.getValue(value).abs();
        }

        @Specialization(guards={"isNormal(value)"})
        public Object abs(VirtualFrame frame, DynamicObject value) {
            return this.createBigDecimal(frame, this.abs(value));
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object absSpecial(VirtualFrame frame, DynamicObject value, @Cached(value="create()") BranchProfile negInfProfile, @Cached(value="create()") BranchProfile negZeroProfile, @Cached(value="create()") BranchProfile posInfProfile) {
            Object result;
            BigDecimalType type = Layouts.BIG_DECIMAL.getType(value);
            switch (type) {
                case NEGATIVE_INFINITY: {
                    negInfProfile.enter();
                    result = BigDecimalType.POSITIVE_INFINITY;
                    break;
                }
                case NEGATIVE_ZERO: {
                    negZeroProfile.enter();
                    result = BigDecimal.ZERO;
                    break;
                }
                case NAN: 
                case POSITIVE_INFINITY: {
                    posInfProfile.enter();
                    result = type;
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreter();
                    throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)type));
                }
            }
            return this.createBigDecimal(frame, result);
        }
    }

    @CoreMethod(names={"exponent"})
    public static abstract class ExponentNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNormal(value)", "!isNormalZero(value)"})
        public long exponent(DynamicObject value) {
            BigDecimal val = Layouts.BIG_DECIMAL.getValue(value).abs().stripTrailingZeros();
            return val.precision() - val.scale();
        }

        @Specialization(guards={"isNormal(value)", "isNormalZero(value)"})
        public int exponentZero(DynamicObject value) {
            return 0;
        }

        @Specialization(guards={"!isNormal(value)"})
        public int exponentSpecial(DynamicObject value) {
            return 0;
        }
    }

    @CoreMethod(names={"nan?"})
    public static abstract class NanNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNormal(value)"})
        public boolean nanNormal(DynamicObject value) {
            return false;
        }

        @Specialization(guards={"!isNormal(value)"})
        public boolean nanSpecial(DynamicObject value) {
            return Layouts.BIG_DECIMAL.getType(value) == BigDecimalType.NAN;
        }
    }

    @CoreMethod(names={"sign"})
    public static abstract class SignNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Node.Child
        private GetIntegerConstantNode sign;

        @Specialization(guards={"isNormal(value)", "isNormalZero(value)"})
        public int signNormalZero(VirtualFrame frame, DynamicObject value) {
            return this.getConstant(frame, "SIGN_POSITIVE_ZERO");
        }

        @Specialization(guards={"isNormal(value)", "!isNormalZero(value)"})
        public int signNormal(VirtualFrame frame, DynamicObject value, @Cached(value="createBinaryProfile()") ConditionProfile positiveProfile) {
            String name = positiveProfile.profile(Layouts.BIG_DECIMAL.getValue(value).signum() > 0) ? "SIGN_POSITIVE_FINITE" : "SIGN_NEGATIVE_FINITE";
            return this.getConstant(frame, name);
        }

        @Specialization(guards={"!isNormal(value)"})
        public int signSpecial(VirtualFrame frame, DynamicObject value) {
            String name;
            switch (Layouts.BIG_DECIMAL.getType(value)) {
                case NEGATIVE_INFINITY: {
                    name = "SIGN_NEGATIVE_INFINITE";
                    break;
                }
                case POSITIVE_INFINITY: {
                    name = "SIGN_POSITIVE_INFINITE";
                    break;
                }
                case NEGATIVE_ZERO: {
                    name = "SIGN_NEGATIVE_ZERO";
                    break;
                }
                case NAN: {
                    name = "SIGN_NaN";
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreter();
                    throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(value)));
                }
            }
            return this.getConstant(frame, name);
        }

        private int getConstant(VirtualFrame frame, String name) {
            if (this.sign == null) {
                CompilerDirectives.transferToInterpreter();
                this.sign = (GetIntegerConstantNode)this.insert(GetIntegerConstantNodeGen.create(null, null));
            }
            return this.sign.executeGetIntegerConstant(frame, this.getBigDecimalClass(), name);
        }
    }

    @CoreMethod(names={"zero?"})
    public static abstract class ZeroNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNormal(value)"})
        public boolean zeroNormal(DynamicObject value) {
            return Layouts.BIG_DECIMAL.getValue(value).compareTo(BigDecimal.ZERO) == 0;
        }

        @Specialization(guards={"!isNormal(value)"})
        public boolean zeroSpecial(DynamicObject value) {
            return Layouts.BIG_DECIMAL.getType(value) == BigDecimalType.NEGATIVE_ZERO;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        private int compareBigDecimal(DynamicObject a, BigDecimal b) {
            return Layouts.BIG_DECIMAL.getValue(a).compareTo(b);
        }

        @Specialization(guards={"isNormal(a)"})
        public int compare(DynamicObject a, long b) {
            return this.compareBigDecimal(a, BigDecimal.valueOf(b));
        }

        @Specialization(guards={"isNormal(a)"})
        public int compare(DynamicObject a, double b) {
            return this.compareBigDecimal(a, BigDecimal.valueOf(b));
        }

        @Specialization(guards={"isNormal(a)", "isRubyBignum(b)"})
        public int compare(DynamicObject a, DynamicObject b) {
            return this.compareBigDecimal(a, new BigDecimal(Layouts.BIGNUM.getValue(b)));
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public int compareNormal(DynamicObject a, DynamicObject b) {
            return this.compareBigDecimal(a, Layouts.BIG_DECIMAL.getValue(b));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object compareSpecial(VirtualFrame frame, DynamicObject a, long b) {
            return this.compareSpecial(a, this.createBigDecimal(frame, BigDecimal.valueOf(b)));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object compareSpecial(VirtualFrame frame, DynamicObject a, double b) {
            return this.compareSpecial(a, this.createBigDecimal(frame, BigDecimal.valueOf(b)));
        }

        @Specialization(guards={"!isNormal(a)", "isRubyBignum(b)"})
        public Object compareSpecialBignum(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.compareSpecial(a, this.createBigDecimal(frame, new BigDecimal(Layouts.BIGNUM.getValue(b))));
        }

        @Specialization(guards={"!isNormal(a)", "isNan(a)"})
        public Object compareSpecialNan(DynamicObject a, DynamicObject b) {
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)", "isNormal(a) || !isNan(a)"})
        public Object compareSpecial(DynamicObject a, DynamicObject b) {
            BigDecimalType aType = Layouts.BIG_DECIMAL.getType(a);
            BigDecimalType bType = Layouts.BIG_DECIMAL.getType(b);
            if (aType == BigDecimalType.NAN || bType == BigDecimalType.NAN) {
                return this.nil();
            }
            if (aType == bType) {
                return 0;
            }
            if (aType == BigDecimalType.POSITIVE_INFINITY || bType == BigDecimalType.NEGATIVE_INFINITY) {
                return 1;
            }
            if (aType == BigDecimalType.NEGATIVE_INFINITY || bType == BigDecimalType.POSITIVE_INFINITY) {
                return -1;
            }
            BigDecimal aCompare = aType == BigDecimalType.NEGATIVE_ZERO ? BigDecimal.ZERO : Layouts.BIG_DECIMAL.getValue(a);
            BigDecimal bCompare = bType == BigDecimalType.NEGATIVE_ZERO ? BigDecimal.ZERO : Layouts.BIG_DECIMAL.getValue(b);
            return aCompare.compareTo(bCompare);
        }

        @Specialization(guards={"isNil(b)"})
        public Object compareNil(DynamicObject a, DynamicObject b) {
            return this.nil();
        }

        @Specialization(guards={"!isRubyBigDecimal(b)", "!isNil(b)"})
        public Object compareCoerced(VirtualFrame frame, DynamicObject a, DynamicObject b, @Cached(value="new()") SnippetNode snippetNode) {
            return snippetNode.execute(frame, "redo_coerced :<=>, b", "b", b);
        }
    }

    @CoreMethod(names={"sqrt"}, required=1)
    @NodeChildren(value={@NodeChild(value="self", type=RubyNode.class), @NodeChild(value="precision", type=RubyNode.class)})
    public static abstract class SqrtNode
    extends BigDecimalCoreMethodNode {
        public abstract Object executeSqrt(VirtualFrame var1, DynamicObject var2, int var3);

        @CompilerDirectives.TruffleBoundary
        private BigDecimal sqrt(BigDecimal value, MathContext mathContext) {
            return RubyBigDecimal.bigSqrt((BigDecimal)value, (MathContext)mathContext);
        }

        @Specialization(guards={"precision < 0"})
        public Object sqrtNegativePrecision(VirtualFrame frame, DynamicObject a, int precision) {
            throw new RaiseException(this.coreExceptions().argumentError("precision must be positive", this));
        }

        @Specialization(guards={"precision == 0"})
        public Object sqrtZeroPrecision(VirtualFrame frame, DynamicObject a, int precision) {
            return this.executeSqrt(frame, a, 1);
        }

        @Specialization(guards={"isNormal(a)", "precision > 0"})
        public Object sqrt(VirtualFrame frame, DynamicObject a, int precision, @Cached(value="createBinaryProfile()") ConditionProfile positiveValueProfile) {
            BigDecimal valueBigDecimal = Layouts.BIG_DECIMAL.getValue(a);
            if (positiveValueProfile.profile(valueBigDecimal.signum() >= 0)) {
                return this.createBigDecimal(frame, this.sqrt(valueBigDecimal, new MathContext(precision, this.getRoundMode(frame))));
            }
            throw new RaiseException(this.coreExceptions().floatDomainErrorSqrtNegative(this));
        }

        @Specialization(guards={"!isNormal(a)", "precision > 0"})
        public Object sqrtSpecial(VirtualFrame frame, DynamicObject a, int precision, @Cached(value="create()") BranchProfile nanProfile, @Cached(value="create()") BranchProfile posInfProfile, @Cached(value="create()") BranchProfile negInfProfile, @Cached(value="create()") BranchProfile negZeroProfile) {
            switch (Layouts.BIG_DECIMAL.getType(a)) {
                case NAN: {
                    nanProfile.enter();
                    throw new RaiseException(this.coreExceptions().floatDomainErrorSqrtNegative(this));
                }
                case POSITIVE_INFINITY: {
                    posInfProfile.enter();
                    return this.createBigDecimal(frame, (Object)BigDecimalType.POSITIVE_INFINITY);
                }
                case NEGATIVE_INFINITY: {
                    negInfProfile.enter();
                    throw new RaiseException(this.coreExceptions().floatDomainErrorSqrtNegative(this));
                }
                case NEGATIVE_ZERO: {
                    negZeroProfile.enter();
                    return this.createBigDecimal(frame, this.sqrt(BigDecimal.ZERO, new MathContext(precision, this.getRoundMode(frame))));
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(a)));
        }
    }

    @CoreMethod(names={"**", "power"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(value="self", type=RubyNode.class), @NodeChild(value="exponent", type=RubyNode.class), @NodeChild(value="precision", type=RubyNode.class)})
    public static abstract class PowerNode
    extends BigDecimalCoreMethodNode {
        public abstract Object executePower(VirtualFrame var1, Object var2, Object var3, Object var4);

        @CompilerDirectives.TruffleBoundary
        private BigDecimal power(BigDecimal value, int exponent, MathContext mathContext) {
            return value.pow(exponent, mathContext);
        }

        @CompilerDirectives.TruffleBoundary
        private int getDigits(BigDecimal value) {
            return value.abs().unscaledValue().toString().length();
        }

        @Specialization(guards={"isNormal(a)"})
        public Object power(VirtualFrame frame, DynamicObject a, int exponent, NotProvided precision) {
            return this.executePower(frame, a, exponent, this.getLimit(frame));
        }

        @Specialization(guards={"isNormal(a)"})
        public Object power(VirtualFrame frame, DynamicObject a, int exponent, int precision, @Cached(value="createBinaryProfile()") ConditionProfile positiveExponentProfile, @Cached(value="createBinaryProfile()") ConditionProfile zeroProfile, @Cached(value="createBinaryProfile()") ConditionProfile zeroExponentProfile) {
            BigDecimal aBigDecimal = Layouts.BIG_DECIMAL.getValue(a);
            boolean positiveExponent = positiveExponentProfile.profile(exponent >= 0);
            if (zeroProfile.profile(aBigDecimal.compareTo(BigDecimal.ZERO) == 0)) {
                Object value = positiveExponent ? (zeroExponentProfile.profile(exponent == 0) ? BigDecimal.ONE : BigDecimal.ZERO) : BigDecimalType.POSITIVE_INFINITY;
                return this.createBigDecimal(frame, value);
            }
            int newPrecision = positiveExponent ? precision : (-exponent + 4) * (this.getDigits(aBigDecimal) + 4);
            return this.createBigDecimal(frame, this.power(Layouts.BIG_DECIMAL.getValue(a), exponent, new MathContext(newPrecision, this.getRoundMode(frame))));
        }

        @Specialization(guards={"!isNormal(a)"})
        public Object power(VirtualFrame frame, DynamicObject a, int exponent, Object unusedPrecision, @Cached(value="create()") BranchProfile nanProfile, @Cached(value="create()") BranchProfile posInfinityProfile, @Cached(value="create()") BranchProfile negInfinityProfile, @Cached(value="create()") BranchProfile negZeroProfile) {
            Object value;
            switch (Layouts.BIG_DECIMAL.getType(a)) {
                case NAN: {
                    nanProfile.enter();
                    value = BigDecimalType.NAN;
                    break;
                }
                case POSITIVE_INFINITY: {
                    posInfinityProfile.enter();
                    value = exponent >= 0 ? BigDecimalType.POSITIVE_INFINITY : BigDecimal.ZERO;
                    break;
                }
                case NEGATIVE_INFINITY: {
                    negInfinityProfile.enter();
                    value = Integer.signum(exponent) == 1 ? (exponent % 2 == 0 ? BigDecimalType.POSITIVE_INFINITY : BigDecimalType.NEGATIVE_INFINITY) : BigDecimal.ZERO;
                    break;
                }
                case NEGATIVE_ZERO: {
                    negZeroProfile.enter();
                    value = Integer.signum(exponent) == 1 ? BigDecimal.ZERO : BigDecimalType.NAN;
                    break;
                }
                default: {
                    CompilerDirectives.transferToInterpreter();
                    throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(a)));
                }
            }
            return this.createBigDecimal(frame, value);
        }
    }

    @CoreMethod(names={"modulo", "%"}, required=1)
    public static abstract class ModuloNode
    extends BigDecimalOpNode {
        @CompilerDirectives.TruffleBoundary
        public static BigDecimal moduloBigDecimal(BigDecimal a, BigDecimal b) {
            BigDecimal modulo = a.remainder(b);
            if (modulo.signum() * b.signum() < 0) {
                return modulo.add(b);
            }
            return modulo;
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "!isNormalZero(b)"})
        public Object modulo(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.createBigDecimal(frame, ModuloNode.moduloBigDecimal(Layouts.BIG_DECIMAL.getValue(a), Layouts.BIG_DECIMAL.getValue(b)));
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "isNormalZero(b)"})
        public Object moduloZero(DynamicObject a, DynamicObject b) {
            throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object moduloSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, @Cached(value="createBinaryProfile()") ConditionProfile nanProfile, @Cached(value="createBinaryProfile()") ConditionProfile normalNegProfile, @Cached(value="createBinaryProfile()") ConditionProfile negNormalProfile, @Cached(value="createBinaryProfile()") ConditionProfile posNegInfProfile, @Cached(value="createBinaryProfile()") ConditionProfile negPosInfProfile) {
            BigDecimalType aType = Layouts.BIG_DECIMAL.getType(a);
            BigDecimalType bType = Layouts.BIG_DECIMAL.getType(b);
            if (nanProfile.profile(aType == BigDecimalType.NAN || bType == BigDecimalType.NAN)) {
                return this.createBigDecimal(frame, (Object)BigDecimalType.NAN);
            }
            if (normalNegProfile.profile(bType == BigDecimalType.NEGATIVE_ZERO || bType == BigDecimalType.NORMAL && ModuloNode.isNormalZero(b))) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            if (negNormalProfile.profile(aType == BigDecimalType.NEGATIVE_ZERO || aType == BigDecimalType.NORMAL && ModuloNode.isNormalZero(a))) {
                return this.createBigDecimal(frame, BigDecimal.ZERO);
            }
            if (posNegInfProfile.profile(aType == BigDecimalType.POSITIVE_INFINITY || aType == BigDecimalType.NEGATIVE_INFINITY)) {
                return this.createBigDecimal(frame, (Object)BigDecimalType.NAN);
            }
            if (negPosInfProfile.profile(bType == BigDecimalType.POSITIVE_INFINITY || bType == BigDecimalType.NEGATIVE_INFINITY)) {
                return this.createBigDecimal(frame, a);
            }
            throw new UnsupportedOperationException("unreachable code branch");
        }
    }

    @CoreMethod(names={"remainder"}, required=1)
    public static abstract class RemainderNode
    extends BigDecimalOpNode {
        @CompilerDirectives.TruffleBoundary
        public static BigDecimal remainderBigDecimal(BigDecimal a, BigDecimal b) {
            return a.remainder(b);
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "!isNormalZero(b)"})
        public Object remainder(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.createBigDecimal(frame, RemainderNode.remainderBigDecimal(Layouts.BIG_DECIMAL.getValue(a), Layouts.BIG_DECIMAL.getValue(b)));
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "isNormalZero(b)"})
        public Object remainderZero(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.createBigDecimal(frame, (Object)BigDecimalType.NAN);
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object remainderSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, @Cached(value="createBinaryProfile()") ConditionProfile zeroProfile) {
            BigDecimalType aType = Layouts.BIG_DECIMAL.getType(a);
            BigDecimalType bType = Layouts.BIG_DECIMAL.getType(b);
            if (zeroProfile.profile(aType == BigDecimalType.NEGATIVE_ZERO && bType == BigDecimalType.NORMAL)) {
                return this.createBigDecimal(frame, BigDecimal.ZERO);
            }
            return this.createBigDecimal(frame, (Object)BigDecimalType.NAN);
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends BigDecimalOpNode {
        @CompilerDirectives.TruffleBoundary
        private BigDecimal[] divmodBigDecimal(BigDecimal a, BigDecimal b) {
            BigDecimal[] result = a.divideAndRemainder(b);
            if (result[1].signum() * b.signum() < 0) {
                result[0] = result[0].subtract(BigDecimal.ONE);
                result[1] = result[1].add(b);
            }
            return result;
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "!isNormalZero(a)", "!isNormalZero(b)"})
        public Object divmod(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            BigDecimal[] result = this.divmodBigDecimal(Layouts.BIG_DECIMAL.getValue(a), Layouts.BIG_DECIMAL.getValue(b));
            Object[] store = new Object[]{this.createBigDecimal(frame, result[0]), this.createBigDecimal(frame, result[1])};
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "isNormalZero(a)", "!isNormalZero(b)"})
        public Object divmodZeroDividend(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            Object[] store = new Object[]{this.createBigDecimal(frame, BigDecimal.ZERO), this.createBigDecimal(frame, BigDecimal.ZERO)};
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)", "isNormalZero(b)"})
        public Object divmodZeroDivisor(DynamicObject a, DynamicObject b) {
            throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object divmodSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, @Cached(value="createMethodCall()") CallDispatchHeadNode signCall, @Cached(value="createIntegerCastNode()") IntegerCastNode signIntegerCast, @Cached(value="createBinaryProfile()") ConditionProfile nanProfile, @Cached(value="createBinaryProfile()") ConditionProfile normalNegProfile, @Cached(value="createBinaryProfile()") ConditionProfile negNormalProfile, @Cached(value="createBinaryProfile()") ConditionProfile infinityProfile) {
            BigDecimalType aType = Layouts.BIG_DECIMAL.getType(a);
            BigDecimalType bType = Layouts.BIG_DECIMAL.getType(b);
            if (nanProfile.profile(aType == BigDecimalType.NAN || bType == BigDecimalType.NAN)) {
                Object[] store = new Object[]{this.createBigDecimal(frame, (Object)BigDecimalType.NAN), this.createBigDecimal(frame, (Object)BigDecimalType.NAN)};
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
            }
            if (nanProfile.profile(bType == BigDecimalType.NEGATIVE_ZERO || bType == BigDecimalType.NORMAL && DivModNode.isNormalZero(b))) {
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            if (normalNegProfile.profile(aType == BigDecimalType.NEGATIVE_ZERO || aType == BigDecimalType.NORMAL && DivModNode.isNormalZero(a))) {
                Object[] store = new Object[]{this.createBigDecimal(frame, BigDecimal.ZERO), this.createBigDecimal(frame, BigDecimal.ZERO)};
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
            }
            if (negNormalProfile.profile(aType == BigDecimalType.POSITIVE_INFINITY || aType == BigDecimalType.NEGATIVE_INFINITY)) {
                int signA = aType == BigDecimalType.POSITIVE_INFINITY ? 1 : -1;
                int signB = Integer.signum(signIntegerCast.executeCastInt(signCall.call(frame, b, "sign", null, new Object[0])));
                int sign = signA * signB;
                BigDecimalType type = (new BigDecimalType[]{BigDecimalType.NEGATIVE_INFINITY, BigDecimalType.NAN, BigDecimalType.POSITIVE_INFINITY})[sign + 1];
                Object[] store = new Object[]{this.createBigDecimal(frame, (Object)type), this.createBigDecimal(frame, (Object)BigDecimalType.NAN)};
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
            }
            if (infinityProfile.profile(bType == BigDecimalType.POSITIVE_INFINITY || bType == BigDecimalType.NEGATIVE_INFINITY)) {
                Object[] store = new Object[]{this.createBigDecimal(frame, BigDecimal.ZERO), this.createBigDecimal(frame, a)};
                return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
            }
            throw new UnsupportedOperationException("unreachable code branch");
        }

        protected IntegerCastNode createIntegerCastNode() {
            return IntegerCastNodeGen.create(null, null, null);
        }
    }

    @CoreMethod(names={"div"}, required=1, optional=1)
    @NodeChild(value="precision", type=RubyNode.class)
    public static abstract class DivNode
    extends AbstractDivNode {
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object div(VirtualFrame frame, DynamicObject a, DynamicObject b, NotProvided precision, @Cached(value="createBinaryProfile()") ConditionProfile bZeroProfile, @Cached(value="createMethodCall()") CallDispatchHeadNode floorNode) {
            if (bZeroProfile.profile(DivNode.isNormalZero(b))) {
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            Object result = this.div(frame, a, b, 0);
            return floorNode.call(frame, result, "floor", null, new Object[0]);
        }

        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object div(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision, @Cached(value="createBinaryProfile()") ConditionProfile zeroPrecisionProfile) {
            int newPrecision = zeroPrecisionProfile.profile(precision == 0) ? DivNode.defaultDivisionPrecision(Layouts.BIG_DECIMAL.getValue(a), Layouts.BIG_DECIMAL.getValue(b), this.getLimit(frame)) : precision;
            return super.div(frame, a, b, newPrecision);
        }

        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, NotProvided precision, @Cached(value="createBinaryProfile()") ConditionProfile negativeZeroProfile, @Cached(value="createBinaryProfile()") ConditionProfile nanProfile) {
            if (negativeZeroProfile.profile(Layouts.BIG_DECIMAL.getType(b) == BigDecimalType.NEGATIVE_ZERO)) {
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            if (nanProfile.profile(Layouts.BIG_DECIMAL.getType(b) == BigDecimalType.NAN)) {
                throw new RaiseException(this.coreExceptions().floatDomainErrorResultsToNaN(this));
            }
            return this.divNormalSpecial(frame, a, b, 0);
        }

        @Override
        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.divNormalSpecial(frame, a, b, precision);
        }

        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object divSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, NotProvided precision, @Cached(value="createBinaryProfile()") ConditionProfile zeroDivisionProfile, @Cached(value="createBinaryProfile()") ConditionProfile nanProfile, @Cached(value="createBinaryProfile()") ConditionProfile infinityProfile) {
            if (zeroDivisionProfile.profile(DivNode.isNormalZero(b))) {
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            if (nanProfile.profile(Layouts.BIG_DECIMAL.getType(a) == BigDecimalType.NAN)) {
                throw new RaiseException(this.coreExceptions().floatDomainErrorResultsToNaN(this));
            }
            if (infinityProfile.profile(Layouts.BIG_DECIMAL.getType(a) == BigDecimalType.POSITIVE_INFINITY || Layouts.BIG_DECIMAL.getType(a) == BigDecimalType.NEGATIVE_INFINITY)) {
                throw new RaiseException(this.coreExceptions().floatDomainErrorResultsToInfinity(this));
            }
            return this.divSpecialNormal(frame, a, b, 0);
        }

        @Override
        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object divSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.divSpecialNormal(frame, a, b, precision);
        }

        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divSpecialSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, NotProvided precision, @Cached(value="createBinaryProfile()") ConditionProfile negZeroProfile, @Cached(value="createBinaryProfile()") ConditionProfile nanProfile) {
            if (negZeroProfile.profile(Layouts.BIG_DECIMAL.getType(b) == BigDecimalType.NEGATIVE_ZERO)) {
                throw new RaiseException(this.coreExceptions().zeroDivisionError(this));
            }
            if (nanProfile.profile(Layouts.BIG_DECIMAL.getType(a) == BigDecimalType.NAN || Layouts.BIG_DECIMAL.getType(b) == BigDecimalType.NAN)) {
                throw new RaiseException(this.coreExceptions().floatDomainErrorResultsToNaN(this));
            }
            return this.divSpecialSpecial(frame, a, b, 0);
        }

        @Override
        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divSpecialSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.divSpecialSpecial(frame, a, b, precision);
        }
    }

    @CoreMethod(names={"/", "quo"}, required=1)
    public static abstract class DivOpNode
    extends AbstractDivNode {
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object div(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            int precision = DivOpNode.defaultDivisionPrecision(Layouts.BIG_DECIMAL.getValue(a), Layouts.BIG_DECIMAL.getValue(b), this.getLimit(frame));
            return this.div(frame, a, b, precision);
        }

        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.divNormalSpecial(frame, a, b, 0);
        }

        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object divSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.divSpecialNormal(frame, a, b, 0);
        }

        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object divSpecialSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.divSpecialSpecial(frame, a, b, 0);
        }
    }

    @CoreMethod(names={"mult"}, required=2)
    @NodeChild(value="precision", type=RubyNode.class)
    public static abstract class MultNode
    extends AbstractMultNode {
        @Override
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object mult(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.mult(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object multNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.multNormalSpecial(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object multSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.multSpecialNormal(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object multSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.multSpecial(frame, a, b, precision);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MultOpNode
    extends AbstractMultNode {
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object mult(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.mult(frame, a, b, this.getLimit(frame));
        }

        @Specialization(guards={"isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object multNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.multSpecialNormal(frame, b, a, 0);
        }

        @Specialization(guards={"!isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object multSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.multSpecialNormal(frame, a, b, 0);
        }

        @Specialization(guards={"!isNormal(a)", "isSpecialRubyBigDecimal(b)"})
        public Object multSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.multSpecial(frame, a, b, 0);
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Specialization(guards={"isNormal(value)", "!isNormalZero(value)"})
        public Object negNormal(VirtualFrame frame, DynamicObject value) {
            return this.createBigDecimal(frame, Layouts.BIG_DECIMAL.getValue(value).negate());
        }

        @Specialization(guards={"isNormal(value)", "isNormalZero(value)"})
        public Object negNormalZero(VirtualFrame frame, DynamicObject value) {
            return this.createBigDecimal(frame, (Object)BigDecimalType.NEGATIVE_ZERO);
        }

        @Specialization(guards={"!isNormal(value)"})
        public Object negSpecial(VirtualFrame frame, DynamicObject value, @Cached(value="createBinaryProfile()") ConditionProfile nanProfile, @Cached(value="createBinaryProfile()") ConditionProfile negZeroProfile, @Cached(value="createBinaryProfile()") ConditionProfile infProfile) {
            BigDecimalType type = Layouts.BIG_DECIMAL.getType(value);
            if (nanProfile.profile(type == BigDecimalType.NAN)) {
                return value;
            }
            if (negZeroProfile.profile(type == BigDecimalType.NEGATIVE_ZERO)) {
                return this.createBigDecimal(frame, BigDecimal.ZERO);
            }
            BigDecimalType resultType = infProfile.profile(type == BigDecimalType.NEGATIVE_INFINITY) ? BigDecimalType.POSITIVE_INFINITY : BigDecimalType.NEGATIVE_INFINITY;
            return this.createBigDecimal(frame, (Object)resultType);
        }
    }

    @CoreMethod(names={"sub"}, required=2)
    @NodeChild(value="precision", type=RubyNode.class)
    public static abstract class SubNode
    extends AbstractSubNode {
        @Override
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object subNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.subNormal(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object subSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.subSpecial(frame, a, b, precision);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubOpNode
    extends AbstractSubNode {
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object subNormal(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.subNormal(frame, a, b, this.getLimit(frame));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object subSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.subSpecial(frame, a, b, 0);
        }
    }

    @CoreMethod(names={"add"}, required=2)
    @NodeChild(value="precision", type=RubyNode.class)
    public static abstract class AddNode
    extends AbstractAddNode {
        @Override
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        protected Object add(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.add(frame, a, b, precision);
        }

        @Override
        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        protected Object addSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
            return super.addSpecial(frame, a, b, precision);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddOpNode
    extends AbstractAddNode {
        @Specialization(guards={"isNormal(a)", "isNormalRubyBigDecimal(b)"})
        public Object add(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.add(frame, a, b, this.getLimit(frame));
        }

        @Specialization(guards={"isRubyBigDecimal(b)", "!isNormal(a) || !isNormal(b)"})
        public Object addSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b) {
            return this.addSpecial(frame, a, b, 0);
        }
    }

    @CoreMethod(names={"initialize"}, required=1, optional=1)
    public static abstract class InitializeNode
    extends BigDecimalCoreMethodArrayArgumentsNode {
        @Specialization
        public Object initialize(VirtualFrame frame, DynamicObject self, Object value, NotProvided digits) {
            return this.initializeBigDecimal(frame, value, self, digits);
        }

        @Specialization
        public Object initialize(VirtualFrame frame, DynamicObject self, Object value, int digits) {
            return this.initializeBigDecimal(frame, value, self, digits);
        }
    }
}

