/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.bigdecimal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.math.BigDecimal;
import java.math.MathContext;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalOpNode;
import org.jruby.truffle.stdlib.bigdecimal.BigDecimalType;

public abstract class AbstractDivNode
extends BigDecimalOpNode {
    private final ConditionProfile normalZero = ConditionProfile.createBinaryProfile();

    private Object divBigDecimalConsideringSignum(DynamicObject a, DynamicObject b, MathContext mathContext) {
        BigDecimal aBigDecimal = Layouts.BIG_DECIMAL.getValue(a);
        BigDecimal bBigDecimal = Layouts.BIG_DECIMAL.getValue(b);
        if (this.normalZero.profile(bBigDecimal.signum() == 0)) {
            switch (aBigDecimal.signum()) {
                case 1: {
                    return BigDecimalType.POSITIVE_INFINITY;
                }
                case 0: {
                    return BigDecimalType.NAN;
                }
                case -1: {
                    return BigDecimalType.NEGATIVE_INFINITY;
                }
            }
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("unreachable code branch for value: " + aBigDecimal.signum());
        }
        return this.divBigDecimal(aBigDecimal, bBigDecimal, mathContext);
    }

    @CompilerDirectives.TruffleBoundary
    private BigDecimal divBigDecimal(BigDecimal a, BigDecimal b, MathContext mathContext) {
        return a.divide(b, mathContext);
    }

    protected Object div(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
        return this.createBigDecimal(frame, this.divBigDecimalConsideringSignum(a, b, new MathContext(precision, this.getRoundMode(frame))));
    }

    protected Object divNormalSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
        Object value = null;
        switch (Layouts.BIG_DECIMAL.getType(b)) {
            case NAN: {
                value = BigDecimalType.NAN;
                break;
            }
            case NEGATIVE_ZERO: {
                switch (Layouts.BIG_DECIMAL.getValue(a).signum()) {
                    case 1: {
                        value = BigDecimalType.NEGATIVE_INFINITY;
                        break;
                    }
                    case 0: {
                        value = BigDecimalType.NAN;
                        break;
                    }
                    case -1: {
                        value = BigDecimalType.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            case POSITIVE_INFINITY: {
                switch (Layouts.BIG_DECIMAL.getValue(a).signum()) {
                    case 0: 
                    case 1: {
                        value = BigDecimal.ZERO;
                        break;
                    }
                    case -1: {
                        value = BigDecimalType.NEGATIVE_ZERO;
                    }
                }
                break;
            }
            case NEGATIVE_INFINITY: {
                switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                    case 1: {
                        value = BigDecimalType.NEGATIVE_ZERO;
                        break;
                    }
                    case -1: 
                    case 0: {
                        value = BigDecimal.ZERO;
                    }
                }
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(b)));
            }
        }
        return this.createBigDecimal(frame, value);
    }

    protected Object divSpecialNormal(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
        Object value = null;
        switch (Layouts.BIG_DECIMAL.getType(a)) {
            case NAN: {
                value = BigDecimalType.NAN;
                break;
            }
            case NEGATIVE_ZERO: {
                switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                    case 1: {
                        value = BigDecimalType.NEGATIVE_ZERO;
                        break;
                    }
                    case 0: {
                        value = BigDecimalType.NAN;
                        break;
                    }
                    case -1: {
                        value = BigDecimal.ZERO;
                    }
                }
                break;
            }
            case POSITIVE_INFINITY: {
                switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                    case 0: 
                    case 1: {
                        value = BigDecimalType.POSITIVE_INFINITY;
                        break;
                    }
                    case -1: {
                        value = BigDecimalType.NEGATIVE_INFINITY;
                    }
                }
                break;
            }
            case NEGATIVE_INFINITY: {
                switch (Layouts.BIG_DECIMAL.getValue(b).signum()) {
                    case 0: 
                    case 1: {
                        value = BigDecimalType.NEGATIVE_INFINITY;
                        break;
                    }
                    case -1: {
                        value = BigDecimalType.POSITIVE_INFINITY;
                    }
                }
                break;
            }
            default: {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException("unreachable code branch for value: " + (Object)((Object)Layouts.BIG_DECIMAL.getType(a)));
            }
        }
        return this.createBigDecimal(frame, value);
    }

    protected Object divSpecialSpecial(VirtualFrame frame, DynamicObject a, DynamicObject b, int precision) {
        BigDecimalType aType = Layouts.BIG_DECIMAL.getType(a);
        BigDecimalType bType = Layouts.BIG_DECIMAL.getType(b);
        if (aType == BigDecimalType.NAN || bType == BigDecimalType.NAN || aType == BigDecimalType.NEGATIVE_ZERO && bType == BigDecimalType.NEGATIVE_ZERO) {
            return this.createBigDecimal(frame, (Object)BigDecimalType.NAN);
        }
        if (aType == BigDecimalType.NEGATIVE_ZERO) {
            if (bType == BigDecimalType.POSITIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)BigDecimalType.NEGATIVE_ZERO);
            }
            return this.createBigDecimal(frame, (Object)BigDecimalType.POSITIVE_INFINITY);
        }
        if (bType == BigDecimalType.NEGATIVE_ZERO) {
            if (aType == BigDecimalType.POSITIVE_INFINITY) {
                return this.createBigDecimal(frame, (Object)BigDecimalType.NEGATIVE_INFINITY);
            }
            return this.createBigDecimal(frame, (Object)BigDecimalType.POSITIVE_INFINITY);
        }
        return this.createBigDecimal(frame, (Object)BigDecimalType.NAN);
    }
}

