/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.Ptr;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.EConvResult;
import org.jcodings.transcode.TranscoderDB;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;
import org.jruby.Ruby;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rope.RopeNodes;
import org.jruby.truffle.core.rope.RopeNodesFactory;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;

@CoreClass(value="Encoding::Converter")
public abstract class EncodingConverterNodes {
    public static DynamicObject createEncodingConverter(DynamicObject rubyClass, EConv econv) {
        return Layouts.ENCODING_CONVERTER.createEncodingConverter(Layouts.CLASS.getInstanceFactory(rubyClass), econv);
    }

    @Primitive(name="encoding_converter_primitive_errinfo")
    public static abstract class EncodingConverterErrinfoNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object encodingConverterLastError(DynamicObject encodingConverter) {
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            Object[] ret = new Object[]{this.getSymbol(ec.lastError.getResult().symbolicName()), this.nil(), this.nil(), this.nil(), this.nil()};
            if (ec.lastError.getSource() != null) {
                ret[1] = this.createString(new ByteList(ec.lastError.getSource()));
            }
            if (ec.lastError.getDestination() != null) {
                ret[2] = this.createString(new ByteList(ec.lastError.getDestination()));
            }
            if (ec.lastError.getErrorBytes() != null) {
                ret[3] = this.createString(new ByteList(ec.lastError.getErrorBytes(), ec.lastError.getErrorBytesP(), ec.lastError.getErrorBytesLength()));
                ret[4] = this.createString(new ByteList(ec.lastError.getErrorBytes(), ec.lastError.getErrorBytesP() + ec.lastError.getErrorBytesLength(), ec.lastError.getReadAgainLength()));
            }
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), ret, ret.length);
        }
    }

    @Primitive(name="encoding_converter_last_error")
    public static abstract class EncodingConverterLastErrorNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;

        public EncodingConverterLastErrorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.newLookupTableNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupTableWriteNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object encodingConverterLastError(VirtualFrame frame, DynamicObject encodingConverter) {
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            EConv.LastError lastError = ec.lastError;
            if (lastError.getResult() != EConvResult.InvalidByteSequence && lastError.getResult() != EConvResult.IncompleteInput && lastError.getResult() != EConvResult.UndefinedConversion) {
                return this.nil();
            }
            Object ret = this.newLookupTableNode.call(frame, this.coreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("result"), this.eConvResultToSymbol(lastError.getResult()));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("source_encoding_name"), this.createString(new ByteList(lastError.getSource())));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("destination_encoding_name"), this.createString(new ByteList(lastError.getDestination())));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("error_bytes"), this.createString(new ByteList(lastError.getErrorBytes())));
            if (lastError.getReadAgainLength() != 0) {
                this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("read_again_bytes"), lastError.getReadAgainLength());
            }
            return ret;
        }

        private DynamicObject eConvResultToSymbol(EConvResult result) {
            switch (result) {
                case InvalidByteSequence: {
                    return this.getSymbol("invalid_byte_sequence");
                }
                case UndefinedConversion: {
                    return this.getSymbol("undefined_conversion");
                }
                case DestinationBufferFull: {
                    return this.getSymbol("destination_buffer_full");
                }
                case SourceBufferEmpty: {
                    return this.getSymbol("source_buffer_empty");
                }
                case Finished: {
                    return this.getSymbol("finished");
                }
                case AfterOutput: {
                    return this.getSymbol("after_output");
                }
                case IncompleteInput: {
                    return this.getSymbol("incomplete_input");
                }
            }
            throw new UnsupportedOperationException(String.format("Unknown EConv result: %s", result));
        }
    }

    @Primitive(name="encoding_converter_putback")
    public static abstract class EncodingConverterPutbackNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject encodingConverterPutback(DynamicObject encodingConverter, int maxBytes) {
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            int putbackable = ec.putbackable();
            return this.putback(encodingConverter, putbackable < maxBytes ? putbackable : maxBytes);
        }

        @Specialization
        public DynamicObject encodingConverterPutback(DynamicObject encodingConverter, NotProvided maxBytes) {
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            return this.putback(encodingConverter, ec.putbackable());
        }

        private DynamicObject putback(DynamicObject encodingConverter, int n) {
            assert (RubyGuards.isRubyEncodingConverter(encodingConverter));
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            ByteList bytes = new ByteList(n);
            ec.putback(bytes.getUnsafeBytes(), bytes.getBegin(), n);
            bytes.setRealSize(n);
            if (ec.sourceEncoding != null) {
                bytes.setEncoding(ec.sourceEncoding);
            }
            return this.createString(bytes);
        }
    }

    @Primitive(name="encoding_converter_primitive_convert")
    public static abstract class PrimitiveConvertNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private RopeNodes.MakeSubstringNode makeSubstringNode = RopeNodesFactory.MakeSubstringNodeGen.create(null, null, null);

        public PrimitiveConvertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyString(target)", "isRubyHash(options)"})
        public Object encodingConverterPrimitiveConvert(DynamicObject encodingConverter, DynamicObject source, DynamicObject target, int offset, int size, DynamicObject options) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Specialization(guards={"isNil(source)", "isRubyString(target)"})
        public Object primitiveConvertNilSource(DynamicObject encodingConverter, DynamicObject source, DynamicObject target, int offset, int size, int options) {
            return this.primitiveConvertHelper(encodingConverter, source, target, offset, size, options);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyString(target)"})
        public Object encodingConverterPrimitiveConvert(DynamicObject encodingConverter, DynamicObject source, DynamicObject target, int offset, int size, int options) {
            return this.primitiveConvertHelper(encodingConverter, source, target, offset, size, options);
        }

        @CompilerDirectives.TruffleBoundary
        private Object primitiveConvertHelper(DynamicObject encodingConverter, DynamicObject source, DynamicObject target, int offset, int size, int options) {
            EConvResult res;
            boolean growOutputBuffer;
            boolean nonNullSource = source != this.nil();
            Rope sourceRope = nonNullSource ? StringOperations.rope(source) : RopeConstants.EMPTY_UTF8_ROPE;
            Rope targetRope = StringOperations.rope(target);
            ByteList outBytes = RopeOperations.toByteListCopy(targetRope);
            Ptr inPtr = new Ptr();
            Ptr outPtr = new Ptr();
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            boolean changeOffset = offset == 0;
            boolean bl = growOutputBuffer = size == -1;
            if (size == -1) {
                size = 16;
                if (nonNullSource && size < sourceRope.byteLength()) {
                    size = sourceRope.byteLength();
                }
            }
            while (true) {
                if (changeOffset) {
                    offset = outBytes.getRealSize();
                }
                if (outBytes.getRealSize() < offset) {
                    throw new RaiseException(this.coreExceptions().argumentError("output offset too big", this));
                }
                long outputByteEnd = offset + size;
                if (outputByteEnd > Integer.MAX_VALUE) {
                    throw new RaiseException(this.coreExceptions().argumentError("output offset + bytesize too big", this));
                }
                outBytes.ensure((int)outputByteEnd);
                inPtr.p = 0;
                outPtr.p = offset;
                int os = outPtr.p + size;
                res = ec.convert(sourceRope.getBytes(), inPtr, sourceRope.byteLength() + inPtr.p, outBytes.getUnsafeBytes(), outPtr, os, options);
                outBytes.setRealSize(outPtr.p - outBytes.begin());
                if (nonNullSource) {
                    sourceRope = this.makeSubstringNode.executeMake(sourceRope, inPtr.p, sourceRope.byteLength() - inPtr.p);
                    StringOperations.setRope(source, sourceRope);
                }
                if (!growOutputBuffer || res != EConvResult.DestinationBufferFull) break;
                if (0x3FFFFFFF < size) {
                    throw new RaiseException(this.coreExceptions().argumentError("too long conversion result", this));
                }
                size *= 2;
            }
            if (ec.destinationEncoding != null) {
                outBytes.setEncoding(ec.destinationEncoding);
            }
            StringOperations.setRope(target, StringOperations.ropeFromByteList(outBytes));
            return this.getSymbol(res.symbolicName());
        }
    }

    @Primitive(name="encoding_converter_allocate")
    public static abstract class EncodingConverterAllocateNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object encodingConverterAllocate(DynamicObject encodingConverterClass, NotProvided unused1, NotProvided unused2) {
            return EncodingConverterNodes.createEncodingConverter(encodingConverterClass, null);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return EncodingConverterNodes.createEncodingConverter(rubyClass, null);
        }
    }

    @CoreMethod(names={"transcoding_map"}, onSingleton=true)
    public static abstract class TranscodingMapNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode upcaseNode;
        @Node.Child
        private CallDispatchHeadNode toSymNode;
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;
        @Node.Child
        private CallDispatchHeadNode newTranscodingNode;

        public TranscodingMapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.upcaseNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.toSymNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.newLookupTableNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupTableWriteNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.newTranscodingNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object transcodingMap(VirtualFrame frame) {
            Object ret = this.newLookupTableNode.call(frame, this.coreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            for (CaseInsensitiveBytesHash sourceEntry : TranscoderDB.transcoders) {
                Object key = null;
                Object value = this.newLookupTableNode.call(frame, this.coreLibrary().getLookupTableClass(), "new", null, new Object[0]);
                for (Hash.HashEntry destinationEntry : sourceEntry.entryIterator()) {
                    TranscoderDB.Entry e = (TranscoderDB.Entry)destinationEntry.value;
                    if (key == null) {
                        Object upcased = this.upcaseNode.call(frame, this.createString(new ByteList(e.getSource())), "upcase", null, new Object[0]);
                        key = this.toSymNode.call(frame, upcased, "to_sym", null, new Object[0]);
                    }
                    Object upcasedLookupTableKey = this.upcaseNode.call(frame, this.createString(new ByteList(e.getDestination())), "upcase", null, new Object[0]);
                    Object lookupTableKey = this.toSymNode.call(frame, upcasedLookupTableKey, "to_sym", null, new Object[0]);
                    Object lookupTableValue = this.newTranscodingNode.call(frame, this.coreLibrary().getTranscodingClass(), "create", null, key, lookupTableKey);
                    this.lookupTableWriteNode.call(frame, value, "[]=", null, lookupTableKey, lookupTableValue);
                }
                this.lookupTableWriteNode.call(frame, ret, "[]=", null, key, value);
            }
            return ret;
        }
    }

    @CoreMethod(names={"initialize_jruby"}, required=2, optional=1, visibility=Visibility.PRIVATE)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject initialize(DynamicObject self, Object source, Object destination, Object unusedOptions) {
            Ruby runtime = this.getContext().getJRubyRuntime();
            Encoding[] encs = new Encoding[]{null, null};
            byte[][] encNames = new byte[][]{null, null};
            int[] ecflags = new int[]{0};
            IRubyObject[] ecopts = new IRubyObject[]{runtime.getNil()};
            IRubyObject sourceAsJRubyObj = this.toJRuby(source);
            IRubyObject destinationAsJRubyObj = this.toJRuby(destination);
            EncodingUtils.econvArgs((ThreadContext)runtime.getCurrentContext(), (IRubyObject[])new IRubyObject[]{sourceAsJRubyObj, destinationAsJRubyObj}, (byte[][])encNames, (Encoding[])encs, (int[])ecflags, (IRubyObject[])ecopts);
            ecflags[0] = this.rubiniusToJRubyFlags((Integer)self.get((Object)"@options", (Object)this.coreLibrary().getNilObject()));
            EConv econv = EncodingUtils.econvOpenOpts((ThreadContext)runtime.getCurrentContext(), (byte[])encNames[0], (byte[])encNames[1], (int)ecflags[0], (IRubyObject)ecopts[0]);
            if (econv == null) {
                throw new UnsupportedOperationException();
            }
            if (!EncodingUtils.DECORATOR_P((byte[])encNames[0], (byte[])encNames[1])) {
                if (encs[0] == null) {
                    encs[0] = EncodingDB.dummy((byte[])encNames[0]).getEncoding();
                }
                if (encs[1] == null) {
                    encs[1] = EncodingDB.dummy((byte[])encNames[1]).getEncoding();
                }
            }
            econv.sourceEncoding = encs[0];
            econv.destinationEncoding = encs[1];
            Layouts.ENCODING_CONVERTER.setEconv(self, econv);
            return this.nil();
        }

        private int rubiniusToJRubyFlags(int flags) {
            if ((flags & 0x4000) != 0) {
                flags |= 0x30;
            }
            if ((flags & 0x8000) != 0) {
                flags |= 0x30;
            }
            return flags;
        }

        private IRubyObject toJRuby(Object object) {
            if (RubyGuards.isRubyString(object)) {
                return this.getContext().getJRubyRuntime().newString(RopeOperations.toByteListCopy(StringOperations.rope((DynamicObject)object)));
            }
            if (RubyGuards.isRubyEncoding(object)) {
                return this.getContext().getJRubyRuntime().getEncodingService().rubyEncodingFromObject((IRubyObject)this.getContext().getJRubyRuntime().newString(Layouts.ENCODING.getName((DynamicObject)object)));
            }
            throw new UnsupportedOperationException();
        }
    }
}

