/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Sysconf;
import jnr.constants.platform.WaitFlags;
import jnr.posix.Passwd;
import jnr.posix.Times;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.Primitive;
import org.jruby.truffle.builtins.PrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.basicobject.BasicObjectNodes;
import org.jruby.truffle.core.basicobject.BasicObjectNodesFactory;
import org.jruby.truffle.core.kernel.KernelNodes;
import org.jruby.truffle.core.kernel.KernelNodesFactory;
import org.jruby.truffle.core.proc.ProcSignalHandler;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.ExitException;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.ThrowException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.IsANode;
import org.jruby.truffle.language.objects.IsANodeGen;
import org.jruby.truffle.language.objects.LogicalClassNode;
import org.jruby.truffle.language.objects.LogicalClassNodeGen;
import org.jruby.truffle.language.yield.YieldNode;
import org.jruby.truffle.platform.UnsafeGroup;
import org.jruby.truffle.platform.signal.Signal;
import org.jruby.truffle.platform.signal.SignalHandler;
import org.jruby.truffle.platform.signal.SignalManager;
import org.jruby.util.io.PosixShim;

public abstract class VMPrimitiveNodes {

    @Primitive(name="vm_set_class", needsSelf=false)
    public static abstract class VMSetClassPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyClass(newClass)"})
        public DynamicObject setClass(DynamicObject object, DynamicObject newClass) {
            Layouts.BASIC_OBJECT.setLogicalClass(object, newClass);
            Layouts.BASIC_OBJECT.setMetaClass(object, newClass);
            return object;
        }
    }

    @Primitive(name="vm_wait_pid", needsSelf=false, unsafe={UnsafeGroup.PROCESSES})
    public static abstract class VMWaitPidPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object waitPID(final int input_pid, boolean no_hang) {
            int options = 0;
            final int[] statusReference = new int[]{0};
            if (no_hang) {
                options |= WaitFlags.WNOHANG.intValue();
            }
            final int finalOptions = options;
            int pid = this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Integer>(){

                @Override
                public Integer block() throws InterruptedException {
                    return this.posix().waitpid(input_pid, statusReference, finalOptions);
                }
            });
            int errno = this.posix().errno();
            if (pid == -1) {
                if (errno == Errno.ECHILD.intValue()) {
                    return false;
                }
                if (errno == Errno.EINTR.intValue()) {
                    throw new UnsupportedOperationException();
                }
                return false;
            }
            if (no_hang && pid == 0) {
                return this.nil();
            }
            Object output = this.nil();
            Object termsig = this.nil();
            Object stopsig = this.nil();
            int status = statusReference[0];
            if (PosixShim.WAIT_MACROS.WIFEXITED((long)status)) {
                output = PosixShim.WAIT_MACROS.WEXITSTATUS((long)status);
            } else if (PosixShim.WAIT_MACROS.WIFSIGNALED((long)status)) {
                termsig = PosixShim.WAIT_MACROS.WTERMSIG((long)status);
            } else if (PosixShim.WAIT_MACROS.WIFSTOPPED((long)status)) {
                stopsig = PosixShim.WAIT_MACROS.WSTOPSIG((long)status);
            }
            Object[] objects = new Object[]{output, termsig, stopsig, pid};
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @Primitive(name="vm_get_config_section", needsSelf=false)
    public static abstract class VMGetConfigSectionPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(section)"})
        public DynamicObject getSection(DynamicObject section) {
            ArrayList<DynamicObject> sectionKeyValues = new ArrayList<DynamicObject>();
            for (String key : this.getContext().getNativePlatform().getRubiniusConfiguration().getSection(section.toString())) {
                Object value = this.getContext().getNativePlatform().getRubiniusConfiguration().get(key);
                String stringValue = RubyGuards.isRubyBignum(value) ? Layouts.BIGNUM.getValue((DynamicObject)value).toString() : value.toString();
                Object[] objects = new Object[]{this.createString(StringOperations.encodeRope(key, (Encoding)UTF8Encoding.INSTANCE)), this.createString(StringOperations.encodeRope(stringValue, (Encoding)UTF8Encoding.INSTANCE))};
                sectionKeyValues.add(Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length));
            }
            Object[] objects = sectionKeyValues.toArray();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @Primitive(name="vm_get_config_item", needsSelf=false)
    public static abstract class VMGetConfigItemPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(key)"})
        public Object get(DynamicObject key) {
            Object value = this.getContext().getNativePlatform().getRubiniusConfiguration().get(key.toString());
            if (value == null) {
                return this.nil();
            }
            return value;
        }
    }

    @Primitive(name="vm_watch_signal", needsSelf=false, unsafe={UnsafeGroup.SIGNALS})
    public static abstract class VMWatchSignalPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(signalName)", "isRubyString(action)"})
        public boolean watchSignal(DynamicObject signalName, DynamicObject action) {
            if (!action.toString().equals("DEFAULT")) {
                throw new UnsupportedOperationException();
            }
            return this.handleDefault(signalName);
        }

        @Specialization(guards={"isRubyString(signalName)", "isNil(nil)"})
        public boolean watchSignal(DynamicObject signalName, Object nil) {
            return this.handle(signalName, SignalManager.IGNORE_HANDLER);
        }

        @Specialization(guards={"isRubyString(signalName)", "isRubyProc(proc)"})
        public boolean watchSignalProc(DynamicObject signalName, DynamicObject proc) {
            return this.handle(signalName, new ProcSignalHandler(this.getContext(), proc));
        }

        @CompilerDirectives.TruffleBoundary
        private boolean handleDefault(DynamicObject signalName) {
            Signal signal = this.getContext().getNativePlatform().getSignalManager().createSignal(signalName.toString());
            try {
                this.getContext().getNativePlatform().getSignalManager().watchDefaultForSignal(signal);
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), this));
            }
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean handle(DynamicObject signalName, SignalHandler newHandler) {
            Signal signal = this.getContext().getNativePlatform().getSignalManager().createSignal(signalName.toString());
            try {
                this.getContext().getNativePlatform().getSignalManager().watchSignal(signal, newHandler);
            }
            catch (IllegalArgumentException e) {
                throw new RaiseException(this.coreExceptions().argumentError(e.getMessage(), this));
            }
            return true;
        }
    }

    @Primitive(name="vm_times", needsSelf=false)
    public static abstract class TimesNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject times() {
            Times tms = this.posix().times();
            double utime = 0.0;
            double stime = 0.0;
            double cutime = 0.0;
            double cstime = 0.0;
            if (tms == null) {
                ThreadMXBean bean = ManagementFactory.getThreadMXBean();
                if (bean.isCurrentThreadCpuTimeSupported()) {
                    cutime = utime = (double)bean.getCurrentThreadUserTime();
                    cstime = stime = (double)(bean.getCurrentThreadCpuTime() - bean.getCurrentThreadUserTime());
                }
            } else {
                utime = tms.utime();
                stime = tms.stime();
                cutime = tms.cutime();
                cstime = tms.cstime();
            }
            long hz = this.posix().sysconf(Sysconf._SC_CLK_TCK);
            if (hz == -1L) {
                hz = 60L;
            }
            double tutime = 0.0;
            double tstime = 0.0;
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new double[]{utime /= (double)hz, stime /= (double)hz, cutime /= (double)hz, cstime /= (double)hz, 0.0, 0.0}, 6);
        }
    }

    @Primitive(name="vm_time", needsSelf=false)
    public static abstract class TimeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public long time() {
            return System.currentTimeMillis() / 1000L;
        }
    }

    @Primitive(name="vm_throw", needsSelf=false)
    public static abstract class ThrowNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object doThrow(Object tag, Object value) {
            throw new ThrowException(tag, value);
        }
    }

    @Primitive(name="vm_singleton_class_object", needsSelf=false)
    public static abstract class VMObjectSingletonClassObjectPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object vmSingletonClassObject(Object object) {
            return RubyGuards.isRubyClass(object) && Layouts.CLASS.getIsSingleton((DynamicObject)object);
        }
    }

    @Primitive(name="vm_set_module_name", needsSelf=false)
    public static abstract class VMSetModuleNamePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object vmSetModuleName(Object object) {
            throw new UnsupportedOperationException("vm_set_module_name");
        }
    }

    @Primitive(name="vm_raise_exception", needsSelf=false)
    public static abstract class VMRaiseExceptionPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        public VMRaiseExceptionPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyException(exception)"})
        public DynamicObject vmRaiseException(DynamicObject exception) {
            throw new RaiseException(exception);
        }
    }

    @Primitive(name="vm_object_singleton_class", needsSelf=false)
    public static abstract class VMObjectSingletonClassPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private KernelNodes.SingletonClassMethodNode singletonClassNode;

        public VMObjectSingletonClassPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = KernelNodesFactory.SingletonClassMethodNodeFactory.create(context, sourceSection, null);
        }

        @Specialization
        public Object vmObjectClass(Object object) {
            return this.singletonClassNode.singletonClass(object);
        }
    }

    @Primitive(name="vm_object_respond_to", needsSelf=false)
    public static abstract class VMObjectRespondToPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private KernelNodes.RespondToNode respondToNode;

        public VMObjectRespondToPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.respondToNode = KernelNodesFactory.RespondToNodeFactory.create(context, sourceSection, null, null, null);
        }

        @Specialization
        public boolean vmObjectRespondTo(VirtualFrame frame, Object object, Object name, boolean includePrivate) {
            return this.respondToNode.executeDoesRespondTo(frame, object, name, includePrivate);
        }
    }

    @Primitive(name="vm_object_kind_of", needsSelf=false)
    public static abstract class VMObjectKindOfPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private IsANode isANode;

        public VMObjectKindOfPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.isANode = IsANodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public boolean vmObjectKindOf(Object object, DynamicObject rubyClass) {
            return this.isANode.executeIsA(object, rubyClass);
        }
    }

    @Primitive(name="vm_object_equal", needsSelf=false)
    public static abstract class VMObjectEqualPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        BasicObjectNodes.ReferenceEqualNode referenceEqualNode = BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(null);

        public VMObjectEqualPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean vmObjectEqual(VirtualFrame frame, Object a, Object b) {
            return this.referenceEqualNode.executeReferenceEqual(frame, a, b);
        }
    }

    @Primitive(name="vm_object_class", needsSelf=false)
    public static abstract class VMObjectClassPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private LogicalClassNode classNode;

        public VMObjectClassPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = LogicalClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject vmObjectClass(VirtualFrame frame, Object object) {
            return this.classNode.executeLogicalClass(object);
        }
    }

    @Primitive(name="vm_get_user_home", needsSelf=false, unsafe={UnsafeGroup.IO})
    public static abstract class VMGetUserHomePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(username)"})
        public DynamicObject vmGetUserHome(DynamicObject username) {
            Passwd passwd = this.posix().getpwnam(username.toString());
            if (passwd == null) {
                throw new RaiseException(this.coreExceptions().argumentError("user " + username.toString() + " does not exist", this));
            }
            return this.createString(StringOperations.encodeRope(passwd.getHome(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @Primitive(name="vm_get_module_name", needsSelf=false)
    public static abstract class VMGetModuleNamePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject vmGetModuleName(DynamicObject module) {
            return this.createString(StringOperations.encodeRope(Layouts.MODULE.getFields(module).getName(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @Primitive(name="vm_extended_modules", needsSelf=false)
    public static abstract class VMExtendedModulesNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode newArrayNode;
        @Node.Child
        private CallDispatchHeadNode arrayAppendNode;

        public VMExtendedModulesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.newArrayNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.arrayAppendNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object vmExtendedModules(VirtualFrame frame, Object object) {
            DynamicObject metaClass = this.coreLibrary().getMetaClass(object);
            if (Layouts.CLASS.getIsSingleton(metaClass)) {
                Object ret = this.newArrayNode.call(frame, this.coreLibrary().getArrayClass(), "new", null, new Object[0]);
                for (DynamicObject included : Layouts.MODULE.getFields(metaClass).prependedAndIncludedModules()) {
                    this.arrayAppendNode.call(frame, ret, "<<", null, included);
                }
                return ret;
            }
            return this.nil();
        }
    }

    @Primitive(name="vm_exit", needsSelf=false, unsafe={UnsafeGroup.EXIT})
    public static abstract class VMExitPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public Object vmExit(int status) {
            throw new ExitException(status);
        }

        @Fallback
        public Object vmExit(Object status) {
            return null;
        }
    }

    @Primitive(name="vm_gc_start", needsSelf=false)
    public static abstract class VMGCStartPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject vmGCStart() {
            System.gc();
            return this.nil();
        }
    }

    @Primitive(name="vm_catch", needsSelf=false)
    public static abstract class CatchNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private YieldNode dispatchNode;
        @Node.Child
        private BasicObjectNodes.ReferenceEqualNode referenceEqualNode;

        public CatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatchNode = new YieldNode(context);
        }

        private boolean areSame(VirtualFrame frame, Object left, Object right) {
            if (this.referenceEqualNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.referenceEqualNode = (BasicObjectNodes.ReferenceEqualNode)this.insert(BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(null));
            }
            return this.referenceEqualNode.executeReferenceEqual(frame, left, right);
        }

        @Specialization
        public Object doCatch(VirtualFrame frame, Object tag, DynamicObject block, @Cached(value="create()") BranchProfile catchProfile, @Cached(value="createBinaryProfile()") ConditionProfile matchProfile) {
            try {
                return this.dispatchNode.dispatch(frame, block, tag);
            }
            catch (ThrowException e) {
                catchProfile.enter();
                if (matchProfile.profile(this.areSame(frame, e.getTag(), tag))) {
                    return e.getValue();
                }
                throw e;
            }
        }
    }
}

