/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.stdlib.psych;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.jcodings.Encoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.adapaters.OutputStreamAdapter;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;
import org.jruby.truffle.stdlib.psych.PsychParserNodes;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.emitter.EmitterException;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;

@CoreClass(name="Psych::Emitter")
public abstract class PsychEmitterNodes {
    private static final Mark NULL_MARK = new Mark(null, 0, 0, 0, null, 0);
    private static final Character[] SCALAR_STYLES = new Character[]{null, null, Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('|'), Character.valueOf('>')};

    private static void emit(RubyContext context, DynamicObject emitter, Event event) {
        try {
            if (Layouts.PSYCH_EMITTER.getEmitter(emitter) == null) {
                throw new UnsupportedOperationException();
            }
            Layouts.PSYCH_EMITTER.getEmitter(emitter).emit(event);
        }
        catch (IOException ioe) {
            throw new UnsupportedOperationException();
        }
        catch (EmitterException ee) {
            throw new UnsupportedOperationException();
        }
    }

    private static void initEmitter(RubyContext context, DynamicObject emitter, int _encoding) {
        if (Layouts.PSYCH_EMITTER.getEmitter(emitter) != null) {
            throw new UnsupportedOperationException();
        }
        Encoding encoding = PsychParserNodes.YAMLEncoding.values()[_encoding].encoding;
        Charset charset = context.getJRubyRuntime().getEncodingService().charsetForEncoding(encoding);
        Layouts.PSYCH_EMITTER.setEmitter(emitter, new Emitter((Writer)new OutputStreamWriter((OutputStream)new OutputStreamAdapter(context, (DynamicObject)Layouts.PSYCH_EMITTER.getIo(emitter), encoding), charset), Layouts.PSYCH_EMITTER.getOptions(emitter)));
    }

    @CoreMethod(names={"line_width"})
    public static abstract class LineWidthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int lineWidth(DynamicObject emitter) {
            return Layouts.PSYCH_EMITTER.getOptions(emitter).getWidth();
        }
    }

    @CoreMethod(names={"line_width="}, required=1)
    public static abstract class SetLineWidthNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int setLineWidth(DynamicObject emitter, int width) {
            Layouts.PSYCH_EMITTER.getOptions(emitter).setWidth(width);
            return width;
        }
    }

    @CoreMethod(names={"indentation"})
    public static abstract class IndentationNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int indentation(DynamicObject emitter) {
            return Layouts.PSYCH_EMITTER.getOptions(emitter).getIndent();
        }
    }

    @CoreMethod(names={"indentation="}, required=1)
    public static abstract class SetIndentationNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int setIndentation(DynamicObject emitter, int indentation) {
            Layouts.PSYCH_EMITTER.getOptions(emitter).setIndent(indentation);
            return indentation;
        }
    }

    @CoreMethod(names={"canonical"})
    public static abstract class CanonicalNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean canonical(DynamicObject emitter) {
            return Layouts.PSYCH_EMITTER.getOptions(emitter).isCanonical();
        }
    }

    @CoreMethod(names={"canonical="}, required=1)
    public static abstract class SetCanonicalNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public boolean setCanonical(DynamicObject emitter, boolean canonical) {
            Layouts.PSYCH_EMITTER.getOptions(emitter).setCanonical(canonical);
            return canonical;
        }
    }

    @CoreMethod(names={"alias"}, required=1)
    public static abstract class AliasNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject alias(DynamicObject emitter, Object anchor) {
            PsychEmitterNodes.emit(this.getContext(), emitter, (Event)new AliasEvent(anchor.toString(), NULL_MARK, NULL_MARK));
            return emitter;
        }
    }

    @CoreMethod(names={"end_mapping"})
    public static abstract class EndMappingNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject endMapping(DynamicObject emitter) {
            PsychEmitterNodes.emit(this.getContext(), emitter, (Event)new MappingEndEvent(NULL_MARK, NULL_MARK));
            return emitter;
        }
    }

    @CoreMethod(names={"start_mapping"}, required=4)
    public static abstract class StartMappingNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject startMapping(DynamicObject emitter, Object anchor, Object tag, boolean implicit, int style) {
            boolean MAPPING_BLOCK = true;
            MappingStartEvent event = new MappingStartEvent(this.isNil(anchor) ? null : anchor.toString(), this.isNil(tag) ? null : tag.toString(), implicit, NULL_MARK, NULL_MARK, Boolean.valueOf(1 != style));
            PsychEmitterNodes.emit(this.getContext(), emitter, (Event)event);
            return emitter;
        }
    }

    @CoreMethod(names={"end_sequence"})
    public static abstract class EndSequenceNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject endSequence(DynamicObject emitter) {
            PsychEmitterNodes.emit(this.getContext(), emitter, (Event)new SequenceEndEvent(NULL_MARK, NULL_MARK));
            return emitter;
        }
    }

    @CoreMethod(names={"start_sequence"}, required=4)
    public static abstract class StartSequenceNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject startSequence(DynamicObject emitter, Object anchor, Object tag, boolean implicit, int style) {
            boolean SEQUENCE_BLOCK = true;
            SequenceStartEvent event = new SequenceStartEvent(this.isNil(anchor) ? null : anchor.toString(), this.isNil(tag) ? null : tag.toString(), implicit, NULL_MARK, NULL_MARK, Boolean.valueOf(1 != style));
            PsychEmitterNodes.emit(this.getContext(), emitter, (Event)event);
            return emitter;
        }
    }

    @CoreMethod(names={"scalar"}, required=6)
    public static abstract class ScalarNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(value)"})
        public DynamicObject scalar(DynamicObject emitter, DynamicObject value, Object anchor, Object tag, boolean plain, boolean quoted, int style) {
            ScalarEvent event = new ScalarEvent(this.isNil(anchor) ? null : anchor.toString(), this.isNil(tag) ? null : tag.toString(), new ImplicitTuple(plain, quoted), value.toString(), NULL_MARK, NULL_MARK, SCALAR_STYLES[style]);
            PsychEmitterNodes.emit(this.getContext(), emitter, (Event)event);
            return emitter;
        }
    }

    @CoreMethod(names={"end_document"}, required=1)
    public static abstract class EndDocumentNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject endDocument(DynamicObject emitter, boolean implicit) {
            PsychEmitterNodes.emit(this.getContext(), emitter, (Event)new DocumentEndEvent(NULL_MARK, NULL_MARK, !implicit));
            return emitter;
        }
    }

    @CoreMethod(names={"start_document"}, required=3)
    public static abstract class StartDocumentNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyArray(_version)", "isRubyArray(tags)"})
        public DynamicObject startDocument(DynamicObject emitter, DynamicObject _version, DynamicObject tags, boolean implicit) {
            Object[] tagsAry;
            DumperOptions.Version version = null;
            boolean implicitBool = implicit;
            HashMap<String, String> tagsMap = null;
            Object[] versionAry = ArrayOperations.toObjectArray(_version);
            if (versionAry.length == 2) {
                int versionInt0 = (Integer)versionAry[0];
                int versionInt1 = (Integer)versionAry[1];
                if (versionInt0 == 1) {
                    if (versionInt1 == 0) {
                        version = DumperOptions.Version.V1_0;
                    } else if (versionInt1 == 1) {
                        version = DumperOptions.Version.V1_1;
                    }
                }
                if (version == null) {
                    throw new UnsupportedOperationException();
                }
            }
            if ((tagsAry = ArrayOperations.toObjectArray(tags)).length > 0) {
                tagsMap = new HashMap<String, String>(tagsAry.length);
                for (int i = 0; i < tagsAry.length; ++i) {
                    Object[] tagsTuple = ArrayOperations.toObjectArray((DynamicObject)tagsAry[i]);
                    if (tagsTuple.length != 2) {
                        throw new UnsupportedOperationException();
                    }
                    Object key = tagsTuple[0];
                    Object value = tagsTuple[1];
                    tagsMap.put(key.toString(), value.toString());
                }
            }
            DocumentStartEvent event = new DocumentStartEvent(NULL_MARK, NULL_MARK, !implicitBool, version, tagsMap);
            PsychEmitterNodes.emit(this.getContext(), emitter, (Event)event);
            return emitter;
        }
    }

    @CoreMethod(names={"end_stream"})
    public static abstract class EndStreamNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject endStream(DynamicObject emitter) {
            PsychEmitterNodes.emit(this.getContext(), emitter, (Event)new StreamEndEvent(NULL_MARK, NULL_MARK));
            return emitter;
        }
    }

    @CoreMethod(names={"start_stream"}, required=1)
    public static abstract class StartStreamNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject startStream(DynamicObject emitter, int encoding) {
            PsychEmitterNodes.initEmitter(this.getContext(), emitter, encoding);
            StreamStartEvent event = new StreamStartEvent(NULL_MARK, NULL_MARK);
            PsychEmitterNodes.emit(this.getContext(), emitter, (Event)event);
            return emitter;
        }
    }

    @CoreMethod(names={"initialize"}, visibility=Visibility.PRIVATE, required=1, optional=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject initialize(DynamicObject emitter, DynamicObject io, NotProvided optionsSet) {
            DumperOptions options = new DumperOptions();
            options.setIndent(2);
            Layouts.PSYCH_EMITTER.setOptions(emitter, options);
            Layouts.PSYCH_EMITTER.setIo(emitter, io);
            return this.nil();
        }

        @Specialization
        public DynamicObject initialize(VirtualFrame frame, DynamicObject emitter, DynamicObject io, DynamicObject optionsSet, @Cached(value="createMethodCall()") CallDispatchHeadNode lineWidthCallNode, @Cached(value="createMethodCall()") CallDispatchHeadNode canonicalCallNode, @Cached(value="createMethodCall()") CallDispatchHeadNode indentationCallNode) {
            DumperOptions options = new DumperOptions();
            options.setWidth(((Integer)lineWidthCallNode.call(frame, optionsSet, "line_width", null, new Object[0])).intValue());
            options.setCanonical(((Boolean)canonicalCallNode.call(frame, optionsSet, "canonical", null, new Object[0])).booleanValue());
            options.setIndent(((Integer)indentationCallNode.call(frame, optionsSet, "indentation", null, new Object[0])).intValue());
            Layouts.PSYCH_EMITTER.setOptions(emitter, options);
            Layouts.PSYCH_EMITTER.setIo(emitter, io);
            return this.nil();
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateNode.allocate(rubyClass, null, null, null);
        }
    }
}

