/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.ModuleBodyDefinitionNode;

public class RunModuleDefinitionNode
extends RubyNode {
    protected final LexicalScope lexicalScope;
    @Node.Child
    private RubyNode definingModule;
    @Node.Child
    private ModuleBodyDefinitionNode definitionMethod;
    @Node.Child
    private IndirectCallNode callModuleDefinitionNode;

    public RunModuleDefinitionNode(RubyContext context, SourceSection sourceSection, LexicalScope lexicalScope, ModuleBodyDefinitionNode definition, RubyNode definingModule) {
        super(context, sourceSection);
        this.definingModule = definingModule;
        this.definitionMethod = definition;
        this.lexicalScope = lexicalScope;
        this.callModuleDefinitionNode = Truffle.getRuntime().createIndirectCallNode();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject module = (DynamicObject)this.definingModule.execute(frame);
        InternalMethod definition = this.prepareLexicalScope(module, this.definitionMethod.executeMethod(frame));
        return this.callModuleDefinitionNode.call(frame, definition.getCallTarget(), RubyArguments.pack(null, null, definition, DeclarationContext.MODULE, null, module, null, new Object[0]));
    }

    @CompilerDirectives.TruffleBoundary
    private InternalMethod prepareLexicalScope(DynamicObject module, InternalMethod definition) {
        this.lexicalScope.unsafeSetLiveModule(module);
        Layouts.MODULE.getFields(this.lexicalScope.getParent().getLiveModule()).addLexicalDependent(module);
        return definition.withDeclaringModule(module);
    }
}

