/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.platform.UnsafeGroup;

@CoreClass(name="Truffle::Safe")
public abstract class TruffleSafeNodes {

    @CoreMethod(names={"signals_safe?"}, onSingleton=true)
    public static abstract class AreSignalsSafeNode
    extends CoreMethodNode {
        @Specialization
        public boolean signalsSafe() {
            return this.getContext().getOptions().PLATFORM_SAFE_SIGNALS;
        }
    }

    @CoreMethod(names={"memory_safe?"}, onSingleton=true)
    public static abstract class IsMemorySafeNode
    extends CoreMethodNode {
        @Specialization
        public boolean memorySafe() {
            return this.getContext().getOptions().PLATFORM_SAFE_MEMORY;
        }
    }

    @CoreMethod(names={"io_safe?"}, onSingleton=true)
    public static abstract class IsIOSafeNode
    extends CoreMethodNode {
        @Specialization
        public boolean ioSafe() {
            return this.getContext().getOptions().PLATFORM_SAFE_IO;
        }
    }

    @CoreMethod(names={"puts"}, onSingleton=true, required=1, unsafe={UnsafeGroup.SAFE_PUTS})
    public static abstract class PutsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject puts(DynamicObject string) {
            for (char c : string.toString().toCharArray()) {
                if (this.isAsciiPrintable(c)) {
                    System.out.print(c);
                    continue;
                }
                System.out.print('?');
            }
            System.out.println();
            return this.nil();
        }

        private boolean isAsciiPrintable(char c) {
            return c >= ' ' && c <= '~' || c == '\n' || c == '\t';
        }
    }
}

