/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigInteger;
import jnr.ffi.provider.MemoryManager;
import org.jcodings.Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.exception.CoreExceptions;
import org.jruby.truffle.core.kernel.TraceManager;
import org.jruby.truffle.core.numeric.BignumOperations;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.CoreStrings;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.extra.AttachmentsManager;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.platform.posix.Sockets;
import org.jruby.truffle.platform.posix.TrufflePosix;
import org.jruby.truffle.stdlib.CoverageManager;
import org.jruby.util.ByteList;

@ImportStatic(value={RubyGuards.class})
@TypeSystemReference(value=RubyTypes.class)
public abstract class RubyBaseNode
extends Node {
    private static final int FLAG_NEWLINE = 0;
    private static final int FLAG_CALL = 1;
    @CompilerDirectives.CompilationFinal
    private RubyContext context;
    @CompilerDirectives.CompilationFinal
    private SourceSection sourceSection;
    @CompilerDirectives.CompilationFinal
    private int flags;

    public RubyBaseNode() {
    }

    public RubyBaseNode(RubyContext context, SourceSection sourceSection) {
        this.context = context;
        this.sourceSection = sourceSection;
    }

    protected boolean isNil(Object value) {
        return value == this.nil();
    }

    protected boolean isRubiniusUndefined(Object value) {
        return value == this.coreLibrary().getRubiniusUndefined();
    }

    protected DynamicObjectFactory getInstanceFactory(DynamicObject rubyClass) {
        return Layouts.CLASS.getInstanceFactory(rubyClass);
    }

    protected DynamicObject nil() {
        return this.coreLibrary().getNilObject();
    }

    protected DynamicObject getSymbol(String name) {
        return this.getContext().getSymbolTable().getSymbol(name);
    }

    protected DynamicObject getSymbol(Rope name) {
        return this.getContext().getSymbolTable().getSymbol(name);
    }

    protected DynamicObject createString(ByteList bytes) {
        return StringOperations.createString(this.getContext(), bytes);
    }

    protected DynamicObject create7BitString(CharSequence value, Encoding encoding) {
        return StringOperations.createString(this.getContext(), StringOperations.encodeRope(value, encoding, CodeRange.CR_7BIT));
    }

    protected DynamicObject createString(Rope rope) {
        return StringOperations.createString(this.getContext(), rope);
    }

    protected DynamicObject createBignum(BigInteger value) {
        return BignumOperations.createBignum(this.getContext(), value);
    }

    protected CoreStrings coreStrings() {
        return this.getContext().getCoreStrings();
    }

    protected CoreLibrary coreLibrary() {
        return this.getContext().getCoreLibrary();
    }

    protected CoreExceptions coreExceptions() {
        return this.getContext().getCoreExceptions();
    }

    protected TrufflePosix posix() {
        return this.getContext().getNativePlatform().getPosix();
    }

    protected Sockets nativeSockets() {
        return this.getContext().getNativePlatform().getSockets();
    }

    protected MemoryManager memoryManager() {
        return this.getContext().getNativePlatform().getMemoryManager();
    }

    protected DynamicObject handle(Object object) {
        return Layouts.HANDLE.createHandle(this.coreLibrary().getHandleFactory(), object);
    }

    public RubyContext getContext() {
        if (this.context == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Node parent = this.getParent();
            while (true) {
                if (parent == null) {
                    throw new UnsupportedOperationException("can't get the RubyContext because the parent is null");
                }
                if (parent instanceof RubyBaseNode) {
                    this.context = ((RubyBaseNode)parent).getContext();
                    break;
                }
                if (parent instanceof RubyRootNode) {
                    this.context = ((RubyRootNode)parent).getContext();
                    break;
                }
                parent = parent.getParent();
            }
        }
        return this.context;
    }

    public void unsafeSetSourceSection(SourceSection sourceSection) {
        this.sourceSection = sourceSection;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public void unsafeSetIsNewLine() {
        this.flags |= 1;
    }

    public void unsafeSetIsCall() {
        this.flags |= 2;
    }

    private boolean isNewLine() {
        return (this.flags >> 0 & 1) == 1;
    }

    private boolean isCall() {
        return (this.flags >> 1 & 1) == 1;
    }

    private boolean isRoot() {
        return this.getParent() instanceof RubyRootNode;
    }

    protected boolean isTaggedWith(Class<?> tag) {
        if (tag == TraceManager.CallTag.class || tag == StandardTags.CallTag.class) {
            return this.isCall();
        }
        if (tag == AttachmentsManager.LineTag.class || tag == TraceManager.LineTag.class || tag == CoverageManager.LineTag.class || tag == StandardTags.StatementTag.class) {
            return this.isNewLine();
        }
        if (tag == StandardTags.RootTag.class) {
            return this.isRoot();
        }
        return false;
    }
}

