/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.cast.ToSNode;
import org.jruby.truffle.core.rubinius.StringPrimitiveNodes;
import org.jruby.truffle.core.rubinius.StringPrimitiveNodesFactory;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.IsTaintedNode;
import org.jruby.truffle.language.objects.IsTaintedNodeGen;
import org.jruby.truffle.language.objects.TaintNode;
import org.jruby.truffle.language.objects.TaintNodeGen;

public final class InterpolatedStringNode
extends RubyNode {
    @Node.Children
    private final ToSNode[] children;
    @Node.Child
    private StringPrimitiveNodes.StringAppendPrimitiveNode appendNode;
    @Node.Child
    private CallDispatchHeadNode dupNode;
    @Node.Child
    private IsTaintedNode isTaintedNode;
    @Node.Child
    private TaintNode taintNode;
    private final ConditionProfile taintProfile = ConditionProfile.createCountingProfile();

    public InterpolatedStringNode(RubyContext context, SourceSection sourceSection, ToSNode[] children) {
        super(context, sourceSection);
        this.children = children;
        this.appendNode = StringPrimitiveNodesFactory.StringAppendPrimitiveNodeFactory.create(context, sourceSection, new RubyNode[0]);
        this.dupNode = DispatchHeadNodeFactory.createMethodCall(context);
        this.isTaintedNode = IsTaintedNodeGen.create(context, sourceSection, null);
        this.taintNode = TaintNodeGen.create(context, sourceSection, null);
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        Object[] strings = new Object[this.children.length];
        boolean tainted = false;
        for (int n = 0; n < this.children.length; ++n) {
            Object toInterpolate;
            strings[n] = toInterpolate = this.children[n].execute(frame);
            tainted |= this.isTaintedNode.executeIsTainted(toInterpolate);
        }
        Object string = this.concat(frame, strings);
        if (this.taintProfile.profile(tainted)) {
            this.taintNode.executeTaint(string);
        }
        return string;
    }

    private Object concat(VirtualFrame frame, Object[] strings) {
        DynamicObject builder = null;
        for (Object string : strings) {
            assert (RubyGuards.isRubyString(string));
            builder = builder == null ? (DynamicObject)this.dupNode.call(frame, string, "dup", null, new Object[0]) : this.appendNode.executeStringAppend(builder, (DynamicObject)string);
        }
        return builder;
    }
}

