/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.core.basicobject.BasicObjectLayoutImpl;
import org.jruby.truffle.core.rubinius.RandomizerLayout;
import org.jruby.util.Random;

@GeneratedBy(value=RandomizerLayout.class)
public class RandomizerLayoutImpl
extends BasicObjectLayoutImpl
implements RandomizerLayout {
    public static final RandomizerLayout INSTANCE = new RandomizerLayoutImpl();
    protected static final Shape.Allocator RANDOMIZER_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey RANDOM_IDENTIFIER = new HiddenKey("random");
    protected static final Property RANDOM_PROPERTY = Property.create((Object)RANDOM_IDENTIFIER, (Location)RANDOMIZER_ALLOCATOR.locationForType(Random.class, EnumSet.of(LocationModifier.NonNull)), (int)0);

    protected RandomizerLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createRandomizerShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new RandomizerType(logicalClass, metaClass)).addProperty(RANDOM_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createRandomizer(DynamicObjectFactory factory, Random random) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (RandomizerLayoutImpl.createsRandomizer(factory));
        assert (factory.getShape().hasProperty((Object)RANDOM_IDENTIFIER));
        assert (random != null);
        return factory.newInstance(new Object[]{random});
    }

    private static boolean isRandomizer(DynamicObject object) {
        return RandomizerLayoutImpl.isRandomizer(object.getShape().getObjectType());
    }

    private static boolean isRandomizer(ObjectType objectType) {
        return objectType instanceof RandomizerType;
    }

    private static boolean createsRandomizer(DynamicObjectFactory factory) {
        return RandomizerLayoutImpl.isRandomizer(factory.getShape().getObjectType());
    }

    @Override
    public Random getRandom(DynamicObject object) {
        assert (RandomizerLayoutImpl.isRandomizer(object));
        assert (object.getShape().hasProperty((Object)RANDOM_IDENTIFIER));
        return (Random)RANDOM_PROPERTY.get(object, RandomizerLayoutImpl.isRandomizer(object));
    }

    @Override
    public void setRandom(DynamicObject object, Random value) {
        assert (RandomizerLayoutImpl.isRandomizer(object));
        assert (object.getShape().hasProperty((Object)RANDOM_IDENTIFIER));
        assert (value != null);
        try {
            RANDOM_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static class RandomizerType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public RandomizerType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public RandomizerType setLogicalClass(DynamicObject logicalClass) {
            return new RandomizerType(logicalClass, this.metaClass);
        }

        @Override
        public RandomizerType setMetaClass(DynamicObject metaClass) {
            return new RandomizerType(this.logicalClass, metaClass);
        }
    }
}

