/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.language.RubyBaseNode;

public class FixnumOrBignumNode
extends RubyBaseNode {
    private static final BigInteger LONG_MIN_BIGINT = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger LONG_MAX_BIGINT = BigInteger.valueOf(Long.MAX_VALUE);
    private final ConditionProfile lowerProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile intProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile integerFromDoubleProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile longFromDoubleProfile = ConditionProfile.createBinaryProfile();

    public static FixnumOrBignumNode create(RubyContext context, SourceSection sourceSection) {
        return new FixnumOrBignumNode(context, sourceSection);
    }

    public FixnumOrBignumNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    @CompilerDirectives.TruffleBoundary
    public Object fixnumOrBignum(BigDecimal value) {
        return this.fixnumOrBignum(value.toBigInteger());
    }

    public Object fixnumOrBignum(BigInteger value) {
        if (this.lowerProfile.profile(value.compareTo(LONG_MIN_BIGINT) >= 0 && value.compareTo(LONG_MAX_BIGINT) <= 0)) {
            long longValue = value.longValue();
            if (this.intProfile.profile(CoreLibrary.fitsIntoInteger(longValue))) {
                return (int)longValue;
            }
            return longValue;
        }
        return this.createBignum(value);
    }

    public Object fixnumOrBignum(double value) {
        if (this.integerFromDoubleProfile.profile(value > -2.147483648E9 && value < 2.147483647E9)) {
            return (int)value;
        }
        if (this.longFromDoubleProfile.profile(value > -9.223372036854776E18 && value < 9.223372036854776E18)) {
            return (long)value;
        }
        return this.fixnumOrBignum(FixnumOrBignumNode.doubleToBigInteger(value));
    }

    @CompilerDirectives.TruffleBoundary
    private static BigInteger doubleToBigInteger(double value) {
        return new BigDecimal(value).toBigInteger();
    }
}

