/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.hash;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Map;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.hash.BucketsStrategy;
import org.jruby.truffle.core.hash.HashOperations;
import org.jruby.truffle.language.RubyNode;

public class ConcatHashLiteralNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] children;

    public ConcatHashLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] children) {
        super(context, sourceSection);
        this.children = children;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        ArrayList<Map.Entry<Object, Object>> keyValues = new ArrayList<Map.Entry<Object, Object>>();
        for (RubyNode child : this.children) {
            try {
                for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(child.executeDynamicObject(frame))) {
                    keyValues.add(keyValue);
                }
            }
            catch (UnexpectedResultException e) {
                throw new UnsupportedOperationException(((Object)((Object)child)).getClass() + " " + e.getResult().getClass());
            }
        }
        return BucketsStrategy.create(this.getContext(), keyValues, false);
    }
}

