/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreLibrary;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;

public abstract class ArrayLiteralNode
extends RubyNode {
    @Node.Children
    protected final RubyNode[] values;
    @Node.Child
    protected AllocateObjectNode allocateObjectNode;

    public static ArrayLiteralNode create(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
        return new UninitialisedArrayLiteralNode(context, sourceSection, values);
    }

    public ArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
        super(context, sourceSection);
        this.values = values;
        this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, false, null, null);
    }

    protected DynamicObject makeGeneric(VirtualFrame frame, Object[] alreadyExecuted) {
        CompilerAsserts.neverPartOfCompilation();
        this.replace(new ObjectArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
        Object[] executedValues = new Object[this.values.length];
        for (int n = 0; n < this.values.length; ++n) {
            executedValues[n] = n < alreadyExecuted.length ? alreadyExecuted[n] : this.values[n].execute(frame);
        }
        return this.createArray(executedValues, executedValues.length);
    }

    protected DynamicObject createArray(Object store, int size) {
        return this.allocateObjectNode.allocate(this.coreLibrary().getArrayClass(), store, size);
    }

    @Override
    public abstract Object execute(VirtualFrame var1);

    @Override
    @ExplodeLoop
    public void executeVoid(VirtualFrame frame) {
        for (RubyNode value : this.values) {
            value.executeVoid(frame);
        }
    }

    @Override
    @ExplodeLoop
    public Object isDefined(VirtualFrame frame) {
        for (RubyNode value : this.values) {
            if (value.isDefined(frame) != this.nil()) continue;
            return this.nil();
        }
        return super.isDefined(frame);
    }

    public int getSize() {
        return this.values.length;
    }

    public RubyNode stealNode(int index) {
        RubyNode node = this.values[index];
        this.values[index] = null;
        return node;
    }

    private static class UninitialisedArrayLiteralNode
    extends ArrayLiteralNode {
        public UninitialisedArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
            super(context, sourceSection, values);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            CompilerDirectives.transferToInterpreter();
            Object[] executedValues = new Object[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                executedValues[n] = this.values[n].execute(frame);
            }
            DynamicObject array = this.createArray(this.storeSpecialisedFromObjects(executedValues), executedValues.length);
            Object store = Layouts.ARRAY.getStore(array);
            if (store == null) {
                this.replace(new EmptyArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            }
            if (store instanceof int[]) {
                this.replace(new IntegerArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            } else if (store instanceof long[]) {
                this.replace(new LongArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            } else if (store instanceof double[]) {
                this.replace(new FloatArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            } else {
                this.replace(new ObjectArrayLiteralNode(this.getContext(), this.getSourceSection(), this.values));
            }
            return array;
        }

        public Object storeSpecialisedFromObjects(Object ... objects) {
            int n;
            Object[] store;
            if (objects.length == 0) {
                return null;
            }
            boolean canUseInteger = true;
            boolean canUseLong = true;
            boolean canUseDouble = true;
            for (Object object : objects) {
                if (object instanceof Integer) {
                    canUseDouble = false;
                    continue;
                }
                if (object instanceof Long) {
                    canUseInteger = canUseInteger && CoreLibrary.fitsIntoInteger((Long)object);
                    canUseDouble = false;
                    continue;
                }
                if (object instanceof Double) {
                    canUseInteger = false;
                    canUseLong = false;
                    continue;
                }
                canUseInteger = false;
                canUseLong = false;
                canUseDouble = false;
            }
            if (canUseInteger) {
                store = new int[objects.length];
                for (n = 0; n < objects.length; ++n) {
                    Object object = objects[n];
                    if (object instanceof Integer) {
                        store[n] = (Integer)object;
                        continue;
                    }
                    if (object instanceof Long) {
                        store[n] = (int)((Long)object).longValue();
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
                return store;
            }
            if (canUseLong) {
                store = new long[objects.length];
                for (n = 0; n < objects.length; ++n) {
                    Object object = objects[n];
                    if (object instanceof Integer) {
                        store[n] = (int)((long)((Integer)object).intValue());
                        continue;
                    }
                    if (object instanceof Long) {
                        store[n] = (int)((Long)object).longValue();
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
                return store;
            }
            if (canUseDouble) {
                store = new double[objects.length];
                for (n = 0; n < objects.length; ++n) {
                    store[n] = (int)CoreLibrary.toDouble(objects[n], this.coreLibrary().getNilObject());
                }
                return store;
            }
            return objects;
        }
    }

    private static class ObjectArrayLiteralNode
    extends ArrayLiteralNode {
        public ObjectArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
            super(context, sourceSection, values);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            Object[] executedValues = new Object[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                executedValues[n] = this.values[n].execute(frame);
            }
            return this.createArray(executedValues, this.values.length);
        }
    }

    private static class LongArrayLiteralNode
    extends ArrayLiteralNode {
        public LongArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
            super(context, sourceSection, values);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            long[] executedValues = new long[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                try {
                    executedValues[n] = this.values[n].executeLong(frame);
                    continue;
                }
                catch (UnexpectedResultException e) {
                    return this.makeGeneric(frame, executedValues, n);
                }
            }
            return this.createArray(executedValues, this.values.length);
        }

        private DynamicObject makeGeneric(VirtualFrame frame, long[] executedValues, int n) {
            Object[] executedObjects = new Object[n];
            for (int i = 0; i < n; ++i) {
                executedObjects[i] = executedValues[i];
            }
            return this.makeGeneric(frame, executedObjects);
        }
    }

    private static class IntegerArrayLiteralNode
    extends ArrayLiteralNode {
        public IntegerArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
            super(context, sourceSection, values);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            int[] executedValues = new int[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                try {
                    executedValues[n] = this.values[n].executeInteger(frame);
                    continue;
                }
                catch (UnexpectedResultException e) {
                    return this.makeGeneric(frame, executedValues, n);
                }
            }
            return this.createArray(executedValues, this.values.length);
        }

        private DynamicObject makeGeneric(VirtualFrame frame, int[] executedValues, int n) {
            Object[] executedObjects = new Object[n];
            for (int i = 0; i < n; ++i) {
                executedObjects[i] = executedValues[i];
            }
            return this.makeGeneric(frame, executedObjects);
        }
    }

    private static class FloatArrayLiteralNode
    extends ArrayLiteralNode {
        public FloatArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
            super(context, sourceSection, values);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            double[] executedValues = new double[this.values.length];
            for (int n = 0; n < this.values.length; ++n) {
                try {
                    executedValues[n] = this.values[n].executeDouble(frame);
                    continue;
                }
                catch (UnexpectedResultException e) {
                    return this.makeGeneric(frame, executedValues, n);
                }
            }
            return this.createArray(executedValues, this.values.length);
        }

        private DynamicObject makeGeneric(VirtualFrame frame, double[] executedValues, int n) {
            Object[] executedObjects = new Object[n];
            for (int i = 0; i < n; ++i) {
                executedObjects[i] = executedValues[i];
            }
            return this.makeGeneric(frame, executedObjects);
        }
    }

    private static class EmptyArrayLiteralNode
    extends ArrayLiteralNode {
        public EmptyArrayLiteralNode(RubyContext context, SourceSection sourceSection, RubyNode[] values) {
            super(context, sourceSection, values);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.createArray(null, 0);
        }
    }
}

