/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.core.StringCodeRangeableWrapper;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.StringLayout;
import org.jruby.util.ByteList;

public class StringLayoutImpl
extends BasicObjectLayoutImpl
implements StringLayout {
    public static final StringLayout INSTANCE = new StringLayoutImpl();
    protected static final Shape.Allocator STRING_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey BYTE_LIST_IDENTIFIER = new HiddenKey("byteList");
    protected static final Property BYTE_LIST_PROPERTY = Property.create((Object)BYTE_LIST_IDENTIFIER, (Location)STRING_ALLOCATOR.locationForType(ByteList.class, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey CODE_RANGE_IDENTIFIER = new HiddenKey("codeRange");
    protected static final Property CODE_RANGE_PROPERTY = Property.create((Object)CODE_RANGE_IDENTIFIER, (Location)STRING_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), (int)0);
    protected static final HiddenKey CODE_RANGEABLE_WRAPPER_IDENTIFIER = new HiddenKey("codeRangeableWrapper");
    protected static final Property CODE_RANGEABLE_WRAPPER_PROPERTY = Property.create((Object)CODE_RANGEABLE_WRAPPER_IDENTIFIER, (Location)STRING_ALLOCATOR.locationForType(StringCodeRangeableWrapper.class), (int)0);

    protected StringLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createStringShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape((ObjectType)new StringType(logicalClass, metaClass)).addProperty(BYTE_LIST_PROPERTY).addProperty(CODE_RANGE_PROPERTY).addProperty(CODE_RANGEABLE_WRAPPER_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createString(DynamicObjectFactory factory, ByteList byteList, int codeRange, StringCodeRangeableWrapper codeRangeableWrapper) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant((Object)factory);
        assert (this.createsString(factory));
        assert (factory.getShape().hasProperty((Object)BYTE_LIST_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)CODE_RANGE_IDENTIFIER));
        assert (factory.getShape().hasProperty((Object)CODE_RANGEABLE_WRAPPER_IDENTIFIER));
        assert (byteList != null);
        return factory.newInstance(new Object[]{byteList, codeRange, codeRangeableWrapper});
    }

    @Override
    public boolean isString(Object object) {
        return object instanceof DynamicObject && this.isString((DynamicObject)object);
    }

    @Override
    public boolean isString(DynamicObject object) {
        return this.isString(object.getShape().getObjectType());
    }

    @Override
    public boolean isString(ObjectType objectType) {
        return objectType instanceof StringType;
    }

    private boolean createsString(DynamicObjectFactory factory) {
        return this.isString(factory.getShape().getObjectType());
    }

    @Override
    public ByteList getByteList(DynamicObject object) {
        assert (this.isString(object));
        assert (object.getShape().hasProperty((Object)BYTE_LIST_IDENTIFIER));
        return (ByteList)BYTE_LIST_PROPERTY.get(object, true);
    }

    @Override
    public void setByteList(DynamicObject object, ByteList value) {
        assert (this.isString(object));
        assert (object.getShape().hasProperty((Object)BYTE_LIST_IDENTIFIER));
        assert (value != null);
        try {
            BYTE_LIST_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public int getCodeRange(DynamicObject object) {
        assert (this.isString(object));
        assert (object.getShape().hasProperty((Object)CODE_RANGE_IDENTIFIER));
        return (Integer)CODE_RANGE_PROPERTY.get(object, true);
    }

    @Override
    public void setCodeRange(DynamicObject object, int value) {
        assert (this.isString(object));
        assert (object.getShape().hasProperty((Object)CODE_RANGE_IDENTIFIER));
        try {
            CODE_RANGE_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public StringCodeRangeableWrapper getCodeRangeableWrapper(DynamicObject object) {
        assert (this.isString(object));
        assert (object.getShape().hasProperty((Object)CODE_RANGEABLE_WRAPPER_IDENTIFIER));
        return (StringCodeRangeableWrapper)CODE_RANGEABLE_WRAPPER_PROPERTY.get(object, true);
    }

    @Override
    public void setCodeRangeableWrapper(DynamicObject object, StringCodeRangeableWrapper value) {
        assert (this.isString(object));
        assert (object.getShape().hasProperty((Object)CODE_RANGEABLE_WRAPPER_IDENTIFIER));
        try {
            CODE_RANGEABLE_WRAPPER_PROPERTY.set(object, (Object)value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class StringType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public StringType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public StringType setLogicalClass(DynamicObject logicalClass) {
            return new StringType(logicalClass, this.metaClass);
        }

        @Override
        public StringType setMetaClass(DynamicObject metaClass) {
            return new StringType(this.logicalClass, metaClass);
        }
    }
}

