/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayMirror;
import org.jruby.truffle.runtime.array.ArrayReflector;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array"), @NodeChild(value="value")})
public abstract class AppendOneNode
extends RubyNode {
    public AppendOneNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract DynamicObject executeAppendOne(DynamicObject var1, Object var2);

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public DynamicObject appendOneEmpty(DynamicObject array, int value) {
        Layouts.ARRAY.setStore(array, new int[]{value});
        Layouts.ARRAY.setSize(array, 1);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public DynamicObject appendOneEmpty(DynamicObject array, long value) {
        Layouts.ARRAY.setStore(array, new long[]{value});
        Layouts.ARRAY.setSize(array, 1);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public DynamicObject appendOneEmpty(DynamicObject array, double value) {
        Layouts.ARRAY.setStore(array, new double[]{value});
        Layouts.ARRAY.setSize(array, 1);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isEmptyArray(array)"})
    public DynamicObject appendOneEmpty(DynamicObject array, Object value) {
        Layouts.ARRAY.setStore(array, new Object[]{value});
        Layouts.ARRAY.setSize(array, 1);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)"})
    public DynamicObject appendOneSameType(DynamicObject array, int value, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendOneSameTypeGeneric(array, ArrayReflector.reflect((int[])Layouts.ARRAY.getStore(array)), value, extendProfile);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)"})
    public DynamicObject appendOneSameType(DynamicObject array, long value, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendOneSameTypeGeneric(array, ArrayReflector.reflect((long[])Layouts.ARRAY.getStore(array)), value, extendProfile);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)"})
    public DynamicObject appendOneSameType(DynamicObject array, double value, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendOneSameTypeGeneric(array, ArrayReflector.reflect((double[])Layouts.ARRAY.getStore(array)), value, extendProfile);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isObjectArray(array)"})
    public DynamicObject appendOneSameType(DynamicObject array, Object value, @Cached(value="createBinaryProfile()") ConditionProfile extendProfile) {
        this.appendOneSameTypeGeneric(array, ArrayReflector.reflect((Object[])Layouts.ARRAY.getStore(array)), value, extendProfile);
        return array;
    }

    public void appendOneSameTypeGeneric(DynamicObject array, ArrayMirror storeMirror, Object value, ConditionProfile extendProfile) {
        int oldSize = Layouts.ARRAY.getSize(array);
        int newSize = oldSize + 1;
        ArrayMirror newStoreMirror = extendProfile.profile(newSize > storeMirror.getLength()) ? storeMirror.copyArrayAndMirror(ArrayUtils.capacity(storeMirror.getLength(), newSize)) : storeMirror;
        newStoreMirror.set(oldSize, value);
        Layouts.ARRAY.setStore(array, newStoreMirror.getArray());
        Layouts.ARRAY.setSize(array, newSize);
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)"})
    public DynamicObject appendOneLongIntoInteger(DynamicObject array, long value) {
        int oldSize = Layouts.ARRAY.getSize(array);
        int newSize = oldSize + 1;
        int[] oldStore = (int[])Layouts.ARRAY.getStore(array);
        long[] newStore = ArrayUtils.longCopyOf(oldStore, ArrayUtils.capacity(oldStore.length, newSize));
        newStore[oldSize] = value;
        Layouts.ARRAY.setStore(array, newStore);
        Layouts.ARRAY.setSize(array, newSize);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isIntArray(array)", "!isInteger(value)", "!isLong(value)"})
    public DynamicObject appendOneGeneralizeInteger(DynamicObject array, Object value) {
        this.appendOneGeneralizeGeneric(array, ArrayReflector.reflect((int[])Layouts.ARRAY.getStore(array)), value);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isLongArray(array)", "!isInteger(value)", "!isLong(value)"})
    public DynamicObject appendOneGeneralizeLong(DynamicObject array, Object value) {
        this.appendOneGeneralizeGeneric(array, ArrayReflector.reflect((long[])Layouts.ARRAY.getStore(array)), value);
        return array;
    }

    @Specialization(guards={"isRubyArray(array)", "isDoubleArray(array)", "!isDouble(value)"})
    public DynamicObject appendOneGeneralizeDouble(DynamicObject array, Object value) {
        this.appendOneGeneralizeGeneric(array, ArrayReflector.reflect((double[])Layouts.ARRAY.getStore(array)), value);
        return array;
    }

    public void appendOneGeneralizeGeneric(DynamicObject array, ArrayMirror storeMirror, Object value) {
        int oldSize = Layouts.ARRAY.getSize(array);
        int newSize = oldSize + 1;
        Object[] newStore = storeMirror.getBoxedCopy(ArrayUtils.capacity(storeMirror.getLength(), newSize));
        newStore[oldSize] = value;
        Layouts.ARRAY.setStore(array, newStore);
        Layouts.ARRAY.setSize(array, newSize);
    }
}

