/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.translator;

import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.KeywordRestArgNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NilImplicitNode;
import org.jruby.ast.Node;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.RequiredKeywordArgumentValueNode;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.arguments.IsNilNode;
import org.jruby.truffle.nodes.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.arguments.MissingKeywordArgumentNode;
import org.jruby.truffle.nodes.arguments.ReadBlockNode;
import org.jruby.truffle.nodes.arguments.ReadKeywordArgumentNode;
import org.jruby.truffle.nodes.arguments.ReadKeywordRestArgumentNode;
import org.jruby.truffle.nodes.arguments.ReadOptionalArgumentNode;
import org.jruby.truffle.nodes.arguments.ReadPostArgumentNode;
import org.jruby.truffle.nodes.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.arguments.ReadRestArgumentNode;
import org.jruby.truffle.nodes.cast.ArrayCastNodeGen;
import org.jruby.truffle.nodes.control.IfNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.array.ArrayLiteralNode;
import org.jruby.truffle.nodes.core.array.ArraySliceNodeGen;
import org.jruby.truffle.nodes.core.array.PrimitiveArrayNodeFactory;
import org.jruby.truffle.nodes.locals.ReadLocalVariableNode;
import org.jruby.truffle.nodes.locals.WriteLocalVariableNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.translator.BodyTranslator;
import org.jruby.truffle.translator.ParameterCollector;
import org.jruby.truffle.translator.ReadNode;
import org.jruby.truffle.translator.Translator;

public class LoadArgumentsTranslator
extends Translator {
    private final boolean isBlock;
    private final BodyTranslator methodBodyTranslator;
    private final Deque<ArraySlot> arraySlotStack = new ArrayDeque<ArraySlot>();
    private int required;
    private int index;
    private int kwIndex;
    private int countKwArgs;
    private int indexFromEnd = 1;
    private State state;
    private boolean hasKeywordArguments;
    private List<String> excludedKeywords = new ArrayList<String>();
    private ArgsNode argsNode;

    public LoadArgumentsTranslator(com.oracle.truffle.api.nodes.Node currentNode, RubyContext context, Source source, boolean isBlock, BodyTranslator methodBodyTranslator) {
        super(currentNode, context, source);
        this.isBlock = isBlock;
        this.methodBodyTranslator = methodBodyTranslator;
    }

    public RubyNode visitArgsNode(ArgsNode node) {
        int postCount;
        int optArgCount;
        this.argsNode = node;
        SourceSection sourceSection = this.translate(node.getPosition());
        ArrayList<RubyNode> sequence = new ArrayList<RubyNode>();
        Node[] args = node.getArgs();
        int preCount = node.getPreCount();
        if (preCount > 0) {
            this.state = State.PRE;
            this.index = 0;
            for (int i = 0; i < preCount; ++i) {
                sequence.add((RubyNode)((Object)args[i].accept((NodeVisitor)this)));
                ++this.index;
                ++this.required;
            }
        }
        if ((optArgCount = node.getOptionalArgsCount()) > 0) {
            this.state = State.OPT;
            this.index = this.argsNode.getPreCount();
            int optArgIndex = node.getOptArgIndex();
            for (int i = 0; i < optArgCount; ++i) {
                sequence.add((RubyNode)((Object)args[optArgIndex + i].accept((NodeVisitor)this)));
                ++this.index;
            }
        }
        this.hasKeywordArguments = node.hasKwargs();
        if (node.getRestArgNode() != null) {
            this.methodBodyTranslator.getEnvironment().hasRestParameter = true;
            sequence.add((RubyNode)((Object)node.getRestArgNode().accept((NodeVisitor)this)));
        }
        if ((postCount = node.getPostCount()) > 0) {
            this.state = State.POST;
            this.index = -1;
            int postIndex = node.getPostIndex();
            for (int i = postCount - 1; i >= 0; --i) {
                sequence.add((RubyNode)((Object)args[postIndex + i].accept((NodeVisitor)this)));
                ++this.required;
                --this.index;
            }
        }
        if (this.hasKeywordArguments) {
            this.kwIndex = 0;
            this.countKwArgs = 0;
            int keywordIndex = node.getKeywordsIndex();
            int keywordCount = node.getKeywordCount();
            for (int i = 0; i < keywordCount; ++i) {
                sequence.add((RubyNode)((Object)args[keywordIndex + i].accept((NodeVisitor)this)));
                ++this.kwIndex;
                ++this.countKwArgs;
            }
        }
        if (node.getKeyRest() != null) {
            sequence.add((RubyNode)((Object)node.getKeyRest().accept((NodeVisitor)this)));
        }
        if (node.getBlock() != null) {
            sequence.add((RubyNode)((Object)node.getBlock().accept((NodeVisitor)this)));
        }
        return SequenceNode.sequence(this.context, sourceSection, sequence);
    }

    public RubyNode visitKeywordRestArgNode(KeywordRestArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ReadKeywordRestArgumentNode readNode = new ReadKeywordRestArgumentNode(this.context, sourceSection, this.required, this.excludedKeywords.toArray(new String[this.excludedKeywords.size()]), -this.countKwArgs - 1);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findOrAddFrameSlot((Object)node.getName());
        return new WriteLocalVariableNode(this.context, sourceSection, readNode, slot);
    }

    public RubyNode visitKeywordArgNode(KeywordArgNode node) {
        String name;
        LocalAsgnNode asgnNode;
        SourceSection sourceSection = this.translate(node.getPosition());
        Node firstChild = (Node)node.childNodes().get(0);
        if (firstChild instanceof LocalAsgnNode) {
            asgnNode = (LocalAsgnNode)firstChild;
            name = ((LocalAsgnNode)firstChild).getName();
        } else if (firstChild instanceof DAsgnNode) {
            asgnNode = (DAsgnNode)firstChild;
            name = ((DAsgnNode)firstChild).getName();
        } else {
            throw new UnsupportedOperationException("unsupported keyword arg " + node);
        }
        RubyNode defaultValue = asgnNode.getValueNode() instanceof RequiredKeywordArgumentValueNode ? new MissingKeywordArgumentNode(this.context, sourceSection, name) : this.translateNodeOrNil(sourceSection, asgnNode.getValueNode());
        this.excludedKeywords.add(name);
        ReadKeywordArgumentNode readNode = new ReadKeywordArgumentNode(this.context, sourceSection, this.required, name, defaultValue, this.kwIndex - this.countKwArgs);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findOrAddFrameSlot((Object)name);
        return new WriteLocalVariableNode(this.context, sourceSection, readNode, slot);
    }

    public RubyNode visitArgumentNode(ArgumentNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        RubyNode readNode = this.readArgument(sourceSection);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot((Object)node.getName());
        return new WriteLocalVariableNode(this.context, sourceSection, readNode, slot);
    }

    private RubyNode readArgument(SourceSection sourceSection) {
        if (this.useArray()) {
            return PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.loadArray(sourceSection), this.index);
        }
        if (this.state == State.PRE) {
            return new ReadPreArgumentNode(this.context, sourceSection, this.index, this.isBlock ? MissingArgumentBehaviour.NIL : MissingArgumentBehaviour.RUNTIME_ERROR);
        }
        if (this.state == State.POST) {
            return new ReadPostArgumentNode(this.context, sourceSection, this.index);
        }
        throw new IllegalStateException();
    }

    public RubyNode visitRestArgNode(RestArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        if (this.argsNode == null) {
            throw new IllegalStateException("No arguments node visited");
        }
        int from = this.argsNode.getPreCount() + this.argsNode.getOptionalArgsCount();
        int to = -this.argsNode.getPostCount();
        RubyNode readNode = this.useArray() ? ArraySliceNodeGen.create(this.context, sourceSection, from, to, this.loadArray(sourceSection)) : new ReadRestArgumentNode(this.context, sourceSection, from, to, this.hasKeywordArguments);
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot((Object)node.getName());
        return new WriteLocalVariableNode(this.context, sourceSection, readNode, slot);
    }

    public RubyNode visitBlockArgNode(BlockArgNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        ReadBlockNode readNode = new ReadBlockNode(this.context, sourceSection, this.context.getCoreLibrary().getNilObject());
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findFrameSlot((Object)node.getName());
        return new WriteLocalVariableNode(this.context, sourceSection, readNode, slot);
    }

    public RubyNode visitOptArgNode(OptArgNode node) {
        return (RubyNode)((Object)node.getValue().accept((NodeVisitor)this));
    }

    public RubyNode visitLocalAsgnNode(LocalAsgnNode node) {
        return this.translateLocalAssignment(node.getPosition(), node.getName(), node.getValueNode());
    }

    public RubyNode visitDAsgnNode(DAsgnNode node) {
        return this.translateLocalAssignment(node.getPosition(), node.getName(), node.getValueNode());
    }

    private RubyNode translateLocalAssignment(ISourcePosition sourcePosition, String name, Node valueNode) {
        RubyNode readNode;
        SourceSection sourceSection = this.translate(sourcePosition);
        if (this.indexFromEnd == 1) {
            if (valueNode instanceof NilImplicitNode) {
                readNode = this.useArray() ? PrimitiveArrayNodeFactory.read(this.context, sourceSection, this.loadArray(sourceSection), this.index) : this.readArgument(sourceSection);
            } else {
                RubyNode defaultValue = (RubyNode)((Object)valueNode.accept((NodeVisitor)this));
                if (this.argsNode == null) {
                    throw new IllegalStateException("No arguments node visited");
                }
                int minimum = this.index + 1 + this.argsNode.getPostCount();
                if (this.argsNode.hasKwargs()) {
                    ++minimum;
                }
                readNode = new ReadOptionalArgumentNode(this.context, sourceSection, this.index, minimum, defaultValue);
            }
        } else {
            readNode = ArraySliceNodeGen.create(this.context, sourceSection, this.index, this.indexFromEnd, this.loadArray(sourceSection));
        }
        FrameSlot slot = this.methodBodyTranslator.getEnvironment().getFrameDescriptor().findOrAddFrameSlot((Object)name);
        return new WriteLocalVariableNode(this.context, sourceSection, readNode, slot);
    }

    public RubyNode visitArrayNode(ArrayNode node) {
        if (node.size() == 1 && node.get(0) instanceof MultipleAsgnNode) {
            return (RubyNode)((Object)node.children()[0].accept((NodeVisitor)this));
        }
        return this.defaultVisit((Node)node);
    }

    public RubyNode visitMultipleAsgnNode(MultipleAsgnNode node) {
        SourceSection sourceSection = this.translate(node.getPosition());
        int arrayIndex = this.index;
        String arrayName = this.methodBodyTranslator.getEnvironment().allocateLocalTemp("destructure");
        FrameSlot arraySlot = this.methodBodyTranslator.getEnvironment().declareVar(arrayName);
        this.pushArraySlot(arraySlot);
        List childNodes = node.childNodes() == null || node.childNodes().get(0) == null ? Collections.emptyList() : ((Node)node.childNodes().get(0)).childNodes();
        ArrayList<RubyNode> notNilSequence = new ArrayList<RubyNode>();
        if (node.getPre() != null) {
            this.index = 0;
            for (Node child : node.getPre().children()) {
                notNilSequence.add((RubyNode)((Object)child.accept((NodeVisitor)this)));
                ++this.index;
            }
        }
        if (node.getRest() != null) {
            this.index = node.getPreCount();
            this.indexFromEnd = -node.getPostCount();
            notNilSequence.add((RubyNode)((Object)node.getRest().accept((NodeVisitor)this)));
            this.indexFromEnd = 1;
        }
        if (node.getPost() != null) {
            Node[] children = node.getPost().children();
            this.index = -1;
            for (int i = children.length - 1; i >= 0; --i) {
                notNilSequence.add((RubyNode)((Object)children[i].accept((NodeVisitor)this)));
                ++this.required;
                --this.index;
            }
        }
        RubyNode notNil = SequenceNode.sequence(this.context, sourceSection, notNilSequence);
        this.popArraySlot(arraySlot);
        ArrayList<RubyNode> nilSequence = new ArrayList<RubyNode>();
        ParameterCollector parametersToClearCollector = new ParameterCollector();
        if (node.getPre() != null) {
            for (Node child : node.getPre().children()) {
                child.accept((NodeVisitor)parametersToClearCollector);
            }
        }
        if (node.getRest() != null) {
            if (node.getRest() instanceof INameNode) {
                String name = ((INameNode)node.getRest()).getName();
                nilSequence.add(((ReadNode)((Object)this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(name, sourceSection))).makeWriteNode(new ArrayLiteralNode.UninitialisedArrayLiteralNode(this.context, sourceSection, new RubyNode[0])));
            } else if (!(node.getRest() instanceof StarNode)) {
                throw new UnsupportedOperationException("unsupported rest node " + node.getRest());
            }
        }
        if (node.getPost() != null) {
            for (Node child : node.getPost().children()) {
                child.accept((NodeVisitor)parametersToClearCollector);
            }
        }
        for (String parameterToClear : parametersToClearCollector.getParameters()) {
            nilSequence.add(((ReadNode)((Object)this.methodBodyTranslator.getEnvironment().findOrAddLocalVarNodeDangerous(parameterToClear, sourceSection))).makeWriteNode(this.nilNode(sourceSection)));
        }
        if (!childNodes.isEmpty()) {
            this.index = arrayIndex;
            nilSequence.add((RubyNode)((Object)((Node)childNodes.get(0)).accept((NodeVisitor)this)));
        }
        RubyNode nil = SequenceNode.sequence(this.context, sourceSection, nilSequence);
        return SequenceNode.sequence(this.context, sourceSection, new WriteLocalVariableNode(this.context, sourceSection, ArrayCastNodeGen.create(this.context, sourceSection, this.readArgument(sourceSection)), arraySlot), new IfNode(this.context, sourceSection, new IsNilNode(this.context, sourceSection, new ReadLocalVariableNode(this.context, sourceSection, arraySlot)), nil, notNil == null ? this.nilNode(sourceSection) : notNil));
    }

    protected RubyNode defaultVisit(Node node) {
        return (RubyNode)((Object)node.accept((NodeVisitor)this.methodBodyTranslator));
    }

    public void pushArraySlot(FrameSlot slot) {
        this.arraySlotStack.push(new ArraySlot(slot, this.index));
    }

    public void popArraySlot(FrameSlot slot) {
        this.index = this.arraySlotStack.pop().getPreviousIndex();
    }

    protected boolean useArray() {
        return !this.arraySlotStack.isEmpty();
    }

    protected RubyNode loadArray(SourceSection sourceSection) {
        return new ReadLocalVariableNode(this.context, sourceSection, this.arraySlotStack.peek().getArraySlot());
    }

    @Override
    protected String getIdentifier() {
        return this.methodBodyTranslator.getIdentifier();
    }

    private static enum State {
        PRE,
        OPT,
        POST;

    }

    private static class ArraySlot {
        private FrameSlot arraySlot;
        private int previousIndex;

        public ArraySlot(FrameSlot arraySlot, int previousIndex) {
            this.arraySlot = arraySlot;
            this.previousIndex = previousIndex;
        }

        public FrameSlot getArraySlot() {
            return this.arraySlot;
        }

        public int getPreviousIndex() {
            return this.previousIndex;
        }
    }
}

