/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.object.DynamicObject;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.FiberNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public class FiberManager {
    private final DynamicObject rootFiber;
    private DynamicObject currentFiber;
    private final Set<DynamicObject> runningFibers = Collections.newSetFromMap(new ConcurrentHashMap());

    public FiberManager(RubyContext context, DynamicObject rubyThread) {
        this.currentFiber = this.rootFiber = FiberNodes.createRootFiber(context, rubyThread);
    }

    public DynamicObject getRootFiber() {
        return this.rootFiber;
    }

    public DynamicObject getCurrentFiber() {
        return this.currentFiber;
    }

    public void setCurrentFiber(DynamicObject fiber) {
        assert (RubyGuards.isRubyFiber(fiber));
        this.currentFiber = fiber;
    }

    public void registerFiber(DynamicObject fiber) {
        assert (RubyGuards.isRubyFiber(fiber));
        this.runningFibers.add(fiber);
    }

    public void unregisterFiber(DynamicObject fiber) {
        assert (RubyGuards.isRubyFiber(fiber));
        this.runningFibers.remove(fiber);
    }

    public void shutdown() {
        for (DynamicObject fiber : this.runningFibers) {
            if (Layouts.FIBER.getRootFiber(fiber)) continue;
            FiberNodes.shutdown(fiber);
        }
    }
}

