/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

public class SymbolTable {
    private final RubyContext context;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final WeakHashMap<ByteList, WeakReference<DynamicObject>> symbolsTable = new WeakHashMap();

    public SymbolTable(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject getSymbol(String string) {
        return this.getSymbol(ByteList.create((CharSequence)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public DynamicObject getSymbol(ByteList bytes) {
        DynamicObject symbol;
        WeakReference<DynamicObject> symbolReference;
        this.lock.readLock().lock();
        try {
            symbolReference = this.symbolsTable.get(bytes);
            if (symbolReference != null && (symbol = (DynamicObject)symbolReference.get()) != null) {
                DynamicObject dynamicObject = symbol;
                return dynamicObject;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            symbolReference = this.symbolsTable.get(bytes);
            if (symbolReference != null && (symbol = (DynamicObject)symbolReference.get()) != null) {
                DynamicObject dynamicObject = symbol;
                return dynamicObject;
            }
            ByteList storedBytes = bytes.dup();
            DynamicObject symbolClass = this.context.getCoreLibrary().getSymbolClass();
            DynamicObject newSymbol = Layouts.SYMBOL.createSymbol(Layouts.CLASS.getInstanceFactory(symbolClass), storedBytes.toString(), storedBytes, storedBytes.toString().hashCode(), 0, null);
            this.symbolsTable.put(storedBytes, new WeakReference<DynamicObject>(newSymbol));
            DynamicObject dynamicObject = newSymbol;
            return dynamicObject;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Collection<DynamicObject> allSymbols() {
        Collection<WeakReference<DynamicObject>> symbolReferences;
        this.lock.readLock().lock();
        try {
            symbolReferences = this.symbolsTable.values();
        }
        finally {
            this.lock.readLock().unlock();
        }
        ArrayList<DynamicObject> symbols = new ArrayList<DynamicObject>(symbolReferences.size());
        for (WeakReference<DynamicObject> reference : symbolReferences) {
            DynamicObject symbol = (DynamicObject)reference.get();
            if (symbol == null) continue;
            symbols.add(symbol);
        }
        return symbols;
    }
}

