/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jcodings.Ptr;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.EConvResult;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.EncodingConverterNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

public abstract class EncodingConverterPrimitiveNodes {

    @RubiniusPrimitive(name="encoding_converter_primitive_errinfo")
    public static abstract class EncodingConverterErrinfoNode
    extends RubiniusPrimitiveNode {
        public EncodingConverterErrinfoNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object encodingConverterLastError(DynamicObject encodingConverter) {
            CompilerDirectives.transferToInterpreter();
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            Object[] ret = new Object[]{this.getSymbol(ec.lastError.getResult().symbolicName()), this.nil(), this.nil(), this.nil(), this.nil()};
            if (ec.lastError.getSource() != null) {
                ret[1] = this.createString(new ByteList(ec.lastError.getSource()));
            }
            if (ec.lastError.getDestination() != null) {
                ret[2] = this.createString(new ByteList(ec.lastError.getDestination()));
            }
            if (ec.lastError.getErrorBytes() != null) {
                ret[3] = this.createString(new ByteList(ec.lastError.getErrorBytes(), ec.lastError.getErrorBytesP(), ec.lastError.getErrorBytesLength()));
                ret[4] = this.createString(new ByteList(ec.lastError.getErrorBytes(), ec.lastError.getErrorBytesP() + ec.lastError.getErrorBytesLength(), ec.lastError.getReadAgainLength()));
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), ret, ret.length);
        }
    }

    @RubiniusPrimitive(name="encoding_converter_last_error")
    public static abstract class EncodingConverterLastErrorNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;

        public EncodingConverterLastErrorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.newLookupTableNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupTableWriteNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object encodingConverterLastError(VirtualFrame frame, DynamicObject encodingConverter) {
            CompilerDirectives.transferToInterpreter();
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            EConv.LastError lastError = ec.lastError;
            if (lastError.getResult() != EConvResult.InvalidByteSequence && lastError.getResult() != EConvResult.IncompleteInput && lastError.getResult() != EConvResult.UndefinedConversion) {
                return this.nil();
            }
            Object ret = this.newLookupTableNode.call(frame, this.getContext().getCoreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("result"), this.eConvResultToSymbol(lastError.getResult()));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("source_encoding_name"), this.createString(new ByteList(lastError.getSource())));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("destination_encoding_name"), this.createString(new ByteList(lastError.getDestination())));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("error_bytes"), this.createString(new ByteList(lastError.getErrorBytes())));
            if (lastError.getReadAgainLength() != 0) {
                this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("read_again_bytes"), lastError.getReadAgainLength());
            }
            return ret;
        }

        private DynamicObject eConvResultToSymbol(EConvResult result) {
            switch (result) {
                case InvalidByteSequence: {
                    return this.getSymbol("invalid_byte_sequence");
                }
                case UndefinedConversion: {
                    return this.getSymbol("undefined_conversion");
                }
                case DestinationBufferFull: {
                    return this.getSymbol("destination_buffer_full");
                }
                case SourceBufferEmpty: {
                    return this.getSymbol("source_buffer_empty");
                }
                case Finished: {
                    return this.getSymbol("finished");
                }
                case AfterOutput: {
                    return this.getSymbol("after_output");
                }
                case IncompleteInput: {
                    return this.getSymbol("incomplete_input");
                }
            }
            throw new UnsupportedOperationException(String.format("Unknown EConv result: %s", result));
        }
    }

    @RubiniusPrimitive(name="encoding_converter_putback")
    public static abstract class EncodingConverterPutbackNode
    extends RubiniusPrimitiveNode {
        public EncodingConverterPutbackNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject encodingConverterPutback(DynamicObject encodingConverter, int maxBytes) {
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            int putbackable = ec.putbackable();
            return this.putback(encodingConverter, putbackable < maxBytes ? putbackable : maxBytes);
        }

        @Specialization
        public DynamicObject encodingConverterPutback(DynamicObject encodingConverter, NotProvided maxBytes) {
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            return this.putback(encodingConverter, ec.putbackable());
        }

        private DynamicObject putback(DynamicObject encodingConverter, int n) {
            assert (RubyGuards.isRubyEncodingConverter(encodingConverter));
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            ByteList bytes = new ByteList(n);
            ec.putback(bytes.getUnsafeBytes(), bytes.getBegin(), n);
            bytes.setRealSize(n);
            if (ec.sourceEncoding != null) {
                bytes.setEncoding(ec.sourceEncoding);
            }
            return this.createString(bytes);
        }
    }

    @RubiniusPrimitive(name="encoding_converter_primitive_convert")
    public static abstract class PrimitiveConvertNode
    extends RubiniusPrimitiveNode {
        private final ConditionProfile nonNullSourceProfile = ConditionProfile.createBinaryProfile();

        public PrimitiveConvertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyString(target)", "isRubyHash(options)"})
        public Object encodingConverterPrimitiveConvert(DynamicObject encodingConverter, DynamicObject source, DynamicObject target, int offset, int size, DynamicObject options) {
            throw new UnsupportedOperationException("not implemented");
        }

        @Specialization(guards={"isNil(source)", "isRubyString(target)"})
        public Object primitiveConvertNilSource(DynamicObject encodingConverter, DynamicObject source, DynamicObject target, int offset, int size, int options) {
            return this.primitiveConvertHelper(encodingConverter, new ByteList(), source, target, offset, size, options);
        }

        @Specialization(guards={"isRubyString(source)", "isRubyString(target)"})
        public Object encodingConverterPrimitiveConvert(DynamicObject encodingConverter, DynamicObject source, DynamicObject target, int offset, int size, int options) {
            StringOperations.modify(source);
            StringOperations.clearCodeRange(source);
            return this.primitiveConvertHelper(encodingConverter, StringOperations.getByteList(source), source, target, offset, size, options);
        }

        @CompilerDirectives.TruffleBoundary
        private Object primitiveConvertHelper(DynamicObject encodingConverter, ByteList inBytes, DynamicObject source, DynamicObject target, int offset, int size, int options) {
            EConvResult res;
            boolean growOutputBuffer;
            boolean nonNullSource = source != this.nil();
            StringOperations.modify(target);
            StringOperations.clearCodeRange(target);
            ByteList outBytes = StringOperations.getByteList(target);
            Ptr inPtr = new Ptr();
            Ptr outPtr = new Ptr();
            EConv ec = Layouts.ENCODING_CONVERTER.getEconv(encodingConverter);
            boolean changeOffset = offset == 0;
            boolean bl = growOutputBuffer = size == -1;
            if (size == -1) {
                size = 16;
                if (this.nonNullSourceProfile.profile(nonNullSource) && size < StringOperations.getByteList(source).getRealSize()) {
                    size = StringOperations.getByteList(source).getRealSize();
                }
            }
            while (true) {
                if (changeOffset) {
                    offset = outBytes.getRealSize();
                }
                if (outBytes.getRealSize() < offset) {
                    throw new RaiseException(this.getContext().getCoreLibrary().argumentError("output offset too big", this));
                }
                long outputByteEnd = offset + size;
                if (outputByteEnd > Integer.MAX_VALUE) {
                    throw new RaiseException(this.getContext().getCoreLibrary().argumentError("output offset + bytesize too big", this));
                }
                outBytes.ensure((int)outputByteEnd);
                inPtr.p = inBytes.getBegin();
                outPtr.p = outBytes.getBegin() + offset;
                int os = outPtr.p + size;
                res = ec.convert(inBytes.getUnsafeBytes(), inPtr, inBytes.getRealSize() + inPtr.p, outBytes.getUnsafeBytes(), outPtr, os, options);
                outBytes.setRealSize(outPtr.p - outBytes.begin());
                if (this.nonNullSourceProfile.profile(nonNullSource)) {
                    StringOperations.getByteList(source).setRealSize(inBytes.getRealSize() - (inPtr.p - inBytes.getBegin()));
                    StringOperations.getByteList(source).setBegin(inPtr.p);
                }
                if (!growOutputBuffer || res != EConvResult.DestinationBufferFull) break;
                if (0x3FFFFFFF < size) {
                    throw new RaiseException(this.getContext().getCoreLibrary().argumentError("too long conversion result", this));
                }
                size *= 2;
            }
            if (ec.destinationEncoding != null) {
                outBytes.setEncoding(ec.destinationEncoding);
            }
            return this.getSymbol(res.symbolicName());
        }
    }

    @RubiniusPrimitive(name="encoding_converter_allocate")
    public static abstract class EncodingConverterAllocateNode
    extends RubiniusPrimitiveNode {
        public EncodingConverterAllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object encodingConverterAllocate(DynamicObject encodingConverterClass, NotProvided unused1, NotProvided unused2) {
            return EncodingConverterNodes.createEncodingConverter(encodingConverterClass, null);
        }
    }
}

