/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.Location;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.runtime.Options;

public abstract class WriteHeadObjectFieldNode
extends Node {
    private final Object name;

    public WriteHeadObjectFieldNode(Object name) {
        this.name = name;
    }

    public Object getName() {
        return this.name;
    }

    public abstract void execute(DynamicObject var1, Object var2);

    @Specialization(guards={"location != null", "object.getShape() == cachedShape"}, assumptions={"newArray(cachedShape.getValidAssumption(), validLocation)"}, limit="getCacheLimit()")
    public void writeExistingField(DynamicObject object, Object value, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="getLocation(object, value)") Location location, @Cached(value="createAssumption()") Assumption validLocation) {
        try {
            location.set(object, value, cachedShape);
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            validLocation.invalidate();
            this.execute(object, value);
        }
    }

    @Specialization(guards={"!hasField", "object.getShape() == oldShape"}, assumptions={"newArray(oldShape.getValidAssumption(), newShape.getValidAssumption(), validLocation)"}, limit="getCacheLimit()")
    public void writeNewField(DynamicObject object, Object value, @Cached(value="hasField(object, value)") boolean hasField, @Cached(value="object.getShape()") Shape oldShape, @Cached(value="transitionWithNewField(oldShape, value)") Shape newShape, @Cached(value="getNewLocation(newShape)") Location location, @Cached(value="createAssumption()") Assumption validLocation) {
        try {
            location.set(object, value, oldShape, newShape);
        }
        catch (IncompatibleLocationException e) {
            validLocation.invalidate();
            this.execute(object, value);
        }
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization
    public void writeUncached(DynamicObject object, Object value) {
        object.updateShape();
        Shape shape = object.getShape();
        Property property = shape.getProperty(this.name);
        if (property == null) {
            object.define(this.name, value, 0);
        } else {
            property.setGeneric(object, value, shape);
        }
    }

    protected Location getLocation(DynamicObject object, Object value) {
        object.updateShape();
        Shape oldShape = object.getShape();
        Property property = oldShape.getProperty(this.name);
        if (property != null && property.getLocation().canSet(object, value)) {
            return property.getLocation();
        }
        return null;
    }

    protected boolean hasField(DynamicObject object, Object value) {
        return this.getLocation(object, value) != null;
    }

    protected Shape transitionWithNewField(Shape oldShape, Object value) {
        Property oldProperty = oldShape.getProperty(this.name);
        if (oldProperty != null) {
            if (oldProperty.getFlags() == 0 && oldProperty.getLocation().canSet(null, value)) {
                return oldShape;
            }
            DynamicObject copy = oldShape.getLayout().newInstance(oldShape);
            copy.define(this.name, value, 0);
            return copy.getShape();
        }
        Location location = oldShape.allocator().locationForValue(value, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull));
        Property newProperty = Property.create((Object)this.name, (Location)location, (int)0);
        return oldShape.addProperty(newProperty);
    }

    protected Location getNewLocation(Shape newShape) {
        return newShape.getProperty(this.name).getLocation();
    }

    protected Assumption createAssumption() {
        return Truffle.getRuntime().createAssumption();
    }

    protected int getCacheLimit() {
        return Options.FIELD_LOOKUP_CACHE;
    }

    protected Assumption[] newArray(Assumption a1, Assumption a2, Assumption a3) {
        return new Assumption[]{a1, a2, a3};
    }

    protected Assumption[] newArray(Assumption a1, Assumption a2) {
        return new Assumption[]{a1, a2};
    }
}

