/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.methods.InternalMethod;

public abstract class CachedDispatchNode
extends DispatchNode {
    private final Object cachedName;
    private final DynamicObject cachedNameAsSymbol;
    @Node.Child
    protected DispatchNode next;
    private final BranchProfile moreThanReferenceCompare = BranchProfile.create();

    public CachedDispatchNode(RubyContext context, Object cachedName, DispatchNode next, DispatchAction dispatchAction) {
        super(context, dispatchAction);
        assert (cachedName instanceof String || RubyGuards.isRubySymbol(cachedName) || RubyGuards.isRubyString(cachedName));
        this.cachedName = cachedName;
        if (RubyGuards.isRubySymbol(cachedName)) {
            this.cachedNameAsSymbol = (DynamicObject)cachedName;
        } else if (RubyGuards.isRubyString(cachedName)) {
            this.cachedNameAsSymbol = context.getSymbol(StringOperations.getByteList((DynamicObject)cachedName));
        } else if (cachedName instanceof String) {
            this.cachedNameAsSymbol = context.getSymbol((String)cachedName);
        } else {
            throw new UnsupportedOperationException();
        }
        this.next = next;
    }

    @Override
    protected DispatchNode getNext() {
        return this.next;
    }

    protected final boolean guardName(Object methodName) {
        if (this.cachedName == methodName) {
            return true;
        }
        this.moreThanReferenceCompare.enter();
        if (this.cachedName instanceof String) {
            return this.cachedName.equals(methodName);
        }
        if (RubyGuards.isRubySymbol(this.cachedName)) {
            return this.cachedName == methodName;
        }
        if (RubyGuards.isRubyString(this.cachedName)) {
            return RubyGuards.isRubyString(methodName) && StringOperations.getByteList((DynamicObject)this.cachedName).equal(StringOperations.getByteList((DynamicObject)methodName));
        }
        throw new UnsupportedOperationException();
    }

    protected DynamicObject getCachedNameAsSymbol() {
        return this.cachedNameAsSymbol;
    }

    protected void applySplittingInliningStrategy(DirectCallNode callNode, InternalMethod method) {
        if (callNode.isCallTargetCloningAllowed() && method.getSharedMethodInfo().shouldAlwaysClone()) {
            this.insert((Node)callNode);
            callNode.cloneCallTarget();
        }
        if (method.getSharedMethodInfo().shouldAlwaysInline() && callNode.isInlinable()) {
            callNode.forceInlining();
        }
    }

    protected static Object call(DirectCallNode callNode, VirtualFrame frame, InternalMethod method, Object receiver, DynamicObject block, Object[] arguments) {
        CompilerAsserts.compilationConstant((Object)method.getSharedMethodInfo().needsCallerFrame());
        return callNode.call(frame, RubyArguments.pack(method, method.getDeclarationFrame(), method.getSharedMethodInfo().needsCallerFrame() ? frame.materialize() : null, receiver, block, DeclarationContext.METHOD, arguments));
    }
}

