/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

@ImportStatic(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class), @NodeChild(value="length", type=RubyNode.class)})
public abstract class ArrayReadSliceNormalizedNode
extends RubyNode {
    @Node.Child
    private AllocateObjectNode allocateObjectNode;

    public ArrayReadSliceNormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
    }

    public abstract Object executeReadSlice(VirtualFrame var1, DynamicObject var2, int var3, int var4);

    @Specialization(guards={"isRubyArray(array)", "!indexInBounds(array, index)"})
    public DynamicObject readIndexOutOfBounds(DynamicObject array, int index, int length) {
        return this.nil();
    }

    @Specialization(guards={"isRubyArray(array)", "!lengthPositive(length)"})
    public DynamicObject readNegativeLength(DynamicObject array, int index, int length) {
        return this.nil();
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "isNullArray(array)"})
    public DynamicObject readNull(DynamicObject array, int index, int length) {
        return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), null, 0);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "endInBounds(array, index, length)", "isIntArray(array)"})
    public DynamicObject readIntInBounds(DynamicObject array, int index, int length) {
        return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), Arrays.copyOfRange((int[])Layouts.ARRAY.getStore(array), index, index + length), length);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "endInBounds(array, index, length)", "isLongArray(array)"})
    public DynamicObject readLongInBounds(DynamicObject array, int index, int length) {
        return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), Arrays.copyOfRange((long[])Layouts.ARRAY.getStore(array), index, index + length), length);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "endInBounds(array, index, length)", "isDoubleArray(array)"})
    public DynamicObject readDoubleInBounds(DynamicObject array, int index, int length) {
        return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), Arrays.copyOfRange((double[])Layouts.ARRAY.getStore(array), index, index + length), length);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "endInBounds(array, index, length)", "isObjectArray(array)"})
    public DynamicObject readObjectInBounds(DynamicObject array, int index, int length) {
        return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), Arrays.copyOfRange((Object[])Layouts.ARRAY.getStore(array), index, index + length), length);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "!endInBounds(array, index, length)", "isIntArray(array)"})
    public DynamicObject readIntOutOfBounds(DynamicObject array, int index, int length) {
        int clampedLength = Math.min(Layouts.ARRAY.getSize(array), index + length) - index;
        return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), Arrays.copyOfRange((int[])Layouts.ARRAY.getStore(array), index, index + clampedLength), clampedLength);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "!endInBounds(array, index, length)", "isLongArray(array)"})
    public DynamicObject readLongOutOfBounds(DynamicObject array, int index, int length) {
        int clampedLength = Math.min(Layouts.ARRAY.getSize(array), index + length) - index;
        return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), Arrays.copyOfRange((long[])Layouts.ARRAY.getStore(array), index, index + clampedLength), clampedLength);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "!endInBounds(array, index, length)", "isDoubleArray(array)"})
    public DynamicObject readDoubleOutOfBounds(DynamicObject array, int index, int length) {
        int clampedLength = Math.min(Layouts.ARRAY.getSize(array), index + length) - index;
        return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), Arrays.copyOfRange((double[])Layouts.ARRAY.getStore(array), index, index + clampedLength), clampedLength);
    }

    @Specialization(guards={"isRubyArray(array)", "indexInBounds(array, index)", "lengthPositive(length)", "!endInBounds(array, index, length)", "isObjectArray(array)"})
    public DynamicObject readObjectOutOfBounds(DynamicObject array, int index, int length) {
        int clampedLength = Math.min(Layouts.ARRAY.getSize(array), index + length) - index;
        return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), Arrays.copyOfRange((Object[])Layouts.ARRAY.getStore(array), index, index + clampedLength), clampedLength);
    }

    protected static boolean indexInBounds(DynamicObject array, int index) {
        return index >= 0 && index <= Layouts.ARRAY.getSize(array);
    }

    protected static boolean lengthPositive(int length) {
        return length >= 0;
    }

    protected static boolean endInBounds(DynamicObject array, int index, int length) {
        return index + length < Layouts.ARRAY.getSize(array);
    }
}

