/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.ModuleNodes;
import org.jruby.truffle.nodes.core.ModuleNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.ModuleFields;
import org.jruby.truffle.runtime.layouts.Layouts;

@CoreClass(name="Class")
public abstract class ClassNodes {
    private static final Layout LAYOUT = Layout.createLayout();

    public static DynamicObject createClassClass(RubyContext context) {
        ModuleFields model = new ModuleFields(context, null, "Class");
        DynamicObject rubyClass = LAYOUT.newInstance(LAYOUT.createShape(new ObjectType()));
        DynamicObjectFactory factory = Layouts.CLASS.createClassShape(rubyClass, rubyClass);
        rubyClass.setShapeAndGrow(rubyClass.getShape(), factory.getShape());
        assert (RubyGuards.isRubyModule(rubyClass));
        assert (RubyGuards.isRubyClass(rubyClass));
        model.rubyModuleObject = rubyClass;
        Layouts.CLASS.setInstanceFactoryUnsafe(rubyClass, factory);
        Layouts.MODULE.setFields(rubyClass, model);
        model.setFullName(model.givenBaseName);
        assert (RubyGuards.isRubyModule(rubyClass));
        assert (RubyGuards.isRubyClass(rubyClass));
        assert (Layouts.MODULE.getFields(rubyClass) == model);
        assert (Layouts.BASIC_OBJECT.getLogicalClass(rubyClass) == rubyClass);
        return rubyClass;
    }

    public static DynamicObject createBootClass(RubyContext context, DynamicObject classClass, DynamicObject superclass, String name) {
        assert (RubyGuards.isRubyClass(classClass));
        assert (superclass == null || RubyGuards.isRubyClass(superclass));
        ModuleFields model = new ModuleFields(context, null, name);
        DynamicObject rubyClass = Layouts.CLASS.createClass(Layouts.CLASS.getInstanceFactory(classClass), model, false, null, null);
        assert (RubyGuards.isRubyClass(rubyClass)) : classClass.getShape().getObjectType().getClass();
        assert (RubyGuards.isRubyModule(rubyClass)) : classClass.getShape().getObjectType().getClass();
        model.rubyModuleObject = rubyClass;
        if (model.lexicalParent == null) {
            Layouts.MODULE.getFields(rubyClass).setFullName(Layouts.MODULE.getFields((DynamicObject)rubyClass).givenBaseName);
        } else {
            Layouts.MODULE.getFields(rubyClass).getAdoptedByLexicalParent(context, model.lexicalParent, model.givenBaseName, null);
        }
        if (superclass != null) {
            assert (RubyGuards.isRubyClass(superclass));
            assert (RubyGuards.isRubyClass(rubyClass));
            Layouts.MODULE.getFields((DynamicObject)rubyClass).parentModule = Layouts.MODULE.getFields((DynamicObject)superclass).start;
            Layouts.MODULE.getFields(superclass).addDependent(rubyClass);
            Layouts.MODULE.getFields(rubyClass).newVersion();
        }
        return rubyClass;
    }

    public static DynamicObject createSingletonClassOfObject(RubyContext context, DynamicObject superclass, DynamicObject attached, String name) {
        assert (RubyGuards.isRubyClass(superclass));
        assert (attached == null || RubyGuards.isRubyModule(attached));
        return ClassNodes.ensureSingletonConsistency(context, ClassNodes.createRubyClass(context, Layouts.BASIC_OBJECT.getLogicalClass(superclass), null, superclass, name, true, attached));
    }

    public static DynamicObject createRubyClass(RubyContext context, DynamicObject lexicalParent, DynamicObject superclass, String name) {
        DynamicObject rubyClass = ClassNodes.createRubyClass(context, Layouts.BASIC_OBJECT.getLogicalClass(superclass), lexicalParent, superclass, name, false, null);
        ClassNodes.ensureSingletonConsistency(context, rubyClass);
        return rubyClass;
    }

    public static DynamicObject createRubyClass(RubyContext context, DynamicObject classClass, DynamicObject lexicalParent, DynamicObject superclass, String name, boolean isSingleton, DynamicObject attached) {
        ModuleFields model = new ModuleFields(context, lexicalParent, name);
        DynamicObject rubyClass = Layouts.CLASS.createClass(Layouts.CLASS.getInstanceFactory(classClass), model, isSingleton, attached, null);
        assert (RubyGuards.isRubyClass(rubyClass)) : classClass.getShape().getObjectType().getClass();
        assert (RubyGuards.isRubyModule(rubyClass)) : classClass.getShape().getObjectType().getClass();
        model.rubyModuleObject = rubyClass;
        if (model.lexicalParent != null) {
            Layouts.MODULE.getFields(rubyClass).getAdoptedByLexicalParent(context, model.lexicalParent, model.givenBaseName, null);
        } else if (Layouts.MODULE.getFields((DynamicObject)rubyClass).givenBaseName != null) {
            Layouts.MODULE.getFields(rubyClass).setFullName(Layouts.MODULE.getFields((DynamicObject)rubyClass).givenBaseName);
        }
        if (superclass != null) {
            assert (RubyGuards.isRubyClass(superclass));
            Layouts.MODULE.getFields((DynamicObject)rubyClass).parentModule = Layouts.MODULE.getFields((DynamicObject)superclass).start;
            Layouts.MODULE.getFields(superclass).addDependent(rubyClass);
            Layouts.MODULE.getFields(rubyClass).newVersion();
        }
        DynamicObjectFactory factory = Layouts.CLASS.getInstanceFactory(superclass);
        factory = Layouts.BASIC_OBJECT.setLogicalClass(factory, rubyClass);
        factory = Layouts.BASIC_OBJECT.setMetaClass(factory, rubyClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(rubyClass, factory);
        return rubyClass;
    }

    public static void initialize(RubyContext context, DynamicObject rubyClass, DynamicObject superclass) {
        assert (RubyGuards.isRubyClass(superclass));
        Layouts.MODULE.getFields((DynamicObject)rubyClass).parentModule = Layouts.MODULE.getFields((DynamicObject)superclass).start;
        Layouts.MODULE.getFields(superclass).addDependent(rubyClass);
        Layouts.MODULE.getFields(rubyClass).newVersion();
        ClassNodes.ensureSingletonConsistency(context, rubyClass);
        DynamicObjectFactory factory = Layouts.CLASS.getInstanceFactory(superclass);
        factory = Layouts.BASIC_OBJECT.setLogicalClass(factory, rubyClass);
        factory = Layouts.BASIC_OBJECT.setMetaClass(factory, rubyClass);
        Layouts.CLASS.setInstanceFactoryUnsafe(rubyClass, factory);
    }

    public static DynamicObject ensureSingletonConsistency(RubyContext context, DynamicObject rubyClass) {
        ClassNodes.createOneSingletonClass(context, rubyClass);
        return rubyClass;
    }

    public static DynamicObject getSingletonClass(RubyContext context, DynamicObject rubyClass) {
        return ClassNodes.ensureSingletonConsistency(context, ClassNodes.createOneSingletonClass(context, rubyClass));
    }

    public static DynamicObject createOneSingletonClass(RubyContext context, DynamicObject rubyClass) {
        CompilerAsserts.neverPartOfCompilation();
        if (Layouts.CLASS.getIsSingleton(Layouts.BASIC_OBJECT.getMetaClass(rubyClass))) {
            return Layouts.BASIC_OBJECT.getMetaClass(rubyClass);
        }
        DynamicObject singletonSuperclass = ClassNodes.getSuperClass(rubyClass) == null ? Layouts.BASIC_OBJECT.getLogicalClass(rubyClass) : ClassNodes.createOneSingletonClass(context, ClassNodes.getSuperClass(rubyClass));
        String name = String.format("#<Class:%s>", Layouts.MODULE.getFields(rubyClass).getName());
        Layouts.BASIC_OBJECT.setMetaClass(rubyClass, ClassNodes.createRubyClass(context, Layouts.BASIC_OBJECT.getLogicalClass(rubyClass), null, singletonSuperclass, name, true, rubyClass));
        return Layouts.BASIC_OBJECT.getMetaClass(rubyClass);
    }

    public static DynamicObject getSuperClass(DynamicObject rubyClass) {
        CompilerAsserts.neverPartOfCompilation();
        for (DynamicObject ancestor : Layouts.MODULE.getFields(rubyClass).parentAncestors()) {
            if (!RubyGuards.isRubyClass(ancestor) || ancestor == rubyClass) continue;
            return ancestor;
        }
        return null;
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateConstructorNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateConstructorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return ClassNodes.createRubyClass(this.getContext(), this.getContext().getCoreLibrary().getClassClass(), null, this.getContext().getCoreLibrary().getObjectClass(), null, false, null);
        }
    }

    @CoreMethod(names={"superclass"})
    public static abstract class SuperClassNode
    extends CoreMethodArrayArgumentsNode {
        public SuperClassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object getSuperClass(DynamicObject rubyClass) {
            DynamicObject superclass = ClassNodes.getSuperClass(rubyClass);
            if (superclass == null) {
                return this.nil();
            }
            return superclass;
        }
    }

    @CoreMethod(names={"inherited"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class InheritedNode
    extends CoreMethodArrayArgumentsNode {
        public InheritedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject inherited(Object subclass) {
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize"}, optional=1, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ModuleNodes.InitializeNode moduleInitializeNode;
        @Node.Child
        private CallDispatchHeadNode inheritedNode;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        void triggerInheritedHook(VirtualFrame frame, DynamicObject subClass, DynamicObject superClass) {
            assert (RubyGuards.isRubyClass(subClass));
            assert (RubyGuards.isRubyClass(superClass));
            if (this.inheritedNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.inheritedNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            this.inheritedNode.call(frame, superClass, "inherited", null, subClass);
        }

        void moduleInitialize(VirtualFrame frame, DynamicObject rubyClass, DynamicObject block) {
            assert (RubyGuards.isRubyClass(rubyClass));
            assert (RubyGuards.isRubyProc(block));
            if (this.moduleInitializeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.moduleInitializeNode = (ModuleNodes.InitializeNode)this.insert(ModuleNodesFactory.InitializeNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            this.moduleInitializeNode.executeInitialize(frame, rubyClass, block);
        }

        @Specialization
        public DynamicObject initialize(VirtualFrame frame, DynamicObject rubyClass, NotProvided superclass, NotProvided block) {
            return this.initializeGeneralWithoutBlock(frame, rubyClass, this.getContext().getCoreLibrary().getObjectClass());
        }

        @Specialization(guards={"isRubyClass(superclass)"})
        public DynamicObject initialize(VirtualFrame frame, DynamicObject rubyClass, DynamicObject superclass, NotProvided block) {
            return this.initializeGeneralWithoutBlock(frame, rubyClass, superclass);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public DynamicObject initialize(VirtualFrame frame, DynamicObject rubyClass, NotProvided superclass, DynamicObject block) {
            return this.initializeGeneralWithBlock(frame, rubyClass, this.getContext().getCoreLibrary().getObjectClass(), block);
        }

        @Specialization(guards={"isRubyClass(superclass)", "isRubyProc(block)"})
        public DynamicObject initialize(VirtualFrame frame, DynamicObject rubyClass, DynamicObject superclass, DynamicObject block) {
            return this.initializeGeneralWithBlock(frame, rubyClass, superclass, block);
        }

        private DynamicObject initializeGeneralWithoutBlock(VirtualFrame frame, DynamicObject rubyClass, DynamicObject superclass) {
            assert (RubyGuards.isRubyClass(rubyClass));
            assert (RubyGuards.isRubyClass(superclass));
            ClassNodes.initialize(this.getContext(), rubyClass, superclass);
            this.triggerInheritedHook(frame, rubyClass, superclass);
            return rubyClass;
        }

        private DynamicObject initializeGeneralWithBlock(VirtualFrame frame, DynamicObject rubyClass, DynamicObject superclass, DynamicObject block) {
            assert (RubyGuards.isRubyClass(rubyClass));
            assert (RubyGuards.isRubyClass(superclass));
            assert (RubyGuards.isRubyProc(block));
            ClassNodes.initialize(this.getContext(), rubyClass, superclass);
            this.triggerInheritedHook(frame, rubyClass, superclass);
            this.moduleInitialize(frame, rubyClass, block);
            return rubyClass;
        }
    }

    @CoreMethod(names={"new"}, needsBlock=true, rest=true)
    public static abstract class NewNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode allocateNode;
        @Node.Child
        private CallDispatchHeadNode initialize;

        public NewNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
            this.initialize = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public Object newInstance(VirtualFrame frame, DynamicObject rubyClass, Object[] args, NotProvided block) {
            return this.doNewInstance(frame, rubyClass, args, null);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public Object newInstance(VirtualFrame frame, DynamicObject rubyClass, Object[] args, DynamicObject block) {
            return this.doNewInstance(frame, rubyClass, args, block);
        }

        private Object doNewInstance(VirtualFrame frame, DynamicObject rubyClass, Object[] args, DynamicObject block) {
            assert (block == null || RubyGuards.isRubyProc(block));
            Object instance = this.allocateNode.call(frame, rubyClass, "allocate", null, new Object[0]);
            this.initialize.call(frame, instance, "initialize", block, args);
            return instance;
        }
    }
}

