/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.core.BinaryCoreMethodNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.dispatch.RubyCallNode;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.nodes.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.methods.InternalMethod;

@CoreClass(name="BasicObject")
public abstract class BasicObjectNodes {

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateObjectNode.allocate(rubyClass, new Object[0]);
        }
    }

    @CoreMethod(names={"__send__"}, needsBlock=true, rest=true, required=1)
    public static abstract class SendNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode dispatchNode;

        public SendNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatchNode = new CallDispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING);
        }

        @Specialization
        public Object send(VirtualFrame frame, Object self, Object name, Object[] args, NotProvided block) {
            return this.send(frame, self, name, args, (DynamicObject)null);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public Object send(VirtualFrame frame, Object self, Object name, Object[] args, DynamicObject block) {
            return this.dispatchNode.call(frame, self, name, block, args);
        }
    }

    @CoreMethod(names={"method_missing"}, needsBlock=true, rest=true, optional=1, visibility=Visibility.PRIVATE)
    public static abstract class MethodMissingNode
    extends CoreMethodArrayArgumentsNode {
        public MethodMissingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object methodMissingNoName(Object self, NotProvided name, Object[] args, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("no id given", this));
        }

        @Specialization
        public Object methodMissingNoBlock(Object self, DynamicObject name, Object[] args, NotProvided block) {
            return this.methodMissing(self, name, args, null);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public Object methodMissingBlock(Object self, DynamicObject name, Object[] args, DynamicObject block) {
            return this.methodMissing(self, name, args, block);
        }

        @CompilerDirectives.TruffleBoundary
        private Object methodMissing(Object self, DynamicObject nameObject, Object[] args, DynamicObject block) {
            String name = nameObject.toString();
            if (this.lastCallWasCallingPrivateMethod(self, name)) {
                throw new RaiseException(this.getContext().getCoreLibrary().privateMethodError(name, self, this));
            }
            if (this.lastCallWasVCall()) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedLocalVariableOrMethod(name, self, this));
            }
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodErrorOnReceiver(name, self, this));
        }

        private boolean lastCallWasCallingPrivateMethod(Object self, String name) {
            InternalMethod method = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(self), name);
            return method != null && !method.isUndefined();
        }

        private boolean lastCallWasVCall() {
            RubyCallNode callNode = (RubyCallNode)((Object)NodeUtil.findParent((Node)Truffle.getRuntime().getCallerFrame().getCallNode(), RubyCallNode.class));
            return callNode != null && callNode.isVCall();
        }
    }

    @CoreMethod(names={"instance_exec"}, needsBlock=true, rest=true)
    public static abstract class InstanceExecNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldDispatchHeadNode yield;

        public InstanceExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldDispatchHeadNode(context, DeclarationContext.INSTANCE_EVAL);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public Object instanceExec(VirtualFrame frame, Object receiver, Object[] arguments, DynamicObject block) {
            CompilerDirectives.transferToInterpreter();
            return this.yield.dispatchWithModifiedSelf(frame, block, receiver, arguments);
        }

        @Specialization
        public Object instanceExec(Object receiver, Object[] arguments, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().localJumpError("no block given", this));
        }
    }

    @CoreMethod(names={"instance_eval"}, needsBlock=true, optional=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class InstanceEvalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldDispatchHeadNode yield;

        public InstanceEvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldDispatchHeadNode(context, DeclarationContext.INSTANCE_EVAL);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(string)"})
        public Object instanceEval(Object receiver, DynamicObject string, NotProvided block) {
            return this.getContext().instanceEval(StringOperations.getByteList(string), receiver, "(eval)", this);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public Object instanceEval(VirtualFrame frame, Object receiver, NotProvided string, DynamicObject block) {
            return this.yield.dispatchWithModifiedSelf(frame, block, receiver, receiver);
        }
    }

    @CoreMethod(names={"initialize"}, needsSelf=false)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject initialize() {
            return this.nil();
        }
    }

    @CoreMethod(names={"equal?", "=="}, required=1)
    public static abstract class ReferenceEqualNode
    extends BinaryCoreMethodNode {
        public ReferenceEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract boolean executeReferenceEqual(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public boolean equal(boolean a, boolean b) {
            return a == b;
        }

        @Specialization
        public boolean equal(int a, int b) {
            return a == b;
        }

        @Specialization
        public boolean equal(long a, long b) {
            return a == b;
        }

        @Specialization
        public boolean equal(double a, double b) {
            return Double.doubleToRawLongBits(a) == Double.doubleToRawLongBits(b);
        }

        @Specialization
        public boolean equal(DynamicObject a, DynamicObject b) {
            return a == b;
        }

        @Specialization(guards={"isNotDynamicObject(a)", "isNotDynamicObject(b)", "notSameClass(a, b)"})
        public boolean equal(Object a, Object b) {
            return false;
        }

        @Specialization(guards={"isNotDynamicObject(a)"})
        public boolean equal(Object a, DynamicObject b) {
            return false;
        }

        @Specialization(guards={"isNotDynamicObject(b)"})
        public boolean equal(DynamicObject a, Object b) {
            return false;
        }

        protected boolean isNotDynamicObject(Object value) {
            return !(value instanceof DynamicObject);
        }

        protected boolean notSameClass(Object a, Object b) {
            return a.getClass() != b.getClass();
        }
    }

    @CoreMethod(names={"!="}, required=1)
    public static abstract class NotEqualNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode equalNode;

        public NotEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public boolean equal(VirtualFrame frame, Object a, Object b) {
            return !this.equalNode.callBoolean(frame, a, "==", null, b);
        }
    }

    @CoreMethod(names={"!"})
    public static abstract class NotNode
    extends UnaryCoreMethodNode {
        public NotNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"operand"})
        public RubyNode createCast(RubyNode operand) {
            return BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), operand);
        }

        @Specialization
        public boolean not(boolean value) {
            return !value;
        }
    }
}

