/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public class TraceNode
extends RubyNode {
    private final RubyContext context;
    @CompilerDirectives.CompilationFinal
    private Assumption traceAssumption;
    @CompilerDirectives.CompilationFinal
    private DynamicObject traceFunc;
    @Node.Child
    private DirectCallNode callNode;
    private final DynamicObject event;
    private final DynamicObject file;
    private final int line;

    public TraceNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.context = context;
        this.traceAssumption = context.getTraceManager().getTraceAssumption();
        this.traceFunc = null;
        this.callNode = null;
        this.event = this.create7BitString(StringOperations.encodeByteList("line", (Encoding)UTF8Encoding.INSTANCE));
        this.file = this.createString(StringOperations.encodeByteList(sourceSection.getSource().getName(), (Encoding)UTF8Encoding.INSTANCE));
        this.line = sourceSection.getStartLine();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.trace(frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(VirtualFrame frame) {
        try {
            this.traceAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            this.traceAssumption = this.context.getTraceManager().getTraceAssumption();
            this.traceFunc = this.context.getTraceManager().getTraceFunc();
            this.callNode = this.traceFunc != null ? (DirectCallNode)this.insert((Node)Truffle.getRuntime().createDirectCallNode(Layouts.PROC.getCallTargetForType(this.traceFunc))) : null;
        }
        if (this.traceFunc != null && !this.context.getTraceManager().isInTraceFunc()) {
            this.context.getTraceManager().setInTraceFunc(true);
            Object[] args = new Object[]{this.event, this.file, this.line, this.context.getCoreLibrary().getNilObject(), BindingNodes.createBinding(this.getContext(), frame.materialize()), this.context.getCoreLibrary().getNilObject()};
            try {
                this.callNode.call(frame, ProcNodes.packArguments(this.traceFunc, args));
            }
            finally {
                this.context.getTraceManager().setInTraceFunc(false);
            }
        }
    }
}

