/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.fixnum;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.fixnum.FixnumLowerNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=FixnumLowerNode.class)
public final class FixnumLowerNodeGen
extends FixnumLowerNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @CompilerDirectives.CompilationFinal
    private Class<?> valueType_;
    @Node.Child
    private BaseNode_ specialization_;

    private FixnumLowerNodeGen(RubyContext context, SourceSection sourceSection, RubyNode value) {
        super(context, sourceSection);
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeInt(frameValue);
    }

    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeLong(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    private static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static FixnumLowerNode create(RubyContext context, SourceSection sourceSection, RubyNode value) {
        return new FixnumLowerNodeGen(context, sourceSection, value);
    }

    @GeneratedBy(methodName="passThrough(Object)", value=FixnumLowerNode.class)
    private static final class PassThroughNode_
    extends BaseNode_ {
        PassThroughNode_(FixnumLowerNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            if (!RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                return this.root.passThrough(valueValue);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(FixnumLowerNodeGen root) {
            return new PassThroughNode_(root);
        }
    }

    @GeneratedBy(methodName="lowerFails(long)", value=FixnumLowerNode.class)
    private static final class LowerFailsNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        LowerFailsNode_(FixnumLowerNodeGen root, Object valueValue) {
            super(root, 3);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((LowerFailsNode_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            try {
                valueValue_ = this.executeValueLong_((Frame)frameValue, this.valueImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return FixnumLowerNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
            }
            if (!FixnumLowerNode.canLower(valueValue_)) {
                return this.root.lowerFails(valueValue_);
            }
            return FixnumLowerNodeGen.expectLong(this.getNext().execute_(frameValue, valueValue_));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            long valueValue_;
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType) && !FixnumLowerNode.canLower(valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType))) {
                return this.root.lowerFails(valueValue_);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(FixnumLowerNodeGen root, Object valueValue) {
            return new LowerFailsNode_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="lower(long)", value=FixnumLowerNode.class)
    private static final class Lower1Node_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        Lower1Node_(FixnumLowerNodeGen root, Object valueValue) {
            super(root, 2);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((Lower1Node_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue_;
            try {
                valueValue_ = this.executeValueLong_((Frame)frameValue, this.valueImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return FixnumLowerNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
            }
            if (FixnumLowerNode.canLower(valueValue_)) {
                return this.root.lower(valueValue_);
            }
            return FixnumLowerNodeGen.expectInteger(this.getNext().execute_(frameValue, valueValue_));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            long valueValue_;
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType) && FixnumLowerNode.canLower(valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType))) {
                return this.root.lower(valueValue_);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(FixnumLowerNodeGen root, Object valueValue) {
            return new Lower1Node_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="lower(int)", value=FixnumLowerNode.class)
    private static final class Lower0Node_
    extends BaseNode_ {
        Lower0Node_(FixnumLowerNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue_;
            try {
                valueValue_ = this.root.value_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return FixnumLowerNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
            }
            return this.root.lower(valueValue_);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            if (valueValue instanceof Integer) {
                int valueValue_ = (Integer)valueValue;
                return this.root.lower(valueValue_);
            }
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(FixnumLowerNodeGen root) {
            return new Lower0Node_(root);
        }
    }

    @GeneratedBy(value=FixnumLowerNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(FixnumLowerNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            return this.getNext().execute_(frameValue, valueValue);
        }

        static BaseNode_ create(FixnumLowerNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=FixnumLowerNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(FixnumLowerNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object valueValue) {
            return this.uninitialized((Frame)frameValue, valueValue);
        }

        static BaseNode_ create(FixnumLowerNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=FixnumLowerNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final FixnumLowerNodeGen root;

        BaseNode_(FixnumLowerNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.execute_((VirtualFrame)frameValue, valueValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            return this.execute_(frameValue, valueValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            return FixnumLowerNodeGen.expectInteger(this.execute(frameValue));
        }

        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            return FixnumLowerNodeGen.expectLong(this.execute(frameValue));
        }

        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            if (valueValue instanceof Integer) {
                return Lower0Node_.create(this.root);
            }
            if (RubyTypesGen.isImplicitLong(valueValue)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue);
                if (FixnumLowerNode.canLower(valueValue_)) {
                    return Lower1Node_.create(this.root, valueValue);
                }
                return LowerFailsNode_.create(this.root, valueValue);
            }
            if (!RubyGuards.isInteger(valueValue) && !RubyGuards.isLong(valueValue)) {
                return PassThroughNode_.create(this.root);
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        protected final long executeValueLong_(Frame frameValue, Class<?> valueImplicitType) throws UnexpectedResultException {
            if (valueImplicitType == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueImplicitType == Integer.TYPE) {
                return RubyTypes.int2long(this.root.value_.executeInteger((VirtualFrame)frameValue));
            }
            Object valueValue_ = this.executeValue_(frameValue);
            throw new UnexpectedResultException(valueValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeValue_(Frame frameValue) {
            Object object;
            Class valueType_ = this.root.valueType_;
            if (valueType_ == Integer.TYPE) {
                return this.root.value_.executeInteger((VirtualFrame)frameValue);
            }
            if (valueType_ == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.valueType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.valueType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.valueType_ = _type;
            return object;
        }
    }
}

