/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.RubyThread;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.FiberNodes;
import org.jruby.truffle.nodes.core.ThreadNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.subsystems.SafepointAction;

public class ThreadManager {
    private final RubyContext context;
    private final DynamicObject rootThread;
    private final ThreadLocal<DynamicObject> currentThread = new ThreadLocal();
    private final Set<DynamicObject> runningRubyThreads = Collections.newSetFromMap(new ConcurrentHashMap());

    public ThreadManager(RubyContext context) {
        this.context = context;
        this.rootThread = ThreadNodes.createRubyThread(context.getCoreLibrary().getThreadClass());
        Layouts.THREAD.setName(this.rootThread, "main");
    }

    public void initialize() {
        ThreadNodes.start(this.rootThread);
        FiberNodes.start(Layouts.THREAD.getFiberManager(this.rootThread).getRootFiber());
    }

    public DynamicObject getRootThread() {
        return this.rootThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public <T> T runUntilResult(Node currentNode, BlockingAction<T> action) {
        T result = null;
        do {
            DynamicObject runningThread = this.getCurrentThread();
            Layouts.THREAD.setStatus(runningThread, RubyThread.Status.SLEEP);
            try {
                try {
                    result = action.block();
                }
                finally {
                    Layouts.THREAD.setStatus(runningThread, RubyThread.Status.RUN);
                }
            }
            catch (InterruptedException e) {
                this.context.getSafepointManager().pollFromBlockingCall(currentNode);
            }
        } while (result == null);
        return result;
    }

    public void initializeCurrentThread(DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        this.currentThread.set(thread);
    }

    @CompilerDirectives.TruffleBoundary
    public DynamicObject getCurrentThread() {
        return this.currentThread.get();
    }

    public synchronized void registerThread(DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        this.initializeCurrentThread(thread);
        this.runningRubyThreads.add(thread);
    }

    public synchronized void unregisterThread(DynamicObject thread) {
        assert (RubyGuards.isRubyThread(thread));
        this.runningRubyThreads.remove(thread);
        this.currentThread.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            if (this.runningRubyThreads.size() > 1) {
                this.killOtherThreads();
            }
        }
        finally {
            Layouts.THREAD.getFiberManager(this.rootThread).shutdown();
            FiberNodes.cleanup(Layouts.THREAD.getFiberManager(this.rootThread).getRootFiber());
            ThreadNodes.cleanup(this.rootThread);
        }
    }

    public DynamicObject[] getThreads() {
        return this.runningRubyThreads.toArray(new DynamicObject[this.runningRubyThreads.size()]);
    }

    private void killOtherThreads() {
        while (true) {
            try {
                this.context.getSafepointManager().pauseAllThreadsAndExecute(null, false, new SafepointAction(){

                    @Override
                    public synchronized void run(DynamicObject thread, Node currentNode) {
                        if (thread != ThreadManager.this.rootThread && Thread.currentThread() == Layouts.THREAD.getThread(thread)) {
                            ThreadNodes.shutdown(thread);
                        }
                    }
                });
            }
            catch (RaiseException e) {
                Object rubyException = e.getRubyException();
                BacktraceFormatter.createDefaultFormatter(this.context).printBacktrace((DynamicObject)rubyException, Layouts.EXCEPTION.getBacktrace((DynamicObject)rubyException));
                continue;
            }
            break;
        }
    }

    public static interface BlockingAction<T> {
        public static final boolean SUCCESS = true;

        public T block() throws InterruptedException;
    }
}

