/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.rubinius;

import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigInteger;
import java.util.Arrays;
import jnr.constants.platform.Fcntl;
import jnr.constants.platform.OpenFlags;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyString;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.rubinius.RubiniusConfiguration;

public abstract class DefaultRubiniusConfiguration {
    public static final int SIZE_OF_INT = 4;
    public static final int SIZE_OF_LONG = 8;
    public static final int SIZE_OF_POINTER = 8;

    public static void load(RubiniusConfiguration configuration, RubyContext context) {
        configuration.config("hash.hamt", false);
        configuration.config("rbx.platform.file.S_IRUSR", 256);
        configuration.config("rbx.platform.file.S_IWUSR", 128);
        configuration.config("rbx.platform.file.S_IXUSR", 64);
        configuration.config("rbx.platform.file.S_IRGRP", 32);
        configuration.config("rbx.platform.file.S_IWGRP", 16);
        configuration.config("rbx.platform.file.S_IXGRP", 8);
        configuration.config("rbx.platform.file.S_IROTH", 4);
        configuration.config("rbx.platform.file.S_IWOTH", 2);
        configuration.config("rbx.platform.file.S_IXOTH", 1);
        configuration.config("rbx.platform.file.S_IFMT", 61440);
        configuration.config("rbx.platform.file.S_IFIFO", 4096);
        configuration.config("rbx.platform.file.S_IFCHR", 8192);
        configuration.config("rbx.platform.file.S_IFDIR", 16384);
        configuration.config("rbx.platform.file.S_IFBLK", 24576);
        configuration.config("rbx.platform.file.S_IFREG", 32768);
        configuration.config("rbx.platform.file.S_IFLNK", 40960);
        configuration.config("rbx.platform.file.S_IFSOCK", 49152);
        configuration.config("rbx.platform.file.S_ISUID", 2048);
        configuration.config("rbx.platform.file.S_ISGID", 1024);
        configuration.config("rbx.platform.file.S_ISVTX", 512);
        for (Fcntl fcntl : Fcntl.values()) {
            if (!fcntl.defined() || !fcntl.name().startsWith("F_")) continue;
            configuration.config("rbx.platform.fcntl." + fcntl.name(), fcntl.intValue());
        }
        configuration.config("rbx.platform.fcntl.FD_CLOEXEC", 1);
        for (Fcntl fcntl : OpenFlags.values()) {
            if (!fcntl.defined() || !fcntl.name().startsWith("O_")) continue;
            configuration.config("rbx.platform.file." + fcntl.name(), fcntl.intValue());
        }
        configuration.config("rbx.platform.fcntl.O_ACCMODE", OpenFlags.O_RDONLY.intValue() | OpenFlags.O_WRONLY.intValue() | OpenFlags.O_RDWR.intValue());
        configuration.config("rbx.platform.typedef.time_t", context.getSymbolTable().getSymbol("long"));
        configuration.config("rbx.platform.timeval.sizeof", 16);
        configuration.config("rbx.platform.timeval.tv_sec.offset", 0);
        configuration.config("rbx.platform.timeval.tv_sec.size", 8);
        configuration.config("rbx.platform.timeval.tv_sec.type", context.getSymbolTable().getSymbol("time_t"));
        configuration.config("rbx.platform.timeval.tv_usec.offset", 8);
        configuration.config("rbx.platform.timeval.tv_usec.size", 8);
        configuration.config("rbx.platform.timeval.tv_usec.type", context.getSymbolTable().getSymbol("time_t"));
        int lingerOffset = 0;
        for (String field : Arrays.asList("l_onoff", "l_linger")) {
            configuration.config("rbx.platform.linger." + field + ".offset", lingerOffset);
            configuration.config("rbx.platform.linger." + field + ".size", 4);
            configuration.config("rbx.platform.linger." + field + ".type", context.getSymbolTable().getSymbol("int"));
            lingerOffset += 4;
        }
        configuration.config("rbx.platform.linger.sizeof", lingerOffset);
        configuration.config("rbx.platform.servent.sizeof", 28);
        configuration.config("rbx.platform.servent.s_name.offset", 0);
        configuration.config("rbx.platform.servent.s_name.size", 8);
        configuration.config("rbx.platform.servent.s_name.type", context.getSymbolTable().getSymbol("pointer"));
        configuration.config("rbx.platform.servent.s_aliases.offset", 8);
        configuration.config("rbx.platform.servent.s_aliases.size", 8);
        configuration.config("rbx.platform.servent.s_aliases.type", context.getSymbolTable().getSymbol("pointer"));
        configuration.config("rbx.platform.servent.s_port.offset", 16);
        configuration.config("rbx.platform.servent.s_port.size", 4);
        configuration.config("rbx.platform.servent.s_port.type", context.getSymbolTable().getSymbol("int"));
        configuration.config("rbx.platform.servent.s_proto.offset", 20);
        configuration.config("rbx.platform.servent.s_proto.size", 8);
        configuration.config("rbx.platform.servent.s_proto.type", context.getSymbolTable().getSymbol("pointer"));
        configuration.config("rbx.platform.io.SEEK_SET", 0);
        configuration.config("rbx.platform.io.SEEK_CUR", 1);
        configuration.config("rbx.platform.io.SEEK_END", 2);
        configuration.config("rbx.platform.socket.AI_PASSIVE", Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(context.getCoreLibrary().getStringClass()), RubyString.encodeBytelist((CharSequence)"1", (Encoding)UTF8Encoding.INSTANCE), 16, null));
        configuration.config("rbx.platform.socket.AF_UNSPEC", Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(context.getCoreLibrary().getStringClass()), RubyString.encodeBytelist((CharSequence)"0", (Encoding)UTF8Encoding.INSTANCE), 16, null));
        configuration.config("rbx.platform.socket.SOCK_STREAM", Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(context.getCoreLibrary().getStringClass()), RubyString.encodeBytelist((CharSequence)"1", (Encoding)UTF8Encoding.INSTANCE), 16, null));
        configuration.config("rbx.platform.socket.SOCK_STREAM", Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(context.getCoreLibrary().getStringClass()), RubyString.encodeBytelist((CharSequence)"1", (Encoding)UTF8Encoding.INSTANCE), 16, null));
    }

    protected static DynamicObject newBignum(RubyContext context, String value) {
        return Layouts.BIGNUM.createBignum(context.getCoreLibrary().getBignumFactory(), new BigInteger(value));
    }

    protected static DynamicObject string(RubyContext context, String value) {
        return Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(context.getCoreLibrary().getStringClass()), RubyString.encodeBytelist((CharSequence)value, (Encoding)UTF8Encoding.INSTANCE), 0, null);
    }
}

