/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.RubyThread;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.subsystems.SafepointAction;

public class ThreadPrimitiveNodes {

    @RubiniusPrimitive(name="thread_set_priority")
    public static abstract class ThreadSetPriorityPrimitiveNode
    extends RubiniusPrimitiveNode {
        public ThreadSetPriorityPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyThread(thread)"})
        public int getPriority(DynamicObject thread, int rubyPriority) {
            if (rubyPriority < -3) {
                rubyPriority = -3;
            } else if (rubyPriority > 3) {
                rubyPriority = 3;
            }
            int javaPriority = RubyThread.rubyPriorityToJavaPriority((int)rubyPriority);
            Thread javaThread = Layouts.THREAD.getThread(thread);
            if (javaThread != null) {
                javaThread.setPriority(javaPriority);
            }
            Layouts.THREAD.setPriority(thread, rubyPriority);
            return rubyPriority;
        }
    }

    @RubiniusPrimitive(name="thread_get_priority")
    public static abstract class ThreadGetPriorityPrimitiveNode
    extends RubiniusPrimitiveNode {
        public ThreadGetPriorityPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyThread(thread)"})
        public int getPriority(DynamicObject thread) {
            Thread javaThread = Layouts.THREAD.getThread(thread);
            if (javaThread != null) {
                int javaPriority = javaThread.getPriority();
                return RubyThread.javaPriorityToRubyPriority((int)javaPriority);
            }
            return Layouts.THREAD.getPriority(thread);
        }
    }

    @RubiniusPrimitive(name="thread_raise")
    public static abstract class ThreadRaisePrimitiveNode
    extends RubiniusPrimitiveNode {
        public ThreadRaisePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyThread(thread)", "isRubyException(exception)"})
        public DynamicObject raise(DynamicObject thread, final DynamicObject exception) {
            Thread javaThread = Layouts.FIBER.getThread(Layouts.THREAD.getFiberManager(thread).getCurrentFiber());
            this.getContext().getSafepointManager().pauseThreadAndExecuteLater(javaThread, this, new SafepointAction(){

                @Override
                public void run(DynamicObject currentThread, Node currentNode) {
                    if (Layouts.EXCEPTION.getBacktrace(exception) == null) {
                        Backtrace backtrace = RubyCallStack.getBacktrace(currentNode);
                        Layouts.EXCEPTION.setBacktrace(exception, backtrace);
                    }
                    throw new RaiseException(exception);
                }
            });
            return this.nil();
        }
    }
}

