/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import jnr.constants.platform.Errno;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;

public abstract class ExceptionPrimitiveNodes {

    @RubiniusPrimitive(name="exception_errno_error", needsSelf=false)
    public static abstract class ExceptionErrnoErrorPrimitiveNode
    extends RubiniusPrimitiveNode {
        protected static final int EPERM = Errno.EPERM.intValue();
        protected static final int ENOENT = Errno.ENOENT.intValue();
        protected static final int EBADF = Errno.EBADF.intValue();
        protected static final int EEXIST = Errno.EEXIST.intValue();
        protected static final int EACCES = Errno.EACCES.intValue();
        protected static final int EFAULT = Errno.EFAULT.intValue();
        protected static final int ENOTDIR = Errno.ENOTDIR.intValue();
        protected static final int EINVAL = Errno.EINVAL.intValue();
        protected static final int EINPROGRESS = Errno.EINPROGRESS.intValue();
        protected static final int ENOTCONN = Errno.ENOTCONN.intValue();

        public static boolean isExceptionSupported(int errno) {
            return errno == EPERM || errno == ENOENT || errno == EBADF || errno == EEXIST || errno == EACCES || errno == EFAULT || errno == ENOTDIR || errno == EINVAL || errno == EINPROGRESS || errno == ENOTCONN;
        }

        public ExceptionErrnoErrorPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(message)", "errno == EPERM"})
        public DynamicObject eperm(DynamicObject message, int errno) {
            return this.getContext().getCoreLibrary().operationNotPermittedError(message.toString(), this);
        }

        @Specialization(guards={"errno == EPERM", "isNil(message)"})
        public DynamicObject eperm(Object message, int errno) {
            return this.getContext().getCoreLibrary().operationNotPermittedError("nil", this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == ENOENT"})
        public DynamicObject enoent(DynamicObject message, int errno) {
            return this.getContext().getCoreLibrary().fileNotFoundError(message.toString(), this);
        }

        @Specialization(guards={"errno == ENOENT", "isNil(message)"})
        public DynamicObject enoent(Object message, int errno) {
            return this.getContext().getCoreLibrary().fileNotFoundError("nil", this);
        }

        @Specialization(guards={"errno == EBADF", "isNil(message)"})
        public DynamicObject ebadf(Object message, int errno) {
            return this.getContext().getCoreLibrary().badFileDescriptor(this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == EEXIST"})
        public DynamicObject eexist(DynamicObject message, int errno) {
            return this.getContext().getCoreLibrary().fileExistsError(message.toString(), this);
        }

        @Specialization(guards={"errno == EEXIST", "isNil(message)"})
        public DynamicObject eexist(Object message, int errno) {
            return this.getContext().getCoreLibrary().fileExistsError("nil", this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == EACCES"})
        public DynamicObject eacces(DynamicObject message, int errno) {
            return this.getContext().getCoreLibrary().permissionDeniedError(message.toString(), this);
        }

        @Specialization(guards={"errno == EACCES", "isNil(message)"})
        public DynamicObject eacces(Object message, int errno) {
            return this.getContext().getCoreLibrary().permissionDeniedError("nil", this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == EFAULT"})
        public DynamicObject efault(DynamicObject message, int errno) {
            return this.getContext().getCoreLibrary().badAddressError(this);
        }

        @Specialization(guards={"errno == EFAULT", "isNil(message)"})
        public DynamicObject efault(Object message, int errno) {
            return this.getContext().getCoreLibrary().badAddressError(this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == ENOTDIR"})
        public DynamicObject enotdir(DynamicObject message, int errno) {
            return this.getContext().getCoreLibrary().notDirectoryError(message.toString(), this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == EINVAL"})
        public DynamicObject einval(DynamicObject message, int errno) {
            return this.getContext().getCoreLibrary().errnoError(errno, this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == EINPROGRESS"})
        public DynamicObject einprogress(DynamicObject message, int errno) {
            return this.getContext().getCoreLibrary().errnoError(errno, this);
        }

        @Specialization(guards={"isRubyString(message)", "errno == ENOTCONN"})
        public DynamicObject enotconn(DynamicObject message, int errno) {
            return this.getContext().getCoreLibrary().errnoError(errno, this);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isExceptionSupported(errno)"})
        public DynamicObject unsupported(Object message, int errno) {
            Errno errnoObject = Errno.valueOf((long)errno);
            String messageString = RubyGuards.isRubyString(message) ? message.toString() : (message == this.nil() ? "nil" : "unsupported message type");
            if (errnoObject == null) {
                throw new UnsupportedOperationException("errno: " + errno + " " + messageString);
            }
            throw new UnsupportedOperationException("errno: " + errnoObject.name());
        }
    }
}

