/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objectstorage;

import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.objectstorage.ReadObjectFieldChainNode;
import org.jruby.truffle.nodes.objectstorage.ReadObjectFieldNode;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeInfo(cost=NodeCost.POLYMORPHIC)
public class ReadMissingObjectFieldNode
extends ReadObjectFieldChainNode {
    public ReadMissingObjectFieldNode(Shape objectLayout, ReadObjectFieldNode next) {
        super(objectLayout, next);
    }

    @Override
    public Object execute(DynamicObject object) {
        try {
            this.objectLayout.getValidAssumption().check();
        }
        catch (InvalidAssumptionException e) {
            this.replace(this.next);
            return this.next.execute(object);
        }
        if (object.getShape() == this.objectLayout) {
            return Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(object)).getContext().getCoreLibrary().getNilObject();
        }
        return this.next.execute(object);
    }

    @Override
    public boolean isSet(DynamicObject object) {
        boolean condition;
        try {
            this.objectLayout.getValidAssumption().check();
        }
        catch (InvalidAssumptionException e) {
            this.replace(this.next);
            return this.next.isSet(object);
        }
        boolean bl = condition = object.getShape() == this.objectLayout;
        if (condition) {
            return false;
        }
        return this.next.isSet(object);
    }
}

