/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.literal.RangeLiteralNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=RangeLiteralNode.class)
public final class RangeLiteralNodeGen
extends RangeLiteralNode
implements SpecializedNode {
    @Node.Child
    private RubyNode begin_;
    @Node.Child
    private RubyNode end_;
    @CompilerDirectives.CompilationFinal
    private Class<?> beginType_;
    @CompilerDirectives.CompilationFinal
    private Class<?> endType_;
    @Node.Child
    private BaseNode_ specialization_;

    private RangeLiteralNodeGen(RubyContext context, SourceSection sourceSection, boolean excludeEnd, RubyNode begin, RubyNode end) {
        super(context, sourceSection, excludeEnd);
        this.begin_ = begin;
        this.end_ = end;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeDynamicObject(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    private static DynamicObject expectDynamicObject(Object value) throws UnexpectedResultException {
        if (value instanceof DynamicObject) {
            return (DynamicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static RangeLiteralNode create(RubyContext context, SourceSection sourceSection, boolean excludeEnd, RubyNode begin, RubyNode end) {
        return new RangeLiteralNodeGen(context, sourceSection, excludeEnd, begin, end);
    }

    @GeneratedBy(methodName="doRange(VirtualFrame, Object, Object)", value=RangeLiteralNode.class)
    private static final class RangeNode_
    extends BaseNode_ {
        RangeNode_(RangeLiteralNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            if (!this.root.isIntOrLong(beginValue) || !this.root.isIntOrLong(endValue)) {
                return this.root.doRange(frameValue, beginValue, endValue);
            }
            return this.getNext().execute_(frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root) {
            return new RangeNode_(root);
        }
    }

    @GeneratedBy(methodName="longRange(long, long)", value=RangeLiteralNode.class)
    private static final class LongRangeNode_
    extends BaseNode_ {
        private final Class<?> beginImplicitType;
        private final Class<?> endImplicitType;

        LongRangeNode_(RangeLiteralNodeGen root, Object beginValue, Object endValue) {
            super(root, 3);
            this.beginImplicitType = RubyTypesGen.getImplicitLongClass(beginValue);
            this.endImplicitType = RubyTypesGen.getImplicitLongClass(endValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.beginImplicitType == ((LongRangeNode_)other).beginImplicitType && this.endImplicitType == ((LongRangeNode_)other).endImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            long endValue_;
            long beginValue_;
            try {
                beginValue_ = this.executeBeginLong_((Frame)frameValue, this.beginImplicitType);
            }
            catch (UnexpectedResultException ex) {
                Object endValue = this.executeEnd_((Frame)frameValue);
                return RangeLiteralNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), endValue));
            }
            try {
                endValue_ = this.executeEndLong_((Frame)frameValue, this.endImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return RangeLiteralNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, beginValue_, ex.getResult()));
            }
            if (!this.root.fitsIntoInteger(beginValue_) || !this.root.fitsIntoInteger(endValue_)) {
                return this.root.longRange(beginValue_, endValue_);
            }
            return RangeLiteralNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, beginValue_, endValue_));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            if (RubyTypesGen.isImplicitLong(beginValue, this.beginImplicitType) && RubyTypesGen.isImplicitLong(endValue, this.endImplicitType)) {
                long beginValue_ = RubyTypesGen.asImplicitLong(beginValue, this.beginImplicitType);
                long endValue_ = RubyTypesGen.asImplicitLong(endValue, this.endImplicitType);
                if (!this.root.fitsIntoInteger(beginValue_) || !this.root.fitsIntoInteger(endValue_)) {
                    return this.root.longRange(beginValue_, endValue_);
                }
            }
            return this.getNext().execute_(frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root, Object beginValue, Object endValue) {
            return new LongRangeNode_(root, beginValue, endValue);
        }
    }

    @GeneratedBy(methodName="longFittingIntRange(long, long)", value=RangeLiteralNode.class)
    private static final class LongFittingIntRangeNode_
    extends BaseNode_ {
        private final Class<?> beginImplicitType;
        private final Class<?> endImplicitType;

        LongFittingIntRangeNode_(RangeLiteralNodeGen root, Object beginValue, Object endValue) {
            super(root, 2);
            this.beginImplicitType = RubyTypesGen.getImplicitLongClass(beginValue);
            this.endImplicitType = RubyTypesGen.getImplicitLongClass(endValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.beginImplicitType == ((LongFittingIntRangeNode_)other).beginImplicitType && this.endImplicitType == ((LongFittingIntRangeNode_)other).endImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            long endValue_;
            long beginValue_;
            try {
                beginValue_ = this.executeBeginLong_((Frame)frameValue, this.beginImplicitType);
            }
            catch (UnexpectedResultException ex) {
                Object endValue = this.executeEnd_((Frame)frameValue);
                return RangeLiteralNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), endValue));
            }
            try {
                endValue_ = this.executeEndLong_((Frame)frameValue, this.endImplicitType);
            }
            catch (UnexpectedResultException ex) {
                return RangeLiteralNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, beginValue_, ex.getResult()));
            }
            if (this.root.fitsIntoInteger(beginValue_) && this.root.fitsIntoInteger(endValue_)) {
                return this.root.longFittingIntRange(beginValue_, endValue_);
            }
            return RangeLiteralNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, beginValue_, endValue_));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            if (RubyTypesGen.isImplicitLong(beginValue, this.beginImplicitType) && RubyTypesGen.isImplicitLong(endValue, this.endImplicitType)) {
                long beginValue_ = RubyTypesGen.asImplicitLong(beginValue, this.beginImplicitType);
                long endValue_ = RubyTypesGen.asImplicitLong(endValue, this.endImplicitType);
                if (this.root.fitsIntoInteger(beginValue_) && this.root.fitsIntoInteger(endValue_)) {
                    return this.root.longFittingIntRange(beginValue_, endValue_);
                }
            }
            return this.getNext().execute_(frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root, Object beginValue, Object endValue) {
            return new LongFittingIntRangeNode_(root, beginValue, endValue);
        }
    }

    @GeneratedBy(methodName="intRange(int, int)", value=RangeLiteralNode.class)
    private static final class IntRangeNode_
    extends BaseNode_ {
        IntRangeNode_(RangeLiteralNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            try {
                return this.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            int endValue_;
            int beginValue_;
            try {
                beginValue_ = this.root.begin_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object endValue = this.executeEnd_((Frame)frameValue);
                return RangeLiteralNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, ex.getResult(), endValue));
            }
            try {
                endValue_ = this.root.end_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RangeLiteralNodeGen.expectDynamicObject(this.getNext().execute_(frameValue, beginValue_, ex.getResult()));
            }
            return this.root.intRange(beginValue_, endValue_);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            if (beginValue instanceof Integer && endValue instanceof Integer) {
                int beginValue_ = (Integer)beginValue;
                int endValue_ = (Integer)endValue;
                return this.root.intRange(beginValue_, endValue_);
            }
            return this.getNext().execute_(frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root) {
            return new IntRangeNode_(root);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(RangeLiteralNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object beginValue, Object endValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, beginValue, endValue));
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            return this.getNext().execute_(frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(RangeLiteralNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute_(VirtualFrame frameValue, Object beginValue, Object endValue) {
            return this.uninitialized((Frame)frameValue, beginValue, endValue);
        }

        static BaseNode_ create(RangeLiteralNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=RangeLiteralNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final RangeLiteralNodeGen root;

        BaseNode_(RangeLiteralNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.begin_, this.root.end_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object beginValue, Object endValue) {
            return this.execute_((VirtualFrame)frameValue, beginValue, endValue);
        }

        public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

        public Object execute(VirtualFrame frameValue) {
            Object beginValue_ = this.executeBegin_((Frame)frameValue);
            Object endValue_ = this.executeEnd_((Frame)frameValue);
            return this.execute_(frameValue, beginValue_, endValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public DynamicObject executeDynamicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            return RangeLiteralNodeGen.expectDynamicObject(this.execute(frameValue));
        }

        protected final SpecializationNode createNext(Frame frameValue, Object beginValue, Object endValue) {
            if (beginValue instanceof Integer && endValue instanceof Integer) {
                return IntRangeNode_.create(this.root);
            }
            if (RubyTypesGen.isImplicitLong(beginValue) && RubyTypesGen.isImplicitLong(endValue)) {
                long beginValue_ = RubyTypesGen.asImplicitLong(beginValue);
                long endValue_ = RubyTypesGen.asImplicitLong(endValue);
                if (this.root.fitsIntoInteger(beginValue_) && this.root.fitsIntoInteger(endValue_)) {
                    return LongFittingIntRangeNode_.create(this.root, beginValue, endValue);
                }
                if (!this.root.fitsIntoInteger(beginValue_) || !this.root.fitsIntoInteger(endValue_)) {
                    return LongRangeNode_.create(this.root, beginValue, endValue);
                }
            }
            if (!this.root.isIntOrLong(beginValue) || !this.root.isIntOrLong(endValue)) {
                return RangeNode_.create(this.root);
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        protected final long executeBeginLong_(Frame frameValue, Class<?> beginImplicitType) throws UnexpectedResultException {
            if (beginImplicitType == Long.TYPE) {
                return this.root.begin_.executeLong((VirtualFrame)frameValue);
            }
            if (beginImplicitType == Integer.TYPE) {
                return RubyTypes.int2long(this.root.begin_.executeInteger((VirtualFrame)frameValue));
            }
            Object beginValue_ = this.executeBegin_(frameValue);
            throw new UnexpectedResultException(beginValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeBegin_(Frame frameValue) {
            Object object;
            Class beginType_ = this.root.beginType_;
            if (beginType_ == Integer.TYPE) {
                return this.root.begin_.executeInteger((VirtualFrame)frameValue);
            }
            if (beginType_ == Long.TYPE) {
                return this.root.begin_.executeLong((VirtualFrame)frameValue);
            }
            if (beginType_ != null) return this.root.begin_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.begin_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.beginType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.beginType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.beginType_ = _type;
            return object;
        }

        protected final long executeEndLong_(Frame frameValue, Class<?> endImplicitType) throws UnexpectedResultException {
            if (endImplicitType == Long.TYPE) {
                return this.root.end_.executeLong((VirtualFrame)frameValue);
            }
            if (endImplicitType == Integer.TYPE) {
                return RubyTypes.int2long(this.root.end_.executeInteger((VirtualFrame)frameValue));
            }
            Object endValue_ = this.executeEnd_(frameValue);
            throw new UnexpectedResultException(endValue_);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeEnd_(Frame frameValue) {
            Object object;
            Class endType_ = this.root.endType_;
            if (endType_ == Integer.TYPE) {
                return this.root.end_.executeInteger((VirtualFrame)frameValue);
            }
            if (endType_ == Long.TYPE) {
                return this.root.end_.executeLong((VirtualFrame)frameValue);
            }
            if (endType_ != null) return this.root.end_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.end_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class);
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.endType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.endType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.endType_ = _type;
            return object;
        }
    }
}

