/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.globals;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.ThreadLocalObjectNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.ReadInstanceVariableNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;

public class ReadLastBacktraceNode
extends RubyNode {
    @Node.Child
    private ReadInstanceVariableNode getLastExceptionNode = new ReadInstanceVariableNode(this.getContext(), this.getSourceSection(), "$!", new ThreadLocalObjectNode(this.getContext(), this.getSourceSection()), true);
    @Node.Child
    private CallDispatchHeadNode getBacktraceNode = DispatchHeadNodeFactory.createMethodCall(this.getContext());

    public ReadLastBacktraceNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"global-variable", (Encoding)UTF8Encoding.INSTANCE), 16, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object lastException = this.getLastExceptionNode.execute(frame);
        if (lastException == this.nil()) {
            return this.nil();
        }
        return this.getBacktraceNode.call(frame, lastException, "backtrace", null, new Object[0]);
    }
}

