/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;

public class CallDispatchHeadNode
extends DispatchHeadNode {
    @Node.Child
    private BooleanCastNode booleanCastNode;

    public CallDispatchHeadNode(RubyContext context, boolean ignoreVisibility, boolean indirect, MissingBehavior missingBehavior) {
        super(context, ignoreVisibility, indirect, missingBehavior, DispatchAction.CALL_METHOD);
    }

    public Object call(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object ... argumentsObjects) {
        return this.dispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
    }

    public boolean callBoolean(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object ... argumentsObjects) {
        if (this.booleanCastNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeGen.create(this.context, this.getSourceSection(), null));
        }
        return this.booleanCastNode.executeBoolean(frame, this.dispatch(frame, receiverObject, methodName, blockObject, argumentsObjects));
    }

    public double callFloat(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object ... argumentsObjects) {
        Object value = this.call(frame, receiverObject, methodName, blockObject, argumentsObjects);
        if (value instanceof Double) {
            return (Double)value;
        }
        CompilerDirectives.transferToInterpreter();
        if (value == DispatchNode.MISSING) {
            throw new RaiseException(this.context.getCoreLibrary().typeErrorCantConvertInto(receiverObject, this.context.getCoreLibrary().getFloatClass(), this));
        }
        throw new RaiseException(this.context.getCoreLibrary().typeErrorCantConvertTo(receiverObject, this.context.getCoreLibrary().getFloatClass(), (String)methodName, value, this));
    }

    public long callLongFixnum(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object ... argumentsObjects) {
        Object value = this.call(frame, receiverObject, methodName, blockObject, argumentsObjects);
        if (value instanceof Integer) {
            return ((Integer)value).intValue();
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        CompilerDirectives.transferToInterpreter();
        if (value == DispatchNode.MISSING) {
            throw new RaiseException(this.context.getCoreLibrary().typeErrorCantConvertInto(receiverObject, this.context.getCoreLibrary().getFixnumClass(), this));
        }
        throw new RaiseException(this.context.getCoreLibrary().typeErrorCantConvertTo(receiverObject, this.context.getCoreLibrary().getFixnumClass(), (String)methodName, value, this));
    }
}

