/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.dispatch.CachedDispatchNode;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class CachedBoxedMethodMissingDispatchNode
extends CachedDispatchNode {
    private final Shape expectedShape;
    private final Assumption unmodifiedAssumption;
    private final InternalMethod method;
    @Node.Child
    private DirectCallNode callNode;
    @Node.Child
    private IndirectCallNode indirectCallNode;

    public CachedBoxedMethodMissingDispatchNode(RubyContext context, Object cachedName, DispatchNode next, Shape expectedShape, DynamicObject expectedClass, InternalMethod method, boolean indirect, DispatchAction dispatchAction) {
        super(context, cachedName, next, indirect, dispatchAction);
        assert (RubyGuards.isRubyClass(expectedClass));
        this.expectedShape = expectedShape;
        this.unmodifiedAssumption = Layouts.MODULE.getFields(expectedClass).getUnmodifiedAssumption();
        this.method = method;
        if (indirect) {
            this.indirectCallNode = Truffle.getRuntime().createIndirectCallNode();
        } else {
            this.callNode = Truffle.getRuntime().createDirectCallNode(method.getCallTarget());
            if (this.callNode.isCallTargetCloningAllowed() && (this.getContext().getOptions().DISPATCH_METHODMISSING_ALWAYS_CLONED || method.getSharedMethodInfo().shouldAlwaysSplit())) {
                this.insert((Node)this.callNode);
                this.callNode.cloneCallTarget();
            }
            if (this.callNode.isInlinable() && this.getContext().getOptions().DISPATCH_METHODMISSING_ALWAYS_INLINED) {
                this.insert((Node)this.callNode);
                this.callNode.forceInlining();
            }
        }
    }

    @Override
    protected boolean guard(Object methodName, Object receiver) {
        return this.guardName(methodName) && receiver instanceof DynamicObject && ((DynamicObject)receiver).getShape() == this.expectedShape;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, Object blockObject, Object argumentsObjects) {
        if (!this.guard(methodName, receiverObject)) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        try {
            this.unmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, (DynamicObject)blockObject, argumentsObjects, "class modified");
        }
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                Object[] argumentsObjectsArray = (Object[])argumentsObjects;
                Object[] modifiedArgumentsObjects = new Object[1 + argumentsObjectsArray.length];
                modifiedArgumentsObjects[0] = this.getCachedNameAsSymbol();
                ArrayUtils.arraycopy(argumentsObjectsArray, 0, modifiedArgumentsObjects, 1, argumentsObjectsArray.length);
                if (this.isIndirect()) {
                    return this.indirectCallNode.call(frame, this.method.getCallTarget(), RubyArguments.pack(this.method, this.method.getDeclarationFrame(), receiverObject, (DynamicObject)blockObject, modifiedArgumentsObjects));
                }
                return this.callNode.call(frame, RubyArguments.pack(this.method, this.method.getDeclarationFrame(), receiverObject, (DynamicObject)blockObject, modifiedArgumentsObjects));
            }
            case RESPOND_TO_METHOD: {
                return false;
            }
        }
        throw new UnsupportedOperationException();
    }
}

