/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.EnsureCapacityArrayNode;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=EnsureCapacityArrayNode.class)
public final class EnsureCapacityArrayNodeGen
extends EnsureCapacityArrayNode
implements SpecializedNode {
    @Node.Child
    private RubyNode array_;
    @Node.Child
    private RubyNode requiredCapacity_;
    @CompilerDirectives.CompilationFinal
    private Class<?> requiredCapacityType_;
    @Node.Child
    private BaseNode_ specialization_;

    private EnsureCapacityArrayNodeGen(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
        super(context, sourceSection);
        this.array_ = array;
        this.requiredCapacity_ = requiredCapacity;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeEnsureCapacity(VirtualFrame frameValue, DynamicObject arrayValue, int requiredCapacityValue) {
        return this.specialization_.execute1(frameValue, arrayValue, requiredCapacityValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        return this.specialization_.executeBoolean(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static EnsureCapacityArrayNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
        return new EnsureCapacityArrayNodeGen(context, sourceSection, array, requiredCapacity);
    }

    @GeneratedBy(methodName="ensureCapacityObject(DynamicObject, int)", value=EnsureCapacityArrayNode.class)
    private static final class EnsureCapacityObjectNode_
    extends BaseNode_ {
        EnsureCapacityObjectNode_(EnsureCapacityArrayNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_((Frame)frameValue);
                return this.getNext().executeBoolean_(frameValue, ex.getResult(), requiredCapacityValue);
            }
            try {
                requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean_(frameValue, arrayValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                return this.root.ensureCapacityObject(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeBoolean_(frameValue, arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, int requiredCapacityValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return this.root.ensureCapacityObject(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, requiredCapacityValue);
        }

        @Override
        public boolean executeBoolean_(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && requiredCapacityValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = (Integer)requiredCapacityValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                    return this.root.ensureCapacityObject(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeBoolean_(frameValue, arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(EnsureCapacityArrayNodeGen root) {
            return new EnsureCapacityObjectNode_(root);
        }
    }

    @GeneratedBy(methodName="ensureCapacityDouble(DynamicObject, int)", value=EnsureCapacityArrayNode.class)
    private static final class EnsureCapacityDoubleNode_
    extends BaseNode_ {
        EnsureCapacityDoubleNode_(EnsureCapacityArrayNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_((Frame)frameValue);
                return this.getNext().executeBoolean_(frameValue, ex.getResult(), requiredCapacityValue);
            }
            try {
                requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean_(frameValue, arrayValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                return this.root.ensureCapacityDouble(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeBoolean_(frameValue, arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, int requiredCapacityValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return this.root.ensureCapacityDouble(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, requiredCapacityValue);
        }

        @Override
        public boolean executeBoolean_(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && requiredCapacityValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = (Integer)requiredCapacityValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return this.root.ensureCapacityDouble(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeBoolean_(frameValue, arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(EnsureCapacityArrayNodeGen root) {
            return new EnsureCapacityDoubleNode_(root);
        }
    }

    @GeneratedBy(methodName="ensureCapacityLong(DynamicObject, int)", value=EnsureCapacityArrayNode.class)
    private static final class EnsureCapacityLongNode_
    extends BaseNode_ {
        EnsureCapacityLongNode_(EnsureCapacityArrayNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_((Frame)frameValue);
                return this.getNext().executeBoolean_(frameValue, ex.getResult(), requiredCapacityValue);
            }
            try {
                requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean_(frameValue, arrayValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                return this.root.ensureCapacityLong(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeBoolean_(frameValue, arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, int requiredCapacityValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isLongArray(arrayValue)) {
                return this.root.ensureCapacityLong(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, requiredCapacityValue);
        }

        @Override
        public boolean executeBoolean_(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && requiredCapacityValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = (Integer)requiredCapacityValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                    return this.root.ensureCapacityLong(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeBoolean_(frameValue, arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(EnsureCapacityArrayNodeGen root) {
            return new EnsureCapacityLongNode_(root);
        }
    }

    @GeneratedBy(methodName="ensureCapacityInt(DynamicObject, int)", value=EnsureCapacityArrayNode.class)
    private static final class EnsureCapacityIntNode_
    extends BaseNode_ {
        EnsureCapacityIntNode_(EnsureCapacityArrayNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int requiredCapacityValue_;
            DynamicObject arrayValue_;
            try {
                arrayValue_ = this.root.array_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue = this.executeRequiredCapacity_((Frame)frameValue);
                return this.getNext().executeBoolean_(frameValue, ex.getResult(), requiredCapacityValue);
            }
            try {
                requiredCapacityValue_ = this.root.requiredCapacity_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean_(frameValue, arrayValue_, ex.getResult());
            }
            if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                return this.root.ensureCapacityInt(arrayValue_, requiredCapacityValue_);
            }
            return this.getNext().executeBoolean_(frameValue, arrayValue_, requiredCapacityValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, int requiredCapacityValue) {
            if (RubyGuards.isRubyArray(arrayValue) && ArrayGuards.isIntArray(arrayValue)) {
                return this.root.ensureCapacityInt(arrayValue, requiredCapacityValue);
            }
            return this.getNext().execute1(frameValue, arrayValue, requiredCapacityValue);
        }

        @Override
        public boolean executeBoolean_(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && requiredCapacityValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                int requiredCapacityValue_ = (Integer)requiredCapacityValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                    return this.root.ensureCapacityInt(arrayValue_, requiredCapacityValue_);
                }
            }
            return this.getNext().executeBoolean_(frameValue, arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(EnsureCapacityArrayNodeGen root) {
            return new EnsureCapacityIntNode_(root);
        }
    }

    @GeneratedBy(value=EnsureCapacityArrayNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(EnsureCapacityArrayNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arrayValue, requiredCapacityValue));
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object requiredCapacityValue_ = this.executeRequiredCapacity_((Frame)frameValue);
            return this.getNext().executeBoolean_(frameValue, arrayValue_, requiredCapacityValue_);
        }

        @Override
        public boolean executeBoolean_(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.getNext().executeBoolean_(frameValue, arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(EnsureCapacityArrayNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=EnsureCapacityArrayNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(EnsureCapacityArrayNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public boolean executeBoolean_(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return (Boolean)this.uninitialized((Frame)frameValue, arrayValue, requiredCapacityValue);
        }

        static BaseNode_ create(EnsureCapacityArrayNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=EnsureCapacityArrayNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final EnsureCapacityArrayNodeGen root;

        BaseNode_(EnsureCapacityArrayNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.array_, this.root.requiredCapacity_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.executeBoolean_((VirtualFrame)frameValue, arrayValue, requiredCapacityValue);
        }

        public abstract boolean executeBoolean_(VirtualFrame var1, Object var2, Object var3);

        public Object execute1(VirtualFrame frameValue, DynamicObject arrayValue, int requiredCapacityValue) {
            return this.executeBoolean_(frameValue, arrayValue, requiredCapacityValue);
        }

        public Object execute0(VirtualFrame frameValue) {
            Object arrayValue_ = this.root.array_.execute(frameValue);
            Object requiredCapacityValue_ = this.executeRequiredCapacity_((Frame)frameValue);
            return this.executeBoolean_(frameValue, arrayValue_, requiredCapacityValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        public boolean executeBoolean(VirtualFrame frameValue) {
            return (Boolean)this.execute0(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (arrayValue instanceof DynamicObject && requiredCapacityValue instanceof Integer) {
                DynamicObject arrayValue_ = (DynamicObject)arrayValue;
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isIntArray(arrayValue_)) {
                    return EnsureCapacityIntNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isLongArray(arrayValue_)) {
                    return EnsureCapacityLongNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isDoubleArray(arrayValue_)) {
                    return EnsureCapacityDoubleNode_.create(this.root);
                }
                if (RubyGuards.isRubyArray(arrayValue_) && ArrayGuards.isObjectArray(arrayValue_)) {
                    return EnsureCapacityObjectNode_.create(this.root);
                }
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeRequiredCapacity_(Frame frameValue) {
            Object object;
            Class requiredCapacityType_ = this.root.requiredCapacityType_;
            if (requiredCapacityType_ == Integer.TYPE) {
                return this.root.requiredCapacity_.executeInteger((VirtualFrame)frameValue);
            }
            if (requiredCapacityType_ != null) return this.root.requiredCapacity_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.requiredCapacity_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.requiredCapacityType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.requiredCapacityType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.requiredCapacityType_ = _type;
            return object;
        }
    }
}

