/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.array;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.StringCachingGuards;
import org.jruby.truffle.nodes.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.coerce.ToAryNodeGen;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.nodes.coerce.ToIntNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.core.array.AppendManyNode;
import org.jruby.truffle.nodes.core.array.AppendManyNodeGen;
import org.jruby.truffle.nodes.core.array.AppendOneNode;
import org.jruby.truffle.nodes.core.array.AppendOneNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayBuilderNode;
import org.jruby.truffle.nodes.core.array.ArrayCoreMethodNode;
import org.jruby.truffle.nodes.core.array.ArrayGuards;
import org.jruby.truffle.nodes.core.array.ArrayNodesFactory;
import org.jruby.truffle.nodes.core.array.ArrayReadDenormalizedNode;
import org.jruby.truffle.nodes.core.array.ArrayReadDenormalizedNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceDenormalizedNode;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceDenormalizedNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceNormalizedNode;
import org.jruby.truffle.nodes.core.array.ArrayReadSliceNormalizedNodeGen;
import org.jruby.truffle.nodes.core.array.ArrayWriteDenormalizedNode;
import org.jruby.truffle.nodes.core.array.ArrayWriteDenormalizedNodeGen;
import org.jruby.truffle.nodes.core.array.PopOneNode;
import org.jruby.truffle.nodes.core.array.PopOneNodeGen;
import org.jruby.truffle.nodes.core.fixnum.FixnumLowerNodeGen;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.locals.ReadDeclarationVariableNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.nodes.objects.TaintNode;
import org.jruby.truffle.nodes.objects.TaintNodeGen;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.pack.parser.PackParser;
import org.jruby.truffle.pack.runtime.PackResult;
import org.jruby.truffle.pack.runtime.exceptions.CantCompressNegativeException;
import org.jruby.truffle.pack.runtime.exceptions.CantConvertException;
import org.jruby.truffle.pack.runtime.exceptions.FormatException;
import org.jruby.truffle.pack.runtime.exceptions.NoImplicitConversionException;
import org.jruby.truffle.pack.runtime.exceptions.OutsideOfStringException;
import org.jruby.truffle.pack.runtime.exceptions.PackException;
import org.jruby.truffle.pack.runtime.exceptions.RangeException;
import org.jruby.truffle.pack.runtime.exceptions.TooFewArgumentsException;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayMirror;
import org.jruby.truffle.runtime.array.ArrayReflector;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.array.DoubleArrayMirror;
import org.jruby.truffle.runtime.array.IntegerArrayMirror;
import org.jruby.truffle.runtime.array.LongArrayMirror;
import org.jruby.truffle.runtime.array.ObjectArrayMirror;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.core.CoreSourceSection;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.util.ByteList;
import org.jruby.util.Memo;

@CoreClass(name="Array")
public abstract class ArrayNodes {

    @CoreMethod(names={"zip"}, rest=true, required=1)
    public static abstract class ZipNode
    extends ArrayCoreMethodNode {
        public ZipNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isObjectArray(array)", "isRubyArray(other)", "isIntArray(other)", "others.length == 0"})
        public DynamicObject zipObjectIntegerFixnum(DynamicObject array, DynamicObject other, Object[] others) {
            boolean areSameLength;
            Object[] a = (Object[])Layouts.ARRAY.getStore(array);
            int[] b = (int[])Layouts.ARRAY.getStore(other);
            int bLength = Layouts.ARRAY.getSize(other);
            int zippedLength = Layouts.ARRAY.getSize(array);
            Object[] zipped = new Object[zippedLength];
            boolean bl = areSameLength = bLength == zippedLength;
            if (areSameLength) {
                for (int n = 0; n < zippedLength; ++n) {
                    zipped[n] = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{a[n], b[n]}, 2);
                }
            } else {
                for (int n = 0; n < zippedLength; ++n) {
                    zipped[n] = n < bLength ? Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{a[n], b[n]}, 2) : Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{a[n], this.nil()}, 2);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), zipped, zippedLength);
        }

        @Specialization(guards={"isObjectArray(array)", "isRubyArray(other)", "isObjectArray(other)", "others.length == 0"})
        public DynamicObject zipObjectObject(DynamicObject array, DynamicObject other, Object[] others) {
            boolean areSameLength;
            Object[] a = (Object[])Layouts.ARRAY.getStore(array);
            Object[] b = (Object[])Layouts.ARRAY.getStore(other);
            int bLength = Layouts.ARRAY.getSize(other);
            int zippedLength = Layouts.ARRAY.getSize(array);
            Object[] zipped = new Object[zippedLength];
            boolean bl = areSameLength = bLength == zippedLength;
            if (areSameLength) {
                for (int n = 0; n < zippedLength; ++n) {
                    zipped[n] = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{a[n], b[n]}, 2);
                }
            } else {
                for (int n = 0; n < zippedLength; ++n) {
                    zipped[n] = n < bLength ? Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{a[n], b[n]}, 2) : Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{a[n], this.nil()}, 2);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), zipped, zippedLength);
        }

        @Specialization(guards={"isRubyArray(other)", "fallback(array, other, others)"})
        public Object zipObjectObjectNotSingleObject(VirtualFrame frame, DynamicObject array, DynamicObject other, Object[] others) {
            return this.zipRuby(frame);
        }

        @Specialization(guards={"!isRubyArray(other)"})
        public Object zipObjectObjectNotArray(VirtualFrame frame, DynamicObject array, DynamicObject other, Object[] others) {
            return this.zipRuby(frame);
        }

        private Object zipRuby(VirtualFrame frame) {
            DynamicObject proc = RubyArguments.getBlock(frame.getArguments());
            if (proc == null) {
                proc = this.nil();
            }
            Object[] others = RubyArguments.extractUserArguments(frame.getArguments());
            return this.ruby(frame, "zip_internal(*others, &block)", "others", Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), others, others.length), "block", proc);
        }

        protected static boolean fallback(DynamicObject array, DynamicObject other, Object[] others) {
            return !ArrayGuards.isObjectArray(array) || ArrayGuards.isNullArray(other) || ArrayGuards.isLongArray(other) || others.length > 0;
        }
    }

    @CoreMethod(names={"unshift"}, rest=true, raiseIfFrozenSelf=true)
    public static abstract class UnshiftNode
    extends CoreMethodArrayArgumentsNode {
        public UnshiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject unshift(DynamicObject array, Object ... args) {
            CompilerDirectives.transferToInterpreter();
            assert (RubyGuards.isRubyArray(array));
            Object[] newStore = new Object[Layouts.ARRAY.getSize(array) + args.length];
            System.arraycopy(args, 0, newStore, 0, args.length);
            ArrayUtils.copy(Layouts.ARRAY.getStore(array), newStore, args.length, Layouts.ARRAY.getSize(array));
            Layouts.ARRAY.setStore(array, newStore);
            Layouts.ARRAY.setSize(array, newStore.length);
            return array;
        }
    }

    @CoreMethod(names={"sort"}, needsBlock=true)
    public static abstract class SortNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode compareDispatchNode;
        @Node.Child
        private YieldDispatchHeadNode yieldNode;

        public SortNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareDispatchNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.yieldNode = new YieldDispatchHeadNode(context);
        }

        @Specialization(guards={"isNullArray(array)"})
        public DynamicObject sortNull(DynamicObject array, Object unusedBlock) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }

        @ExplodeLoop
        @Specialization(guards={"isIntArray(array)", "isSmall(array)"})
        public DynamicObject sortVeryShortIntegerFixnum(VirtualFrame frame, DynamicObject array, NotProvided block) {
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            int[] newStore = new int[store.length];
            int size = Layouts.ARRAY.getSize(array);
            for (int i = 0; i < this.getContext().getOptions().ARRAYS_SMALL; ++i) {
                if (i >= size) continue;
                for (int j = i + 1; j < this.getContext().getOptions().ARRAYS_SMALL; ++j) {
                    if (j >= size || this.castSortValue(this.compareDispatchNode.call(frame, store[j], "<=>", null, store[i])) >= 0) continue;
                    int temp = store[j];
                    store[j] = store[i];
                    store[i] = temp;
                }
                newStore[i] = store[i];
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), newStore, size);
        }

        @ExplodeLoop
        @Specialization(guards={"isLongArray(array)", "isSmall(array)"})
        public DynamicObject sortVeryShortLongFixnum(VirtualFrame frame, DynamicObject array, NotProvided block) {
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            long[] newStore = new long[store.length];
            int size = Layouts.ARRAY.getSize(array);
            for (int i = 0; i < this.getContext().getOptions().ARRAYS_SMALL; ++i) {
                if (i >= size) continue;
                for (int j = i + 1; j < this.getContext().getOptions().ARRAYS_SMALL; ++j) {
                    if (j >= size || this.castSortValue(this.compareDispatchNode.call(frame, store[j], "<=>", null, store[i])) >= 0) continue;
                    long temp = store[j];
                    store[j] = store[i];
                    store[i] = temp;
                }
                newStore[i] = store[i];
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), newStore, size);
        }

        @Specialization(guards={"isObjectArray(array)", "isSmall(array)"})
        public DynamicObject sortVeryShortObject(VirtualFrame frame, DynamicObject array, NotProvided block) {
            Object[] oldStore = (Object[])Layouts.ARRAY.getStore(array);
            Object[] store = Arrays.copyOf(oldStore, oldStore.length);
            int size = Layouts.ARRAY.getSize(array);
            for (int i = 1; i < size; ++i) {
                Object x = store[i];
                for (int j = i; j > 0 && this.castSortValue(this.compareDispatchNode.call(frame, store[j - 1], "<=>", null, x)) > 0; --j) {
                    store[j] = store[j - 1];
                }
                store[j] = x;
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), store, size);
        }

        @Specialization(guards={"!isNullArray(array)", "isRubyProc(block)"})
        public Object sortUsingRubinius(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            return this.ruby(frame, "sorted = dup; Rubinius.privately { sorted.isort_block!(0, right, block) }; sorted", "right", Layouts.ARRAY.getSize(array), "block", block);
        }

        @Specialization(guards={"!isNullArray(array)", "!isSmall(array)"})
        public Object sortUsingRubinius(VirtualFrame frame, DynamicObject array, NotProvided block) {
            return this.ruby(frame, "sorted = dup; Rubinius.privately { sorted.isort!(0, right) }; sorted", "right", Layouts.ARRAY.getSize(array));
        }

        private int castSortValue(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("expecting a Fixnum to sort", this));
        }

        protected boolean isSmall(DynamicObject array) {
            return Layouts.ARRAY.getSize(array) <= this.getContext().getOptions().ARRAYS_SMALL;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends ArrayCoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int size(DynamicObject array) {
            return Layouts.ARRAY.getSize(array);
        }
    }

    @CoreMethod(names={"shift"}, raiseIfFrozenSelf=true, optional=1)
    public static abstract class ShiftNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;

        public ShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeShift(VirtualFrame var1, DynamicObject var2, Object var3);

        @Specialization(guards={"isEmptyArray(array)"})
        public Object shiftNil(VirtualFrame frame, DynamicObject array, NotProvided n) {
            return this.nil();
        }

        @Specialization(guards={"isIntArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public int shiftIntegerFixnumInBounds(VirtualFrame frame, DynamicObject array, NotProvided n) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            int value = store[0];
            System.arraycopy(store, 1, store, 0, Layouts.ARRAY.getSize(array) - 1);
            int[] filler = new int[1];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - 1, 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"shiftIntegerFixnumInBounds"}, guards={"isIntArray(array)"})
        public Object shiftIntegerFixnum(VirtualFrame frame, DynamicObject array, NotProvided n) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            int value = store[0];
            System.arraycopy(store, 1, store, 0, Layouts.ARRAY.getSize(array) - 1);
            int[] filler = new int[1];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - 1, 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isLongArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public long shiftLongFixnumInBounds(VirtualFrame frame, DynamicObject array, NotProvided n) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            long value = store[0];
            System.arraycopy(store, 1, store, 0, Layouts.ARRAY.getSize(array) - 1);
            long[] filler = new long[1];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - 1, 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"shiftLongFixnumInBounds"}, guards={"isLongArray(array)"})
        public Object shiftLongFixnum(VirtualFrame frame, DynamicObject array, NotProvided n) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            long value = store[0];
            System.arraycopy(store, 1, store, 0, Layouts.ARRAY.getSize(array) - 1);
            long[] filler = new long[1];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - 1, 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isDoubleArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public double shiftFloatInBounds(VirtualFrame frame, DynamicObject array, NotProvided n) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            double value = store[0];
            System.arraycopy(store, 1, store, 0, Layouts.ARRAY.getSize(array) - 1);
            double[] filler = new double[1];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - 1, 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"shiftFloatInBounds"}, guards={"isDoubleArray(array)"})
        public Object shiftFloat(VirtualFrame frame, DynamicObject array, NotProvided n) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            double value = store[0];
            System.arraycopy(store, 1, store, 0, Layouts.ARRAY.getSize(array) - 1);
            double[] filler = new double[1];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - 1, 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object shiftObject(VirtualFrame frame, DynamicObject array, NotProvided n) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            Object value = store[0];
            System.arraycopy(store, 1, store, 0, Layouts.ARRAY.getSize(array) - 1);
            Object[] filler = new Object[1];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - 1, 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isEmptyArray(array)", "wasProvided(object)"})
        public Object shiftNilWithNum(VirtualFrame frame, DynamicObject array, Object object) {
            int n;
            if (object instanceof Integer && (Integer)object < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((n = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }

        @Specialization(guards={"isIntArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public DynamicObject popIntegerFixnumInBoundsWithNum(VirtualFrame frame, DynamicObject array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, numShift), numShift);
            int[] filler = new int[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(contains={"popIntegerFixnumInBoundsWithNum"}, guards={"isIntArray(array)"})
        public Object popIntegerFixnumWithNum(VirtualFrame frame, DynamicObject array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, numShift), numShift);
            int[] filler = new int[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isLongArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public DynamicObject shiftLongFixnumInBoundsWithNum(VirtualFrame frame, DynamicObject array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, numShift), numShift);
            long[] filler = new long[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(contains={"shiftLongFixnumInBoundsWithNum"}, guards={"isLongArray(array)"})
        public Object shiftLongFixnumWithNum(VirtualFrame frame, DynamicObject array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, numShift), numShift);
            long[] filler = new long[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isDoubleArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public DynamicObject shiftFloatInBoundsWithNum(VirtualFrame frame, DynamicObject array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, numShift), numShift);
            double[] filler = new double[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(contains={"shiftFloatInBoundsWithNum"}, guards={"isDoubleArray(array)"})
        public Object shiftFloatWithNum(VirtualFrame frame, DynamicObject array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, numShift), numShift);
            double[] filler = new double[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object shiftObjectWithNum(VirtualFrame frame, DynamicObject array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, numShift), numShift);
            Object[] filler = new Object[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isIntArray(array)", "!isInteger(object)", "wasProvided(object)"}, rewriteOn={UnexpectedResultException.class})
        public DynamicObject shiftIntegerFixnumInBoundsWithNumObj(VirtualFrame frame, DynamicObject array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, numShift), numShift);
            int[] filler = new int[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(contains={"shiftIntegerFixnumInBoundsWithNumObj"}, guards={"isIntArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object shiftIntegerFixnumWithNumObj(VirtualFrame frame, DynamicObject array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, numShift), numShift);
            int[] filler = new int[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isLongArray(array)", "!isInteger(object)", "wasProvided(object)"}, rewriteOn={UnexpectedResultException.class})
        public DynamicObject shiftLongFixnumInBoundsWithNumObj(VirtualFrame frame, DynamicObject array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, numShift), numShift);
            long[] filler = new long[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(contains={"shiftLongFixnumInBoundsWithNumObj"}, guards={"isLongArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object shiftLongFixnumWithNumObj(VirtualFrame frame, DynamicObject array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, numShift), numShift);
            long[] filler = new long[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isDoubleArray(array)", "!isInteger(object)", "wasProvided(object)"}, rewriteOn={UnexpectedResultException.class})
        public DynamicObject shiftFloatInBoundsWithNumObj(VirtualFrame frame, DynamicObject array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, Layouts.ARRAY.getSize(array) - numShift), numShift);
            double[] filler = new double[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(contains={"shiftFloatInBoundsWithNumObj"}, guards={"isDoubleArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object shiftFloatWithNumObj(VirtualFrame frame, DynamicObject array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, Layouts.ARRAY.getSize(array) - numShift), numShift);
            double[] filler = new double[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }

        @Specialization(guards={"isObjectArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object shiftObjectWithNumObj(VirtualFrame frame, DynamicObject array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, 0, Layouts.ARRAY.getSize(array) - numShift), numShift);
            Object[] filler = new Object[numShift];
            System.arraycopy(store, numShift, store, 0, Layouts.ARRAY.getSize(array) - numShift);
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numShift, numShift);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numShift);
            return result;
        }
    }

    @CoreMethod(names={"select"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class SelectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public SelectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        @Specialization(guards={"isNullArray(array)", "isRubyProc(block)"})
        public Object selectNull(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)", "isRubyProc(block)"})
        public Object selectObject(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            Object selectedStore = this.arrayBuilder.start(Layouts.ARRAY.getSize(array));
            int selectedSize = 0;
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    Object value = store[n];
                    if (!this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = this.arrayBuilder.appendValue(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)", "isRubyProc(block)"})
        public Object selectFixnumInteger(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            Object selectedStore = this.arrayBuilder.start(Layouts.ARRAY.getSize(array));
            int selectedSize = 0;
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    Integer value = store[n];
                    if (!this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = this.arrayBuilder.appendValue(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }
    }

    @CoreMethod(names={"replace"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ReplaceNode
    extends CoreMethodNode {
        public ReplaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToAry(RubyNode index) {
            return ToAryNodeGen.create(this.getContext(), this.getSourceSection(), index);
        }

        @Specialization(guards={"isRubyArray(other)", "isNullArray(other)"})
        public DynamicObject replace(DynamicObject array, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            Layouts.ARRAY.setStore(array, null);
            Layouts.ARRAY.setSize(array, 0);
            return array;
        }

        @Specialization(guards={"isRubyArray(other)", "isIntArray(other)"})
        public DynamicObject replaceIntegerFixnum(DynamicObject array, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            Layouts.ARRAY.setStore(array, Arrays.copyOf((int[])Layouts.ARRAY.getStore(other), Layouts.ARRAY.getSize(other)));
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(other));
            return array;
        }

        @Specialization(guards={"isRubyArray(other)", "isLongArray(other)"})
        public DynamicObject replaceLongFixnum(DynamicObject array, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            Layouts.ARRAY.setStore(array, Arrays.copyOf((long[])Layouts.ARRAY.getStore(other), Layouts.ARRAY.getSize(other)));
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(other));
            return array;
        }

        @Specialization(guards={"isRubyArray(other)", "isDoubleArray(other)"})
        public DynamicObject replaceFloat(DynamicObject array, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            Layouts.ARRAY.setStore(array, Arrays.copyOf((double[])Layouts.ARRAY.getStore(other), Layouts.ARRAY.getSize(other)));
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(other));
            return array;
        }

        @Specialization(guards={"isRubyArray(other)", "isObjectArray(other)"})
        public DynamicObject replaceObject(DynamicObject array, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            Layouts.ARRAY.setStore(array, Arrays.copyOf((Object[])Layouts.ARRAY.getStore(other), Layouts.ARRAY.getSize(other)));
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(other));
            return array;
        }
    }

    @CoreMethod(names={"reject!"}, needsBlock=true, returnsEnumeratorIfNoBlock=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class RejectInPlaceNode
    extends YieldingCoreMethodNode {
        public RejectInPlaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)", "isRubyProc(block)"})
        public Object rejectInPlaceNull(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            return this.nil();
        }

        @Specialization(guards={"isIntArray(array)", "isRubyProc(block)"})
        public Object rejectInPlaceInt(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int n;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            int i = 0;
            for (n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                int[] filler = new int[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                Layouts.ARRAY.setStore(array, store);
                Layouts.ARRAY.setSize(array, i);
                return array;
            }
            return this.nil();
        }

        @Specialization(guards={"isLongArray(array)", "isRubyProc(block)"})
        public Object rejectInPlaceLong(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int n;
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            int i = 0;
            for (n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                long[] filler = new long[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                Layouts.ARRAY.setStore(array, store);
                Layouts.ARRAY.setSize(array, i);
                return array;
            }
            return this.nil();
        }

        @Specialization(guards={"isDoubleArray(array)", "isRubyProc(block)"})
        public Object rejectInPlaceDouble(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int n;
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            int i = 0;
            for (n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                double[] filler = new double[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                Layouts.ARRAY.setStore(array, store);
                Layouts.ARRAY.setSize(array, i);
                return array;
            }
            return this.nil();
        }

        @Specialization(guards={"isObjectArray(array)", "isRubyProc(block)"})
        public Object rejectInPlaceObject(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int n;
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            int i = 0;
            for (n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                Object[] filler = new Object[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                Layouts.ARRAY.setStore(array, store);
                Layouts.ARRAY.setSize(array, i);
                return array;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"delete_if"}, needsBlock=true, returnsEnumeratorIfNoBlock=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class DeleteIfNode
    extends YieldingCoreMethodNode {
        public DeleteIfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)", "isRubyProc(block)"})
        public Object rejectInPlaceNull(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            return array;
        }

        @Specialization(guards={"isIntArray(array)", "isRubyProc(block)"})
        public Object rejectInPlaceInt(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int n;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            int i = 0;
            for (n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                int[] filler = new int[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                Layouts.ARRAY.setStore(array, store);
                Layouts.ARRAY.setSize(array, i);
            }
            return array;
        }

        @Specialization(guards={"isLongArray(array)", "isRubyProc(block)"})
        public Object rejectInPlaceLong(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int n;
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            int i = 0;
            for (n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                long[] filler = new long[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                Layouts.ARRAY.setStore(array, store);
                Layouts.ARRAY.setSize(array, i);
            }
            return array;
        }

        @Specialization(guards={"isDoubleArray(array)", "isRubyProc(block)"})
        public Object rejectInPlaceDouble(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int n;
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            int i = 0;
            for (n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                double[] filler = new double[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                Layouts.ARRAY.setStore(array, store);
                Layouts.ARRAY.setSize(array, i);
            }
            return array;
        }

        @Specialization(guards={"isObjectArray(array)", "isRubyProc(block)"})
        public Object rejectInPlaceObject(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int n;
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            int i = 0;
            for (n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                Object[] filler = new Object[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                Layouts.ARRAY.setStore(array, store);
                Layouts.ARRAY.setSize(array, i);
            }
            return array;
        }
    }

    @CoreMethod(names={"reject"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class RejectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public RejectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        @Specialization(guards={"isNullArray(array)", "isRubyProc(block)"})
        public Object selectNull(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)", "isRubyProc(block)"})
        public Object selectObject(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            Object selectedStore = this.arrayBuilder.start(Layouts.ARRAY.getSize(array));
            int selectedSize = 0;
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    Object value = store[n];
                    CompilerDirectives.transferToInterpreter();
                    if (this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = this.arrayBuilder.appendValue(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)", "isRubyProc(block)"})
        public Object selectFixnumInteger(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            Object selectedStore = this.arrayBuilder.start(Layouts.ARRAY.getSize(array));
            int selectedSize = 0;
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    Integer value = store[n];
                    CompilerDirectives.transferToInterpreter();
                    if (this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = this.arrayBuilder.appendValue(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }
    }

    public static abstract class PushOneNode
    extends ArrayCoreMethodNode {
        private final BranchProfile extendBranch = BranchProfile.create();

        public PushOneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)"})
        public DynamicObject pushEmpty(DynamicObject array, Object value) {
            Layouts.ARRAY.setStore(array, new Object[]{value});
            Layouts.ARRAY.setSize(array, 1);
            return array;
        }

        @Specialization(guards={"isIntArray(array)"})
        public DynamicObject pushIntegerFixnumIntegerFixnum(DynamicObject array, int value) {
            int oldSize = Layouts.ARRAY.getSize(array);
            int newSize = oldSize + 1;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                int[] store1 = store;
                Layouts.ARRAY.setStore(array, store1);
                Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array));
            }
            store[oldSize] = value;
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, newSize);
            return array;
        }

        @Specialization(guards={"isIntArray(array)", "!isInteger(value)"})
        public DynamicObject pushIntegerFixnumObject(DynamicObject array, Object value) {
            Object[] newStore;
            int oldSize = Layouts.ARRAY.getSize(array);
            int newSize = oldSize + 1;
            int[] oldStore = (int[])Layouts.ARRAY.getStore(array);
            if (oldStore.length < newSize) {
                this.extendBranch.enter();
                newStore = ArrayUtils.boxExtra(oldStore, ArrayUtils.capacity(oldStore.length, newSize) - oldStore.length);
            } else {
                newStore = ArrayUtils.box(oldStore);
            }
            newStore[oldSize] = value;
            Layouts.ARRAY.setStore(array, newStore);
            Layouts.ARRAY.setSize(array, newSize);
            return array;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public DynamicObject pushObjectObject(DynamicObject array, Object value) {
            int oldSize = Layouts.ARRAY.getSize(array);
            int newSize = oldSize + 1;
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                Object[] store1 = store;
                Layouts.ARRAY.setStore(array, store1);
                Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array));
            }
            store[oldSize] = value;
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, newSize);
            return array;
        }
    }

    @CoreMethod(names={"push", "__append__"}, rest=true, optional=1, raiseIfFrozenSelf=true)
    public static abstract class PushNode
    extends ArrayCoreMethodNode {
        private final BranchProfile extendBranch = BranchProfile.create();

        public PushNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)", "values.length == 0"})
        public DynamicObject pushNullEmptySingleIntegerFixnum(DynamicObject array, int value, Object[] values) {
            Layouts.ARRAY.setStore(array, new int[]{value});
            Layouts.ARRAY.setSize(array, 1);
            return array;
        }

        @Specialization(guards={"isNullArray(array)", "values.length == 0"})
        public DynamicObject pushNullEmptySingleIntegerLong(DynamicObject array, long value, Object[] values) {
            Layouts.ARRAY.setStore(array, new long[]{value});
            Layouts.ARRAY.setSize(array, 1);
            return array;
        }

        @Specialization(guards={"isNullArray(array)"})
        public DynamicObject pushNullEmptyObjects(VirtualFrame frame, DynamicObject array, Object unusedValue, Object[] unusedRest) {
            Object[] values = RubyArguments.extractUserArguments(frame.getArguments());
            Layouts.ARRAY.setStore(array, values);
            Layouts.ARRAY.setSize(array, values.length);
            return array;
        }

        @Specialization(guards={"!isNullArray(array)", "isEmptyArray(array)"})
        public DynamicObject pushEmptySingleIntegerFixnum(VirtualFrame frame, DynamicObject array, Object unusedValue, Object[] unusedRest) {
            Object[] values = RubyArguments.extractUserArguments(frame.getArguments());
            Layouts.ARRAY.setStore(array, values);
            Layouts.ARRAY.setSize(array, values.length);
            return array;
        }

        @Specialization(guards={"isIntArray(array)", "values.length == 0"})
        public DynamicObject pushIntegerFixnumSingleIntegerFixnum(DynamicObject array, int value, Object[] values) {
            int oldSize = Layouts.ARRAY.getSize(array);
            int newSize = oldSize + 1;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            store[oldSize] = value;
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, newSize);
            return array;
        }

        @Specialization(guards={"isIntArray(array)", "wasProvided(value)", "values.length == 0", "!isInteger(value)", "!isLong(value)"})
        public DynamicObject pushIntegerFixnumSingleOther(DynamicObject array, Object value, Object[] values) {
            Object[] store;
            int oldSize = Layouts.ARRAY.getSize(array);
            int newSize = oldSize + 1;
            int[] oldStore = (int[])Layouts.ARRAY.getStore(array);
            if (oldStore.length < newSize) {
                this.extendBranch.enter();
                store = ArrayUtils.boxExtra(oldStore, ArrayUtils.capacity(oldStore.length, newSize) - oldStore.length);
            } else {
                store = ArrayUtils.box(oldStore);
            }
            store[oldSize] = value;
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, newSize);
            return array;
        }

        @Specialization(guards={"isIntArray(array)", "wasProvided(value)", "rest.length != 0"})
        public DynamicObject pushIntegerFixnum(VirtualFrame frame, DynamicObject array, Object value, Object[] rest) {
            Object[] store;
            Object[] values = RubyArguments.extractUserArguments(frame.getArguments());
            int oldSize = Layouts.ARRAY.getSize(array);
            int newSize = oldSize + values.length;
            int[] oldStore = (int[])Layouts.ARRAY.getStore(array);
            if (oldStore.length < newSize) {
                this.extendBranch.enter();
                store = ArrayUtils.boxExtra(oldStore, ArrayUtils.capacity(oldStore.length, newSize) - oldStore.length);
            } else {
                store = ArrayUtils.box(oldStore);
            }
            for (int n = 0; n < values.length; ++n) {
                store[oldSize + n] = values[n];
            }
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, newSize);
            return array;
        }

        @Specialization(guards={"isLongArray(array)", "values.length == 0"})
        public DynamicObject pushLongFixnumSingleIntegerFixnum(DynamicObject array, int value, Object[] values) {
            int oldSize = Layouts.ARRAY.getSize(array);
            int newSize = oldSize + 1;
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            store[oldSize] = value;
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, newSize);
            return array;
        }

        @Specialization(guards={"isLongArray(array)", "values.length == 0"})
        public DynamicObject pushLongFixnumSingleLongFixnum(DynamicObject array, long value, Object[] values) {
            int oldSize = Layouts.ARRAY.getSize(array);
            int newSize = oldSize + 1;
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            store[oldSize] = value;
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, newSize);
            return array;
        }

        @Specialization(guards={"isDoubleArray(array)"})
        public DynamicObject pushFloat(VirtualFrame frame, DynamicObject array, Object unusedValue, Object[] unusedRest) {
            if (Layouts.ARRAY.getSize(array) != 0) {
                throw new UnsupportedOperationException();
            }
            Object[] values = RubyArguments.extractUserArguments(frame.getArguments());
            Layouts.ARRAY.setStore(array, values);
            Layouts.ARRAY.setSize(array, values.length);
            return array;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public DynamicObject pushObject(VirtualFrame frame, DynamicObject array, Object unusedValue, Object[] unusedRest) {
            Object[] values = RubyArguments.extractUserArguments(frame.getArguments());
            int oldSize = Layouts.ARRAY.getSize(array);
            int newSize = oldSize + values.length;
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            for (int n = 0; n < values.length; ++n) {
                store[oldSize + n] = values[n];
            }
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, newSize);
            return array;
        }
    }

    @CoreMethod(names={"<<"}, raiseIfFrozenSelf=true, required=1)
    public static abstract class LeftShiftNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private AppendOneNode appendOneNode;

        public LeftShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.appendOneNode = AppendOneNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject leftShift(DynamicObject array, Object value) {
            return this.appendOneNode.executeAppendOne(array, value);
        }
    }

    @CoreMethod(names={"pop"}, raiseIfFrozenSelf=true, optional=1)
    public static abstract class PopNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private PopOneNode popOneNode;

        public PopNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object pop(DynamicObject array, NotProvided n) {
            if (this.popOneNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.popOneNode = (PopOneNode)this.insert(PopOneNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.popOneNode.executePopOne(array);
        }

        @Specialization(guards={"isEmptyArray(array)", "wasProvided(object)"})
        public Object popNilWithNum(VirtualFrame frame, DynamicObject array, Object object) {
            int n;
            if (object instanceof Integer && (Integer)object < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((n = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }

        @Specialization(guards={"isIntArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public DynamicObject popIntegerFixnumInBoundsWithNum(VirtualFrame frame, DynamicObject array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            int[] filler = new int[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(contains={"popIntegerFixnumInBoundsWithNum"}, guards={"isIntArray(array)"})
        public Object popIntegerFixnumWithNum(VirtualFrame frame, DynamicObject array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            int[] filler = new int[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isLongArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public DynamicObject popLongFixnumInBoundsWithNum(VirtualFrame frame, DynamicObject array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            long[] filler = new long[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(contains={"popLongFixnumInBoundsWithNum"}, guards={"isLongArray(array)"})
        public Object popLongFixnumWithNum(VirtualFrame frame, DynamicObject array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            long[] filler = new long[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isDoubleArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public DynamicObject popFloatInBoundsWithNum(VirtualFrame frame, DynamicObject array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            double[] filler = new double[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(contains={"popFloatInBoundsWithNum"}, guards={"isDoubleArray(array)"})
        public Object popFloatWithNum(VirtualFrame frame, DynamicObject array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            double[] filler = new double[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object popObjectWithNum(VirtualFrame frame, DynamicObject array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            Object[] filler = new Object[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isIntArray(array)", "!isInteger(object)", "wasProvided(object)"}, rewriteOn={UnexpectedResultException.class})
        public DynamicObject popIntegerFixnumInBoundsWithNumObj(VirtualFrame frame, DynamicObject array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            int[] filler = new int[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(contains={"popIntegerFixnumInBoundsWithNumObj"}, guards={"isIntArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object popIntegerFixnumWithNumObj(VirtualFrame frame, DynamicObject array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            int[] filler = new int[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isLongArray(array)", "!isInteger(object)", "wasProvided(object)"}, rewriteOn={UnexpectedResultException.class})
        public DynamicObject popLongFixnumInBoundsWithNumObj(VirtualFrame frame, DynamicObject array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            long[] filler = new long[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(contains={"popLongFixnumInBoundsWithNumObj"}, guards={"isLongArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object popLongFixnumWithNumObj(VirtualFrame frame, DynamicObject array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            long[] filler = new long[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isDoubleArray(array)", "!isInteger(object)", "wasProvided(object)"}, rewriteOn={UnexpectedResultException.class})
        public DynamicObject popFloatInBoundsWithNumObj(VirtualFrame frame, DynamicObject array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            double[] filler = new double[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(contains={"popFloatInBoundsWithNumObj"}, guards={"isDoubleArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object popFloatWithNumObj(VirtualFrame frame, DynamicObject array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            double[] filler = new double[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }

        @Specialization(guards={"isObjectArray(array)", "!isInteger(object)", "wasProvided(object)"})
        public Object popObjectWithNumObj(VirtualFrame frame, DynamicObject array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (Layouts.ARRAY.getSize(array) == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = Layouts.ARRAY.getSize(array) < num ? Layouts.ARRAY.getSize(array) : num;
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            DynamicObject result = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOfRange(store, Layouts.ARRAY.getSize(array) - numPop, Layouts.ARRAY.getSize(array)), numPop);
            Object[] filler = new Object[numPop];
            System.arraycopy(filler, 0, store, Layouts.ARRAY.getSize(array) - numPop, numPop);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - numPop);
            return result;
        }
    }

    @CoreMethod(names={"pack"}, required=1, taintFromParameter=0)
    @ImportStatic(value={StringCachingGuards.class})
    public static abstract class PackNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private TaintNode taintNode;

        public PackNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(format)", "byteListsEqual(format, cachedFormat)"})
        public DynamicObject packCached(VirtualFrame frame, DynamicObject array, DynamicObject format, @Cached(value="privatizeByteList(format)") ByteList cachedFormat, @Cached(value="create(compileFormat(format))") DirectCallNode callPackNode) {
            PackResult result;
            try {
                result = (PackResult)callPackNode.call(frame, new Object[]{Layouts.ARRAY.getStore(array), Layouts.ARRAY.getSize(array)});
            }
            catch (PackException e) {
                CompilerDirectives.transferToInterpreter();
                throw this.handleException(e);
            }
            return this.finishPack(cachedFormat, result);
        }

        @Specialization(contains={"packCached"}, guards={"isRubyString(format)"})
        public DynamicObject packUncached(VirtualFrame frame, DynamicObject array, DynamicObject format, @Cached(value="create()") IndirectCallNode callPackNode) {
            PackResult result;
            try {
                result = (PackResult)callPackNode.call(frame, this.compileFormat(format), new Object[]{Layouts.ARRAY.getStore(array), Layouts.ARRAY.getSize(array)});
            }
            catch (PackException e) {
                CompilerDirectives.transferToInterpreter();
                throw this.handleException(e);
            }
            return this.finishPack(Layouts.STRING.getByteList(format), result);
        }

        private RuntimeException handleException(PackException exception) {
            try {
                throw exception;
            }
            catch (TooFewArgumentsException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("too few arguments", this));
            }
            catch (NoImplicitConversionException e) {
                return new RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(e.getObject(), e.getTarget(), this));
            }
            catch (OutsideOfStringException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("X outside of string", this));
            }
            catch (CantCompressNegativeException e) {
                return new RaiseException(this.getContext().getCoreLibrary().argumentError("can't compress negative numbers", this));
            }
            catch (RangeException e) {
                return new RaiseException(this.getContext().getCoreLibrary().rangeError(e.getMessage(), (Node)this));
            }
            catch (CantConvertException e) {
                return new RaiseException(this.getContext().getCoreLibrary().typeError(e.getMessage(), this));
            }
        }

        private DynamicObject finishPack(ByteList format, PackResult result) {
            DynamicObject string = Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new ByteList(result.getOutput(), 0, result.getOutputLength()), 0, null);
            if (format.length() == 0) {
                StringOperations.forceEncoding(string, (Encoding)USASCIIEncoding.INSTANCE);
            } else {
                switch (result.getEncoding()) {
                    case DEFAULT: 
                    case ASCII_8BIT: {
                        break;
                    }
                    case US_ASCII: {
                        StringOperations.forceEncoding(string, (Encoding)USASCIIEncoding.INSTANCE);
                        break;
                    }
                    case UTF_8: {
                        StringOperations.forceEncoding(string, (Encoding)UTF8Encoding.INSTANCE);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            if (result.isTainted()) {
                if (this.taintNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.taintNode = (TaintNode)this.insert(TaintNodeGen.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
                }
                this.taintNode.executeTaint(string);
            }
            return string;
        }

        @Specialization
        public Object pack(VirtualFrame frame, DynamicObject array, boolean format) {
            return this.ruby(frame, "raise TypeError", new Object[0]);
        }

        @Specialization
        public Object pack(VirtualFrame frame, DynamicObject array, int format) {
            return this.ruby(frame, "raise TypeError", new Object[0]);
        }

        @Specialization
        public Object pack(VirtualFrame frame, DynamicObject array, long format) {
            return this.ruby(frame, "raise TypeError", new Object[0]);
        }

        @Specialization(guards={"isNil(format)"})
        public Object packNil(VirtualFrame frame, DynamicObject array, Object format) {
            return this.ruby(frame, "raise TypeError", new Object[0]);
        }

        @Specialization(guards={"!isRubyString(format)", "!isBoolean(format)", "!isInteger(format)", "!isLong(format)", "!isNil(format)"})
        public Object pack(VirtualFrame frame, DynamicObject array, Object format) {
            return this.ruby(frame, "pack(format.to_str)", "format", format);
        }

        @CompilerDirectives.TruffleBoundary
        protected CallTarget compileFormat(DynamicObject format) {
            assert (RubyGuards.isRubyString(format));
            try {
                return new PackParser(this.getContext()).parse(format.toString(), false);
            }
            catch (FormatException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError(e.getMessage(), this));
            }
        }
    }

    public static class MinBlock {
        private final FrameDescriptor frameDescriptor;
        private final FrameSlot frameSlot;
        private final SharedMethodInfo sharedMethodInfo;
        private final CallTarget callTarget;

        public MinBlock(RubyContext context) {
            CoreSourceSection sourceSection = new CoreSourceSection("Array", "min");
            this.frameDescriptor = new FrameDescriptor();
            this.frameSlot = this.frameDescriptor.addFrameSlot((Object)"minimum_memo");
            this.sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, null, Arity.NO_ARGUMENTS, "min", false, null, false);
            this.callTarget = Truffle.getRuntime().createCallTarget((RootNode)new RubyRootNode(context, (SourceSection)sourceSection, null, this.sharedMethodInfo, ArrayNodesFactory.MinBlockNodeFactory.create(context, (SourceSection)sourceSection, new RubyNode[]{new ReadDeclarationVariableNode(context, (SourceSection)sourceSection, 1, this.frameSlot), new ReadPreArgumentNode(context, (SourceSection)sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR)})));
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        public SharedMethodInfo getSharedMethodInfo() {
            return this.sharedMethodInfo;
        }

        public CallTarget getCallTarget() {
            return this.callTarget;
        }
    }

    public static abstract class MinBlockNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode compareNode;

        public MinBlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public DynamicObject min(VirtualFrame frame, Object minimumObject, Object value) {
            Memo minimum = (Memo)minimumObject;
            Object current = minimum.get();
            if (current == null || (Integer)this.compareNode.call(frame, value, "<=>", null, current) < 0) {
                minimum.set(value);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"min"})
    public static abstract class MinNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eachNode;
        private final MinBlock minBlock;

        public MinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eachNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.minBlock = context.getCoreLibrary().getArrayMinBlock();
        }

        @Specialization
        public Object min(VirtualFrame frame, DynamicObject array) {
            Memo minimum = new Memo();
            VirtualFrame minimumClosureFrame = Truffle.getRuntime().createVirtualFrame(RubyArguments.pack(null, null, array, null, new Object[0]), this.minBlock.getFrameDescriptor());
            minimumClosureFrame.setObject(this.minBlock.getFrameSlot(), (Object)minimum);
            DynamicObject block = ProcNodes.createRubyProc(this.getContext().getCoreLibrary().getProcFactory(), ProcNodes.Type.PROC, this.minBlock.getSharedMethodInfo(), this.minBlock.getCallTarget(), this.minBlock.getCallTarget(), minimumClosureFrame.materialize(), null, (Object)array, null);
            this.eachNode.call(frame, array, "each", block, new Object[0]);
            if (minimum.get() == null) {
                return this.nil();
            }
            return minimum.get();
        }
    }

    public static class MaxBlock {
        private final FrameDescriptor frameDescriptor;
        private final FrameSlot frameSlot;
        private final SharedMethodInfo sharedMethodInfo;
        private final CallTarget callTarget;

        public MaxBlock(RubyContext context) {
            CoreSourceSection sourceSection = new CoreSourceSection("Array", "max");
            this.frameDescriptor = new FrameDescriptor();
            this.frameSlot = this.frameDescriptor.addFrameSlot((Object)"maximum_memo");
            this.sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, null, Arity.NO_ARGUMENTS, "max", false, null, false);
            this.callTarget = Truffle.getRuntime().createCallTarget((RootNode)new RubyRootNode(context, (SourceSection)sourceSection, null, this.sharedMethodInfo, ArrayNodesFactory.MaxBlockNodeFactory.create(context, (SourceSection)sourceSection, new RubyNode[]{new ReadDeclarationVariableNode(context, (SourceSection)sourceSection, 1, this.frameSlot), new ReadPreArgumentNode(context, (SourceSection)sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR)})));
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        public SharedMethodInfo getSharedMethodInfo() {
            return this.sharedMethodInfo;
        }

        public CallTarget getCallTarget() {
            return this.callTarget;
        }
    }

    public static abstract class MaxBlockNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode compareNode;

        public MaxBlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public DynamicObject max(VirtualFrame frame, Object maximumObject, Object value) {
            Memo maximum = (Memo)maximumObject;
            Object current = maximum.get();
            if (current == null || (Integer)this.compareNode.call(frame, value, "<=>", null, current) > 0) {
                maximum.set(value);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"max"})
    public static abstract class MaxNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eachNode;
        private final MaxBlock maxBlock;

        public MaxNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eachNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.maxBlock = context.getCoreLibrary().getArrayMaxBlock();
        }

        @Specialization
        public Object max(VirtualFrame frame, DynamicObject array) {
            Memo maximum = new Memo();
            VirtualFrame maximumClosureFrame = Truffle.getRuntime().createVirtualFrame(RubyArguments.pack(null, null, array, null, new Object[0]), this.maxBlock.getFrameDescriptor());
            maximumClosureFrame.setObject(this.maxBlock.getFrameSlot(), (Object)maximum);
            DynamicObject block = ProcNodes.createRubyProc(this.getContext().getCoreLibrary().getProcFactory(), ProcNodes.Type.PROC, this.maxBlock.getSharedMethodInfo(), this.maxBlock.getCallTarget(), this.maxBlock.getCallTarget(), maximumClosureFrame.materialize(), null, (Object)array, null);
            this.eachNode.call(frame, array, "each", block, new Object[0]);
            if (maximum.get() == null) {
                return this.nil();
            }
            return maximum.get();
        }
    }

    @CoreMethod(names={"map!", "collect!"}, needsBlock=true, returnsEnumeratorIfNoBlock=true, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class MapInPlaceNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayWriteDenormalizedNode writeNode;

        public MapInPlaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)", "isRubyProc(block)"})
        public DynamicObject mapInPlaceNull(DynamicObject array, DynamicObject block) {
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)", "isRubyProc(block)"})
        public Object mapInPlaceFixnumInteger(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.writeNode.executeWrite(frame, array, n, this.yield(frame, block, store[n]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)", "isRubyProc(block)"})
        public Object mapInPlaceObject(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.writeNode.executeWrite(frame, array, n, this.yield(frame, block, store[n]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }
    }

    @CoreMethod(names={"map", "collect"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class MapNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public MapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        @Specialization(guards={"isNullArray(array)", "isRubyProc(block)"})
        public DynamicObject mapNull(DynamicObject array, DynamicObject block) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)", "isRubyProc(block)"})
        public Object mapIntegerFixnum(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            int arraySize = Layouts.ARRAY.getSize(array);
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    mappedStore = this.arrayBuilder.appendValue(mappedStore, n, this.yield(frame, block, store[n]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongArray(array)", "isRubyProc(block)"})
        public Object mapLongFixnum(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            int arraySize = Layouts.ARRAY.getSize(array);
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    mappedStore = this.arrayBuilder.appendValue(mappedStore, n, this.yield(frame, block, store[n]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isDoubleArray(array)", "isRubyProc(block)"})
        public Object mapFloat(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            int arraySize = Layouts.ARRAY.getSize(array);
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    mappedStore = this.arrayBuilder.appendValue(mappedStore, n, this.yield(frame, block, store[n]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)", "isRubyProc(block)"})
        public Object mapObject(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            int arraySize = Layouts.ARRAY.getSize(array);
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    mappedStore = this.arrayBuilder.appendValue(mappedStore, n, this.yield(frame, block, store[n]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }
    }

    @CoreMethod(names={"insert"}, raiseIfFrozenSelf=true, rest=true, required=1, optional=1)
    public static abstract class InsertNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;

        public InsertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object insertMissingValue(VirtualFrame frame, DynamicObject array, Object idx, NotProvided value, Object[] values) {
            return array;
        }

        @Specialization(guards={"isNullArray(array)", "wasProvided(value)", "values.length == 0"})
        public Object insertNull(DynamicObject array, int idx, Object value, Object[] values) {
            CompilerDirectives.transferToInterpreter();
            int index = this.normalizeInsertIndex(array, idx);
            Object[] store = new Object[index + 1];
            Arrays.fill(store, this.nil());
            store[index] = value;
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, index + 1);
            return array;
        }

        @Specialization(guards={"isIntArray(array)", "values.length == 0", "idx >= 0", "isIndexSmallerThanSize(idx,array)", "hasRoomForOneExtra(array)"})
        public Object insert(VirtualFrame frame, DynamicObject array, int idx, int value, Object[] values) {
            int index = idx;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            System.arraycopy(store, index, store, index + 1, Layouts.ARRAY.getSize(array) - index);
            store[index] = value;
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) + 1);
            return array;
        }

        @Specialization
        public Object insertBoxed(VirtualFrame frame, DynamicObject array, Object idxObject, Object unusedValue, Object[] unusedRest) {
            Object[] values = RubyArguments.extractUserArgumentsFrom(frame.getArguments(), 1);
            int idx = this.toInt(frame, idxObject);
            CompilerDirectives.transferToInterpreter();
            int index = this.normalizeInsertIndex(array, idx);
            int oldSize = Layouts.ARRAY.getSize(array);
            int newSize = (index < oldSize ? oldSize : index) + values.length;
            Object[] store = ArrayUtils.boxExtra(Layouts.ARRAY.getStore(array), newSize - oldSize);
            if (index >= oldSize) {
                Arrays.fill(store, oldSize, index, this.nil());
            } else {
                int dest = index + values.length;
                int len = oldSize - index;
                System.arraycopy(store, index, store, dest, len);
            }
            System.arraycopy(values, 0, store, index, values.length);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, newSize);
            return array;
        }

        private int normalizeInsertIndex(DynamicObject array, int index) {
            int normalizedIndex = InsertNode.normalizeInsertIndex(Layouts.ARRAY.getSize(array), index);
            if (normalizedIndex < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "index " + index + " too small for array; minimum: " + Integer.toString(-Layouts.ARRAY.getSize(array));
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            return normalizedIndex;
        }

        private static int normalizeInsertIndex(int length, int index) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (index < 0 ? 1 : 0) != 0)) {
                return length + index + 1;
            }
            return index;
        }

        protected static boolean isIndexSmallerThanSize(int idx, DynamicObject array) {
            return idx <= Layouts.ARRAY.getSize(array);
        }

        protected static boolean hasRoomForOneExtra(DynamicObject array) {
            return ((int[])Layouts.ARRAY.getStore(array)).length > Layouts.ARRAY.getSize(array);
        }

        private int toInt(VirtualFrame frame, Object indexObject) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.toIntNode.doInt(frame, indexObject);
        }
    }

    @CoreMethod(names={"inject", "reduce"}, needsBlock=true, optional=2)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class InjectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode dispatch;

        public InjectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.CALL_METHOD_MISSING);
        }

        @Specialization(guards={"isEmptyArray(array)", "wasProvided(initial)", "isRubyProc(block)"})
        public Object injectEmptyArray(VirtualFrame frame, DynamicObject array, Object initial, NotProvided unused, DynamicObject block) {
            return initial;
        }

        @Specialization(guards={"isEmptyArray(array)", "isRubyProc(block)"})
        public Object injectEmptyArrayNoInitial(VirtualFrame frame, DynamicObject array, NotProvided initial, NotProvided unused, DynamicObject block) {
            return this.nil();
        }

        @Specialization(guards={"isIntArray(array)", "!isEmptyArray(array)", "wasProvided(initial)", "isRubyProc(block)"})
        public Object injectIntegerFixnum(VirtualFrame frame, DynamicObject array, Object initial, NotProvided unused, DynamicObject block) {
            return this.injectHelper(frame, ArrayReflector.reflect((int[])Layouts.ARRAY.getStore(array)), array, initial, block, 0);
        }

        @Specialization(guards={"isIntArray(array)", "!isEmptyArray(array)", "isRubyProc(block)"})
        public Object injectIntegerFixnumNoInitial(VirtualFrame frame, DynamicObject array, NotProvided initial, NotProvided unused, DynamicObject block) {
            IntegerArrayMirror mirror = ArrayReflector.reflect((int[])Layouts.ARRAY.getStore(array));
            return this.injectHelper(frame, mirror, array, mirror.get(0), block, 1);
        }

        @Specialization(guards={"isLongArray(array)", "!isEmptyArray(array)", "wasProvided(initial)", "isRubyProc(block)"})
        public Object injectLongFixnum(VirtualFrame frame, DynamicObject array, Object initial, NotProvided unused, DynamicObject block) {
            return this.injectHelper(frame, ArrayReflector.reflect((long[])Layouts.ARRAY.getStore(array)), array, initial, block, 0);
        }

        @Specialization(guards={"isLongArray(array)", "!isEmptyArray(array)", "isRubyProc(block)"})
        public Object injectLongFixnumNoInitial(VirtualFrame frame, DynamicObject array, NotProvided initial, NotProvided unused, DynamicObject block) {
            LongArrayMirror mirror = ArrayReflector.reflect((long[])Layouts.ARRAY.getStore(array));
            return this.injectHelper(frame, mirror, array, mirror.get(0), block, 1);
        }

        @Specialization(guards={"isDoubleArray(array)", "!isEmptyArray(array)", "wasProvided(initial)", "isRubyProc(block)"})
        public Object injectFloat(VirtualFrame frame, DynamicObject array, Object initial, NotProvided unused, DynamicObject block) {
            return this.injectHelper(frame, ArrayReflector.reflect((double[])Layouts.ARRAY.getStore(array)), array, initial, block, 0);
        }

        @Specialization(guards={"isDoubleArray(array)", "!isEmptyArray(array)", "isRubyProc(block)"})
        public Object injectFloatNoInitial(VirtualFrame frame, DynamicObject array, NotProvided initial, NotProvided unused, DynamicObject block) {
            DoubleArrayMirror mirror = ArrayReflector.reflect((double[])Layouts.ARRAY.getStore(array));
            return this.injectHelper(frame, mirror, array, mirror.get(0), block, 1);
        }

        @Specialization(guards={"isObjectArray(array)", "!isEmptyArray(array)", "wasProvided(initial)", "isRubyProc(block)"})
        public Object injectObject(VirtualFrame frame, DynamicObject array, Object initial, NotProvided unused, DynamicObject block) {
            return this.injectHelper(frame, ArrayReflector.reflect((Object[])Layouts.ARRAY.getStore(array)), array, initial, block, 0);
        }

        @Specialization(guards={"isObjectArray(array)", "!isEmptyArray(array)", "isRubyProc(block)"})
        public Object injectObjectNoInitial(VirtualFrame frame, DynamicObject array, NotProvided initial, NotProvided unused, DynamicObject block) {
            ObjectArrayMirror mirror = ArrayReflector.reflect((Object[])Layouts.ARRAY.getStore(array));
            return this.injectHelper(frame, mirror, array, mirror.get(0), block, 1);
        }

        @Specialization(guards={"isNullArray(array)", "wasProvided(initial)", "isRubyProc(block)"})
        public Object injectNull(VirtualFrame frame, DynamicObject array, Object initial, NotProvided unused, DynamicObject block) {
            return initial;
        }

        @Specialization(guards={"isNullArray(array)", "isRubyProc(block)"})
        public Object injectNullNoInitial(VirtualFrame frame, DynamicObject array, NotProvided initial, NotProvided unused, DynamicObject block) {
            return this.nil();
        }

        @Specialization(guards={"isRubySymbol(symbol)", "isEmptyArray(array)", "wasProvided(initial)"})
        public Object injectSymbolEmptyArray(VirtualFrame frame, DynamicObject array, Object initial, DynamicObject symbol, NotProvided block) {
            return initial;
        }

        @Specialization(guards={"isRubySymbol(symbol)", "isEmptyArray(array)"})
        public Object injectSymbolEmptyArray(VirtualFrame frame, DynamicObject array, DynamicObject symbol, NotProvided unused, NotProvided block) {
            return this.nil();
        }

        @Specialization(guards={"isRubySymbol(symbol)", "isIntArray(array)", "!isEmptyArray(array)", "wasProvided(initial)"})
        public Object injectSymbolIntArray(VirtualFrame frame, DynamicObject array, Object initial, DynamicObject symbol, NotProvided block) {
            return this.injectSymbolHelper(frame, ArrayReflector.reflect((int[])Layouts.ARRAY.getStore(array)), array, initial, symbol, 0);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "isIntArray(array)", "!isEmptyArray(array)"})
        public Object injectSymbolIntArray(VirtualFrame frame, DynamicObject array, DynamicObject symbol, NotProvided unused, NotProvided block) {
            IntegerArrayMirror mirror = ArrayReflector.reflect((int[])Layouts.ARRAY.getStore(array));
            return this.injectSymbolHelper(frame, mirror, array, mirror.get(0), symbol, 1);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "isLongArray(array)", "!isEmptyArray(array)", "wasProvided(initial)"})
        public Object injectSymbolLongArray(VirtualFrame frame, DynamicObject array, Object initial, DynamicObject symbol, NotProvided block) {
            return this.injectSymbolHelper(frame, ArrayReflector.reflect((long[])Layouts.ARRAY.getStore(array)), array, initial, symbol, 0);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "isLongArray(array)", "!isEmptyArray(array)"})
        public Object injectSymbolLongArray(VirtualFrame frame, DynamicObject array, DynamicObject symbol, NotProvided unused, NotProvided block) {
            LongArrayMirror mirror = ArrayReflector.reflect((long[])Layouts.ARRAY.getStore(array));
            return this.injectSymbolHelper(frame, mirror, array, mirror.get(0), symbol, 1);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "isDoubleArray(array)", "!isEmptyArray(array)", "wasProvided(initial)"})
        public Object injectSymbolDoubleArray(VirtualFrame frame, DynamicObject array, Object initial, DynamicObject symbol, NotProvided block) {
            return this.injectSymbolHelper(frame, ArrayReflector.reflect((double[])Layouts.ARRAY.getStore(array)), array, initial, symbol, 0);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "isDoubleArray(array)", "!isEmptyArray(array)"})
        public Object injectSymbolDoubleArray(VirtualFrame frame, DynamicObject array, DynamicObject symbol, NotProvided unused, NotProvided block) {
            DoubleArrayMirror mirror = ArrayReflector.reflect((double[])Layouts.ARRAY.getStore(array));
            return this.injectSymbolHelper(frame, mirror, array, mirror.get(0), symbol, 1);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "isObjectArray(array)", "!isEmptyArray(array)", "wasProvided(initial)"})
        public Object injectSymbolObjectArray(VirtualFrame frame, DynamicObject array, Object initial, DynamicObject symbol, NotProvided block) {
            return this.injectSymbolHelper(frame, ArrayReflector.reflect((Object[])Layouts.ARRAY.getStore(array)), array, initial, symbol, 0);
        }

        @Specialization(guards={"isRubySymbol(symbol)", "isObjectArray(array)", "!isEmptyArray(array)"})
        public Object injectSymbolObjectArray(VirtualFrame frame, DynamicObject array, DynamicObject symbol, NotProvided unused, NotProvided block) {
            ObjectArrayMirror mirror = ArrayReflector.reflect((Object[])Layouts.ARRAY.getStore(array));
            return this.injectSymbolHelper(frame, mirror, array, mirror.get(0), symbol, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object injectHelper(VirtualFrame frame, ArrayMirror mirror, DynamicObject array, Object initial, DynamicObject block, int startIndex) {
            assert (RubyGuards.isRubyProc(block));
            int count = 0;
            Object accumulator = initial;
            try {
                for (int n = startIndex; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    accumulator = this.yield(frame, block, accumulator, mirror.get(n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return accumulator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object injectSymbolHelper(VirtualFrame frame, ArrayMirror mirror, DynamicObject array, Object initial, DynamicObject symbol, int startIndex) {
            int count = 0;
            Object accumulator = initial;
            try {
                for (int n = startIndex; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    accumulator = this.dispatch.call(frame, accumulator, symbol, null, mirror.get(n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return accumulator;
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="self"), @NodeChild(type=RubyNode.class, value="from")})
    public static abstract class InitializeCopyNode
    extends CoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"from"})
        public RubyNode coerceOtherToAry(RubyNode other) {
            return ToAryNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isRubyArray(from)", "isNullArray(from)"})
        public DynamicObject initializeCopyNull(DynamicObject self, DynamicObject from) {
            if (self == from) {
                return self;
            }
            Layouts.ARRAY.setStore(self, null);
            Layouts.ARRAY.setSize(self, 0);
            return self;
        }

        @Specialization(guards={"isRubyArray(from)", "isIntArray(from)"})
        public DynamicObject initializeCopyIntegerFixnum(DynamicObject self, DynamicObject from) {
            if (self == from) {
                return self;
            }
            Layouts.ARRAY.setStore(self, Arrays.copyOf((int[])Layouts.ARRAY.getStore(from), Layouts.ARRAY.getSize(from)));
            Layouts.ARRAY.setSize(self, Layouts.ARRAY.getSize(from));
            return self;
        }

        @Specialization(guards={"isRubyArray(from)", "isLongArray(from)"})
        public DynamicObject initializeCopyLongFixnum(DynamicObject self, DynamicObject from) {
            if (self == from) {
                return self;
            }
            Layouts.ARRAY.setStore(self, Arrays.copyOf((long[])Layouts.ARRAY.getStore(from), Layouts.ARRAY.getSize(from)));
            Layouts.ARRAY.setSize(self, Layouts.ARRAY.getSize(from));
            return self;
        }

        @Specialization(guards={"isRubyArray(from)", "isDoubleArray(from)"})
        public DynamicObject initializeCopyFloat(DynamicObject self, DynamicObject from) {
            if (self == from) {
                return self;
            }
            Layouts.ARRAY.setStore(self, Arrays.copyOf((double[])Layouts.ARRAY.getStore(from), Layouts.ARRAY.getSize(from)));
            Layouts.ARRAY.setSize(self, Layouts.ARRAY.getSize(from));
            return self;
        }

        @Specialization(guards={"isRubyArray(from)", "isObjectArray(from)"})
        public DynamicObject initializeCopyObject(DynamicObject self, DynamicObject from) {
            if (self == from) {
                return self;
            }
            Layouts.ARRAY.setStore(self, Arrays.copyOf((Object[])Layouts.ARRAY.getStore(from), Layouts.ARRAY.getSize(from)));
            Layouts.ARRAY.setSize(self, Layouts.ARRAY.getSize(from));
            return self;
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, optional=2, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class InitializeNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private CallDispatchHeadNode toAryNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToToAryNode;
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        @Specialization(guards={"!isInteger(object)", "!isLong(object)", "wasProvided(object)", "!isRubyArray(object)"})
        public DynamicObject initialize(VirtualFrame frame, DynamicObject array, Object object, NotProvided defaultValue, NotProvided block) {
            int size;
            DynamicObject copy = null;
            if (this.respondToToAryNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToToAryNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToToAryNode.doesRespondToString(frame, object, Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"to_ary", (Encoding)UTF8Encoding.INSTANCE), 16, null), true)) {
                Object toAryResult;
                if (this.toAryNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.toAryNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
                }
                if (RubyGuards.isRubyArray(toAryResult = this.toAryNode.call(frame, object, "to_ary", null, new Object[0]))) {
                    copy = (DynamicObject)toAryResult;
                }
            }
            if (copy != null) {
                return this.initialize(array, copy, NotProvided.INSTANCE, NotProvided.INSTANCE);
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((size = this.toIntNode.doInt(frame, object)) < 0) {
                return this.initializeNegative(array, size, NotProvided.INSTANCE, NotProvided.INSTANCE);
            }
            return this.initialize(array, size, NotProvided.INSTANCE, NotProvided.INSTANCE);
        }

        @Specialization
        public DynamicObject initialize(DynamicObject array, NotProvided size, NotProvided defaultValue, NotProvided block) {
            return this.initialize(array, 0, this.nil(), block);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public DynamicObject initialize(DynamicObject array, NotProvided size, NotProvided defaultValue, DynamicObject block) {
            return this.initialize(array, 0, this.nil(), NotProvided.INSTANCE);
        }

        @Specialization(guards={"size >= 0"})
        public DynamicObject initialize(DynamicObject array, int size, NotProvided defaultValue, NotProvided block) {
            return this.initialize(array, size, this.nil(), block);
        }

        @Specialization(guards={"size < 0"})
        public DynamicObject initializeNegative(DynamicObject array, int size, NotProvided defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"size >= 0"})
        public DynamicObject initialize(DynamicObject array, long size, NotProvided defaultValue, NotProvided block) {
            if (size > Integer.MAX_VALUE) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("array size too big", this));
            }
            return this.initialize(array, (int)size, this.nil(), block);
        }

        @Specialization(guards={"size < 0"})
        public DynamicObject initializeNegative(DynamicObject array, long size, NotProvided defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"size >= 0"})
        public DynamicObject initialize(DynamicObject array, int size, int defaultValue, NotProvided block) {
            int[] store = new int[size];
            Arrays.fill(store, defaultValue);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, size);
            return array;
        }

        @Specialization(guards={"size < 0"})
        public DynamicObject initializeNegative(DynamicObject array, int size, int defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"size >= 0"})
        public DynamicObject initialize(DynamicObject array, int size, long defaultValue, NotProvided block) {
            long[] store = new long[size];
            Arrays.fill(store, defaultValue);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, size);
            return array;
        }

        @Specialization(guards={"size < 0"})
        public DynamicObject initializeNegative(DynamicObject array, int size, long defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"size >= 0"})
        public DynamicObject initialize(DynamicObject array, int size, double defaultValue, NotProvided block) {
            double[] store = new double[size];
            Arrays.fill(store, defaultValue);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, size);
            return array;
        }

        @Specialization(guards={"size < 0"})
        public DynamicObject initializeNegative(DynamicObject array, int size, double defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"wasProvided(defaultValue)", "size >= 0"})
        public DynamicObject initialize(DynamicObject array, int size, Object defaultValue, NotProvided block) {
            Object[] store = new Object[size];
            Arrays.fill(store, defaultValue);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, size);
            return array;
        }

        @Specialization(guards={"wasProvided(defaultValue)", "size < 0"})
        public DynamicObject initializeNegative(DynamicObject array, int size, Object defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"wasProvided(sizeObject)", "!isInteger(sizeObject)", "wasProvided(defaultValue)"})
        public DynamicObject initialize(VirtualFrame frame, DynamicObject array, Object sizeObject, Object defaultValue, NotProvided block) {
            int size;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((size = this.toIntNode.doInt(frame, sizeObject)) < 0) {
                return this.initializeNegative(array, size, defaultValue, NotProvided.INSTANCE);
            }
            return this.initialize(array, size, defaultValue, NotProvided.INSTANCE);
        }

        @Specialization(guards={"wasProvided(defaultValue)", "size >= 0", "isRubyProc(block)"})
        public Object initialize(VirtualFrame frame, DynamicObject array, int size, Object defaultValue, DynamicObject block) {
            return this.initialize(frame, array, size, NotProvided.INSTANCE, block);
        }

        @Specialization(guards={"wasProvided(defaultValue)", "size < 0", "isRubyProc(block)"})
        public Object initializeNegative(VirtualFrame frame, DynamicObject array, int size, Object defaultValue, DynamicObject block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"size >= 0", "isRubyProc(block)"})
        public Object initialize(VirtualFrame frame, DynamicObject array, int size, NotProvided defaultValue, DynamicObject block) {
            int n;
            Object store = this.arrayBuilder.start(size);
            int count = 0;
            try {
                for (n = 0; n < size; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    store = this.arrayBuilder.appendValue(store, n, this.yield(frame, block, n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
                Layouts.ARRAY.setStore(array, this.arrayBuilder.finish(store, n));
                Layouts.ARRAY.setSize(array, n);
            }
            return array;
        }

        @Specialization(guards={"size < 0", "isRubyProc(block)"})
        public Object initializeNegative(VirtualFrame frame, DynamicObject array, int size, NotProvided defaultValue, DynamicObject block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"isRubyArray(copy)"})
        public DynamicObject initialize(DynamicObject array, DynamicObject copy, NotProvided defaultValue, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            Layouts.ARRAY.setStore(array, ArrayOperations.toObjectArray(copy));
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(copy));
            return array;
        }

        @Specialization(guards={"isRubyArray(copy)", "isRubyProc(block)"})
        public DynamicObject initialize(DynamicObject array, DynamicObject copy, NotProvided defaultValue, DynamicObject block) {
            CompilerDirectives.transferToInterpreter();
            Layouts.ARRAY.setStore(array, ArrayOperations.toObjectArray(copy));
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(copy));
            return array;
        }
    }

    @CoreMethod(names={"include?"}, required=1)
    public static abstract class IncludeNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.SameOrEqualNode equalNode;

        public IncludeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        @Specialization(guards={"isNullArray(array)"})
        public boolean includeNull(VirtualFrame frame, DynamicObject array, Object value) {
            return false;
        }

        @Specialization(guards={"isIntArray(array)"})
        public boolean includeIntegerFixnum(VirtualFrame frame, DynamicObject array, Object value) {
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                Integer stored = store[n];
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isLongArray(array)"})
        public boolean includeLongFixnum(VirtualFrame frame, DynamicObject array, Object value) {
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                Long stored = store[n];
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isDoubleArray(array)"})
        public boolean includeFloat(VirtualFrame frame, DynamicObject array, Object value) {
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                Double stored = store[n];
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public boolean includeObject(VirtualFrame frame, DynamicObject array, Object value) {
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                Object stored = store[n];
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"each_with_index"}, needsBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class EachWithIndexNode
    extends YieldingCoreMethodNode {
        public EachWithIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isNullArray(array)", "isRubyProc(block)"})
        public DynamicObject eachWithEmpty(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)", "isRubyProc(block)"})
        public Object eachWithIndexInt(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, store[n], n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongArray(array)", "isRubyProc(block)"})
        public Object eachWithIndexLong(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, store[n], n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isDoubleArray(array)", "isRubyProc(block)"})
        public Object eachWithIndexDouble(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, store[n], n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)", "isRubyProc(block)"})
        public Object eachWithIndexObject(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, store[n], n);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        @Specialization
        public Object eachWithIndexObject(VirtualFrame frame, DynamicObject array, NotProvided block) {
            return this.ruby(frame, "to_enum(:each_with_index)", new Object[0]);
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true)
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toEnumNode;
        private final DynamicObject eachSymbol = this.getSymbol("each");

        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object eachEnumerator(VirtualFrame frame, DynamicObject array, NotProvided block) {
            if (this.toEnumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toEnumNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.toEnumNode.call(frame, array, "to_enum", null, this.eachSymbol);
        }

        @Specialization(guards={"isNullArray(array)", "isRubyProc(block)"})
        public Object eachNull(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            return this.nil();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntArray(array)", "isRubyProc(block)"})
        public Object eachIntegerFixnum(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongArray(array)", "isRubyProc(block)"})
        public Object eachLongFixnum(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isDoubleArray(array)", "isRubyProc(block)"})
        public Object eachFloat(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObjectArray(array)", "isRubyProc(block)"})
        public Object eachObject(VirtualFrame frame, DynamicObject array, DynamicObject block) {
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            int count = 0;
            try {
                for (int n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.yield(frame, block, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }
    }

    @CoreMethod(names={"delete_at"}, required=1, raiseIfFrozenSelf=true, lowerFixnumParameters={0})
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="index")})
    public static abstract class DeleteAtNode
    extends CoreMethodNode {
        private final BranchProfile tooSmallBranch = BranchProfile.create();
        private final BranchProfile beyondEndBranch = BranchProfile.create();

        public DeleteAtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceOtherToInt(RubyNode index) {
            return ToIntNodeGen.create(this.getContext(), this.getSourceSection(), index);
        }

        @Specialization(guards={"isIntArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public int deleteAtIntegerFixnumInBounds(DynamicObject array, int index) throws UnexpectedResultException {
            int normalizedIndex = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), index);
            if (normalizedIndex < 0) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            if (normalizedIndex >= Layouts.ARRAY.getSize(array)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            int value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, Layouts.ARRAY.getSize(array) - normalizedIndex - 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"deleteAtIntegerFixnumInBounds"}, guards={"isIntArray(array)"})
        public Object deleteAtIntegerFixnum(DynamicObject array, int index) {
            CompilerDirectives.transferToInterpreter();
            int normalizedIndex = index;
            if (normalizedIndex < 0) {
                normalizedIndex = Layouts.ARRAY.getSize(array) + index;
            }
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                return this.nil();
            }
            if (normalizedIndex >= Layouts.ARRAY.getSize(array)) {
                this.beyondEndBranch.enter();
                return this.nil();
            }
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            int value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, Layouts.ARRAY.getSize(array) - normalizedIndex - 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isLongArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public long deleteAtLongFixnumInBounds(DynamicObject array, int index) throws UnexpectedResultException {
            int normalizedIndex = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), index);
            if (normalizedIndex < 0) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            if (normalizedIndex >= Layouts.ARRAY.getSize(array)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            long value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, Layouts.ARRAY.getSize(array) - normalizedIndex - 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"deleteAtLongFixnumInBounds"}, guards={"isLongArray(array)"})
        public Object deleteAtLongFixnum(DynamicObject array, int index) {
            CompilerDirectives.transferToInterpreter();
            int normalizedIndex = index;
            if (normalizedIndex < 0) {
                normalizedIndex = Layouts.ARRAY.getSize(array) + index;
            }
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                return this.nil();
            }
            if (normalizedIndex >= Layouts.ARRAY.getSize(array)) {
                this.beyondEndBranch.enter();
                return this.nil();
            }
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            long value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, Layouts.ARRAY.getSize(array) - normalizedIndex - 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isDoubleArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public double deleteAtFloatInBounds(DynamicObject array, int index) throws UnexpectedResultException {
            int normalizedIndex = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), index);
            if (normalizedIndex < 0) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            if (normalizedIndex >= Layouts.ARRAY.getSize(array)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            double value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, Layouts.ARRAY.getSize(array) - normalizedIndex - 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"deleteAtFloatInBounds"}, guards={"isDoubleArray(array)"})
        public Object deleteAtFloat(DynamicObject array, int index) {
            CompilerDirectives.transferToInterpreter();
            int normalizedIndex = index;
            if (normalizedIndex < 0) {
                normalizedIndex = Layouts.ARRAY.getSize(array) + index;
            }
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                return this.nil();
            }
            if (normalizedIndex >= Layouts.ARRAY.getSize(array)) {
                this.beyondEndBranch.enter();
                return this.nil();
            }
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            double value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, Layouts.ARRAY.getSize(array) - normalizedIndex - 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isObjectArray(array)"}, rewriteOn={UnexpectedResultException.class})
        public Object deleteAtObjectInBounds(DynamicObject array, int index) throws UnexpectedResultException {
            int normalizedIndex = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), index);
            if (normalizedIndex < 0) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            if (normalizedIndex >= Layouts.ARRAY.getSize(array)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            Object value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, Layouts.ARRAY.getSize(array) - normalizedIndex - 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(contains={"deleteAtObjectInBounds"}, guards={"isObjectArray(array)"})
        public Object deleteAtObject(DynamicObject array, int index) {
            CompilerDirectives.transferToInterpreter();
            int normalizedIndex = index;
            if (normalizedIndex < 0) {
                normalizedIndex = Layouts.ARRAY.getSize(array) + index;
            }
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                return this.nil();
            }
            if (normalizedIndex >= Layouts.ARRAY.getSize(array)) {
                this.beyondEndBranch.enter();
                return this.nil();
            }
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            Object value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, Layouts.ARRAY.getSize(array) - normalizedIndex - 1);
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(array) - 1);
            return value;
        }

        @Specialization(guards={"isEmptyArray(array)"})
        public Object deleteAtNullOrEmpty(DynamicObject array, int index) {
            return this.nil();
        }
    }

    @CoreMethod(names={"delete"}, required=1)
    public static abstract class DeleteNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.SameOrEqualNode equalNode;
        @Node.Child
        private IsFrozenNode isFrozenNode;

        public DeleteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        @Specialization(guards={"isIntArray(array)"})
        public Object deleteIntegerFixnum(VirtualFrame frame, DynamicObject array, Object value) {
            int n;
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            Object found = this.nil();
            int i = 0;
            for (n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                Integer stored = store[n];
                if (this.equalNode.executeSameOrEqual(frame, stored, value)) {
                    if (this.isFrozenNode == null) {
                        CompilerDirectives.transferToInterpreter();
                        this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
                    }
                    if (this.isFrozenNode.executeIsFrozen(array)) {
                        CompilerDirectives.transferToInterpreter();
                        throw new RaiseException(this.getContext().getCoreLibrary().frozenError(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(array)).getName(), this));
                    }
                    found = store[n];
                    continue;
                }
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                Layouts.ARRAY.setStore(array, store);
                Layouts.ARRAY.setSize(array, i);
            }
            return found;
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object deleteObject(VirtualFrame frame, DynamicObject array, Object value) {
            int n;
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            Object found = this.nil();
            int i = 0;
            for (n = 0; n < Layouts.ARRAY.getSize(array); ++n) {
                Object stored = store[n];
                if (this.equalNode.executeSameOrEqual(frame, stored, value)) {
                    if (this.isFrozenNode == null) {
                        CompilerDirectives.transferToInterpreter();
                        this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
                    }
                    if (this.isFrozenNode.executeIsFrozen(array)) {
                        CompilerDirectives.transferToInterpreter();
                        throw new RaiseException(this.getContext().getCoreLibrary().frozenError(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(array)).getName(), this));
                    }
                    found = store[n];
                    continue;
                }
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                Layouts.ARRAY.setStore(array, store);
                Layouts.ARRAY.setSize(array, i);
            }
            return found;
        }

        @Specialization(guards={"isNullArray(array)"})
        public Object deleteNull(VirtualFrame frame, DynamicObject array, Object value) {
            return this.nil();
        }
    }

    @CoreMethod(names={"concat"}, required=1, raiseIfFrozenSelf=true)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="other")})
    public static abstract class ConcatNode
    extends CoreMethodNode {
        @Node.Child
        private AppendManyNode appendManyNode;

        public ConcatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.appendManyNode = AppendManyNodeGen.create(context, sourceSection, null, null, null);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToAry(RubyNode other) {
            return ToAryNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isRubyArray(other)", "isNullArray(other)"})
        public DynamicObject concatNull(DynamicObject array, DynamicObject other) {
            return array;
        }

        @Specialization(guards={"isRubyArray(other)", "!isNullArray(other)"})
        public DynamicObject concat(DynamicObject array, DynamicObject other) {
            this.appendManyNode.executeAppendMany(array, Layouts.ARRAY.getSize(other), Layouts.ARRAY.getStore(other));
            return array;
        }
    }

    @CoreMethod(names={"compact!"}, raiseIfFrozenSelf=true)
    public static abstract class CompactBangNode
    extends ArrayCoreMethodNode {
        public CompactBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isObjectArray(array)"})
        public DynamicObject compactNotObjects(DynamicObject array) {
            return this.nil();
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object compactObjects(DynamicObject array) {
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            int size = Layouts.ARRAY.getSize(array);
            int m = 0;
            for (int n = 0; n < size; ++n) {
                if (store[n] == this.nil()) continue;
                store[m] = store[n];
                ++m;
            }
            Layouts.ARRAY.setStore(array, store);
            Layouts.ARRAY.setSize(array, m);
            if (m == size) {
                return this.nil();
            }
            return array;
        }
    }

    @CoreMethod(names={"compact"})
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class CompactNode
    extends ArrayCoreMethodNode {
        public CompactNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isIntArray(array)"})
        public DynamicObject compactInt(DynamicObject array) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOf((int[])Layouts.ARRAY.getStore(array), Layouts.ARRAY.getSize(array)), Layouts.ARRAY.getSize(array));
        }

        @Specialization(guards={"isLongArray(array)"})
        public DynamicObject compactLong(DynamicObject array) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOf((long[])Layouts.ARRAY.getStore(array), Layouts.ARRAY.getSize(array)), Layouts.ARRAY.getSize(array));
        }

        @Specialization(guards={"isDoubleArray(array)"})
        public DynamicObject compactDouble(DynamicObject array) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOf((double[])Layouts.ARRAY.getStore(array), Layouts.ARRAY.getSize(array)), Layouts.ARRAY.getSize(array));
        }

        @Specialization(guards={"isObjectArray(array)"})
        public Object compactObjects(DynamicObject array) {
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            Object[] newStore = new Object[store.length];
            int size = Layouts.ARRAY.getSize(array);
            int m = 0;
            for (int n = 0; n < size; ++n) {
                if (store[n] == this.nil()) continue;
                newStore[m] = store[n];
                ++m;
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), newStore, m);
        }

        @Specialization(guards={"isNullArray(array)"})
        public Object compactNull(DynamicObject array) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    public static abstract class ClearNode
    extends ArrayCoreMethodNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyArray(array)"})
        public DynamicObject clear(DynamicObject array) {
            Layouts.ARRAY.setStore(array, Layouts.ARRAY.getStore(array));
            Layouts.ARRAY.setSize(array, 0);
            return array;
        }
    }

    @CoreMethod(names={"at"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="array"), @NodeChild(type=RubyNode.class, value="index")})
    public static abstract class AtNode
    extends CoreMethodNode {
        @Node.Child
        private ArrayReadDenormalizedNode readNode;

        public AtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceOtherToInt(RubyNode index) {
            return FixnumLowerNodeGen.create(this.getContext(), this.getSourceSection(), ToIntNodeGen.create(this.getContext(), this.getSourceSection(), index));
        }

        @Specialization
        public Object at(VirtualFrame frame, DynamicObject array, int index) {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNode = (ArrayReadDenormalizedNode)this.insert(ArrayReadDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.readNode.executeRead(frame, array, index);
        }
    }

    @CoreMethod(names={"[]="}, required=2, optional=1, lowerFixnumParameters={0}, raiseIfFrozenSelf=true)
    public static abstract class IndexSetNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ArrayWriteDenormalizedNode writeNode;
        @Node.Child
        protected ArrayReadSliceDenormalizedNode readSliceNode;
        @Node.Child
        private PopOneNode popOneNode;
        @Node.Child
        private ToIntNode toIntNode;
        private final BranchProfile tooSmallBranch = BranchProfile.create();

        public IndexSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isInteger(indexObject)", "!isIntegerFixnumRange(indexObject)"})
        public Object set(VirtualFrame frame, DynamicObject array, Object indexObject, Object value, NotProvided unused) {
            int index = this.toInt(frame, indexObject);
            return this.set(frame, array, index, value, unused);
        }

        @Specialization
        public Object set(VirtualFrame frame, DynamicObject array, int index, Object value, NotProvided unused) {
            int normalizedIndex = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), index);
            if (normalizedIndex < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "index " + index + " too small for array; minimum: " + Integer.toString(-Layouts.ARRAY.getSize(array));
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            return this.write(frame, array, index, value);
        }

        @Specialization(guards={"!isRubyArray(value)", "wasProvided(value)", "!isInteger(lengthObject)"})
        public Object setObject(VirtualFrame frame, DynamicObject array, int start, Object lengthObject, Object value) {
            int length = this.toInt(frame, lengthObject);
            return this.setObject(frame, array, start, length, value);
        }

        @Specialization(guards={"!isRubyArray(value)", "wasProvided(value)", "!isInteger(startObject)"})
        public Object setObject(VirtualFrame frame, DynamicObject array, Object startObject, int length, Object value) {
            int start = this.toInt(frame, startObject);
            return this.setObject(frame, array, start, length, value);
        }

        @Specialization(guards={"!isRubyArray(value)", "wasProvided(value)", "!isInteger(startObject)", "!isInteger(lengthObject)"})
        public Object setObject(VirtualFrame frame, DynamicObject array, Object startObject, Object lengthObject, Object value) {
            int length = this.toInt(frame, lengthObject);
            int start = this.toInt(frame, startObject);
            return this.setObject(frame, array, start, length, value);
        }

        @Specialization(guards={"!isRubyArray(value)", "wasProvided(value)"})
        public Object setObject(VirtualFrame frame, DynamicObject array, int start, int length, Object value) {
            CompilerDirectives.transferToInterpreter();
            if (length < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "negative length (" + length + ")";
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            int normalizedIndex = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), start);
            if (normalizedIndex < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "index " + start + " too small for array; minimum: " + Integer.toString(-Layouts.ARRAY.getSize(array));
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            int begin = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), start);
            if (begin < Layouts.ARRAY.getSize(array) && length == 1) {
                return this.write(frame, array, begin, value);
            }
            if (Layouts.ARRAY.getSize(array) > begin + length) {
                if (this.readSliceNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.readSliceNode = (ArrayReadSliceDenormalizedNode)this.insert(ArrayReadSliceDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                DynamicObject endValues = (DynamicObject)this.readSliceNode.executeReadSlice(frame, array, begin + length, Layouts.ARRAY.getSize(array) - begin - length);
                this.write(frame, array, begin, value);
                Object[] endValuesStore = ArrayUtils.box(Layouts.ARRAY.getStore(endValues));
                int i = begin + 1;
                for (Object obj : endValuesStore) {
                    this.write(frame, array, i, obj);
                    ++i;
                }
            } else {
                this.write(frame, array, begin, value);
            }
            if (this.popOneNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.popOneNode = (PopOneNode)this.insert(PopOneNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            int popLength = length - 1 < Layouts.ARRAY.getSize(array) ? length - 1 : Layouts.ARRAY.getSize(array) - 1;
            for (int i = 0; i < popLength; ++i) {
                this.popOneNode.executePopOne(array);
            }
            return value;
        }

        @Specialization(guards={"!isInteger(startObject)", "isRubyArray(value)"})
        public Object setOtherArray(VirtualFrame frame, DynamicObject array, Object startObject, int length, DynamicObject value) {
            int start = this.toInt(frame, startObject);
            return this.setOtherArray(frame, array, start, length, value);
        }

        @Specialization(guards={"!isInteger(lengthObject)", "isRubyArray(value)"})
        public Object setOtherArray(VirtualFrame frame, DynamicObject array, int start, Object lengthObject, DynamicObject value) {
            int length = this.toInt(frame, lengthObject);
            return this.setOtherArray(frame, array, start, length, value);
        }

        @Specialization(guards={"!isInteger(startObject)", "!isInteger(lengthObject)", "isRubyArray(value)"})
        public Object setOtherArray(VirtualFrame frame, DynamicObject array, Object startObject, Object lengthObject, DynamicObject value) {
            int start = this.toInt(frame, startObject);
            int length = this.toInt(frame, lengthObject);
            return this.setOtherArray(frame, array, start, length, value);
        }

        @Specialization(guards={"isRubyArray(replacement)"})
        public Object setOtherArray(VirtualFrame frame, DynamicObject array, int start, int length, DynamicObject replacement) {
            CompilerDirectives.transferToInterpreter();
            if (length < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "negative length (" + length + ")";
                throw new RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            int normalizedIndex = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), start);
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexTooSmallError("array", start, Layouts.ARRAY.getSize(array), this));
            }
            int replacementLength = Layouts.ARRAY.getSize(replacement);
            Object[] replacementStore = ArrayOperations.toObjectArray(replacement);
            if (replacementLength == length) {
                for (int i = 0; i < length; ++i) {
                    this.write(frame, array, start + i, replacementStore[i]);
                }
            } else {
                boolean writeLastPart;
                int newLength;
                boolean mustExpandArray;
                int arrayLength = Layouts.ARRAY.getSize(array);
                boolean bl = mustExpandArray = normalizedIndex > arrayLength;
                if (mustExpandArray) {
                    newLength = normalizedIndex + replacementLength;
                    writeLastPart = false;
                } else if (normalizedIndex + length > arrayLength) {
                    newLength = normalizedIndex + replacementLength;
                    writeLastPart = false;
                } else {
                    newLength = arrayLength - length + replacementLength;
                    writeLastPart = true;
                }
                Object[] store = ArrayOperations.toObjectArray(array);
                Object[] newStore = new Object[newLength];
                if (mustExpandArray) {
                    System.arraycopy(store, 0, newStore, 0, arrayLength);
                    int nilPad = normalizedIndex - arrayLength;
                    for (int i = 0; i < nilPad; ++i) {
                        newStore[arrayLength + i] = this.nil();
                    }
                } else {
                    System.arraycopy(store, 0, newStore, 0, normalizedIndex);
                }
                System.arraycopy(replacementStore, 0, newStore, normalizedIndex, replacementLength);
                if (writeLastPart) {
                    System.arraycopy(store, normalizedIndex + length, newStore, normalizedIndex + replacementLength, arrayLength - (normalizedIndex + length));
                }
                Layouts.ARRAY.setStore(array, newStore);
                Layouts.ARRAY.setSize(array, newLength);
            }
            return replacement;
        }

        @Specialization(guards={"!isRubyArray(other)", "isIntegerFixnumRange(range)"})
        public Object setRange(VirtualFrame frame, DynamicObject array, DynamicObject range, Object other, NotProvided unused) {
            int normalizedEnd;
            int normalizedStart = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), Layouts.INTEGER_FIXNUM_RANGE.getBegin(range));
            int n = normalizedEnd = Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), Layouts.INTEGER_FIXNUM_RANGE.getEnd(range)) - 1 : ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), Layouts.INTEGER_FIXNUM_RANGE.getEnd(range));
            if (normalizedEnd < 0) {
                normalizedEnd = -1;
            }
            int length = normalizedEnd - normalizedStart + 1;
            if (normalizedStart < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().rangeError(range, (Node)this));
            }
            return this.setObject(frame, array, normalizedStart, length, other);
        }

        @Specialization(guards={"isRubyArray(other)", "!isIntArray(array) || !isIntArray(other)", "isIntegerFixnumRange(range)"})
        public Object setRangeArray(VirtualFrame frame, DynamicObject array, DynamicObject range, DynamicObject other, NotProvided unused) {
            int normalizedEnd;
            int normalizedStart = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), Layouts.INTEGER_FIXNUM_RANGE.getBegin(range));
            if (normalizedStart < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().rangeError(range, (Node)this));
            }
            int n = normalizedEnd = Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), Layouts.INTEGER_FIXNUM_RANGE.getEnd(range)) - 1 : ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), Layouts.INTEGER_FIXNUM_RANGE.getEnd(range));
            if (normalizedEnd < 0) {
                normalizedEnd = -1;
            }
            int length = normalizedEnd - normalizedStart + 1;
            return this.setOtherArray(frame, array, normalizedStart, length, other);
        }

        @Specialization(guards={"isIntArray(array)", "isRubyArray(other)", "isIntArray(other)", "isIntegerFixnumRange(range)"})
        public Object setIntegerFixnumRange(VirtualFrame frame, DynamicObject array, DynamicObject range, DynamicObject other, NotProvided unused) {
            if (Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range)) {
                CompilerDirectives.transferToInterpreter();
                return this.setRangeArray(frame, array, range, other, unused);
            }
            int normalizedBegin = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), Layouts.INTEGER_FIXNUM_RANGE.getBegin(range));
            int normalizedEnd = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), Layouts.INTEGER_FIXNUM_RANGE.getEnd(range));
            if (normalizedEnd < 0) {
                normalizedEnd = -1;
            }
            if (normalizedBegin != 0 || normalizedEnd != Layouts.ARRAY.getSize(array) - 1) {
                CompilerDirectives.transferToInterpreter();
                return this.setRangeArray(frame, array, range, other, unused);
            }
            Layouts.ARRAY.setStore(array, Arrays.copyOf((int[])Layouts.ARRAY.getStore(other), Layouts.ARRAY.getSize(other)));
            Layouts.ARRAY.setSize(array, Layouts.ARRAY.getSize(other));
            return other;
        }

        private Object write(VirtualFrame frame, DynamicObject array, int index, Object value) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.writeNode.executeWrite(frame, array, index, value);
        }

        private int toInt(VirtualFrame frame, Object indexObject) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.toIntNode.doInt(frame, indexObject);
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnumParameters={0, 1})
    public static abstract class IndexNode
    extends ArrayCoreMethodNode {
        @Node.Child
        protected ArrayReadDenormalizedNode readNode;
        @Node.Child
        protected ArrayReadSliceDenormalizedNode readSliceNode;
        @Node.Child
        protected ArrayReadSliceNormalizedNode readNormalizedSliceNode;
        @Node.Child
        protected CallDispatchHeadNode fallbackNode;
        @Node.Child
        protected AllocateObjectNode allocateObjectNode;

        public IndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public Object index(VirtualFrame frame, DynamicObject array, int index, NotProvided length) {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNode = (ArrayReadDenormalizedNode)this.insert(ArrayReadDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.readNode.executeRead(frame, array, index);
        }

        @Specialization
        public Object slice(VirtualFrame frame, DynamicObject array, int start, int length) {
            if (length < 0) {
                return this.nil();
            }
            if (this.readSliceNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readSliceNode = (ArrayReadSliceDenormalizedNode)this.insert(ArrayReadSliceDenormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.readSliceNode.executeReadSlice(frame, array, start, length);
        }

        @Specialization(guards={"isIntegerFixnumRange(range)"})
        public Object slice(VirtualFrame frame, DynamicObject array, DynamicObject range, NotProvided len) {
            int normalizedIndex = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), Layouts.INTEGER_FIXNUM_RANGE.getBegin(range));
            if (normalizedIndex < 0 || normalizedIndex > Layouts.ARRAY.getSize(array)) {
                return this.nil();
            }
            int end = ArrayOperations.normalizeIndex(Layouts.ARRAY.getSize(array), Layouts.INTEGER_FIXNUM_RANGE.getEnd(range));
            int index = Layouts.INTEGER_FIXNUM_RANGE.getExcludedEnd(range) ? end : end + 1;
            int exclusiveEnd = ArrayOperations.clampExclusiveIndex(Layouts.ARRAY.getSize(array), index);
            if (exclusiveEnd <= normalizedIndex) {
                return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), null, 0);
            }
            int length = exclusiveEnd - normalizedIndex;
            if (this.readNormalizedSliceNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNormalizedSliceNode = (ArrayReadSliceNormalizedNode)this.insert(ArrayReadSliceNormalizedNodeGen.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.readNormalizedSliceNode.executeReadSlice(frame, array, normalizedIndex, length);
        }

        @Specialization(guards={"!isInteger(a)", "!isIntegerFixnumRange(a)"})
        public Object fallbackIndex(VirtualFrame frame, DynamicObject array, Object a, NotProvided length) {
            Object[] objects = new Object[]{a};
            return this.fallback(frame, array, Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length));
        }

        @Specialization(guards={"!isIntegerFixnumRange(a)", "wasProvided(b)"})
        public Object fallbackSlice(VirtualFrame frame, DynamicObject array, Object a, Object b) {
            Object[] objects = new Object[]{a, b};
            return this.fallback(frame, array, Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length));
        }

        public Object fallback(VirtualFrame frame, DynamicObject array, DynamicObject args) {
            if (this.fallbackNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            InternalMethod method = RubyArguments.getMethod(frame.getArguments());
            return this.fallbackNode.call(frame, array, "element_reference_fallback", null, Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)method.getName(), (Encoding)UTF8Encoding.INSTANCE), 0, null), args);
        }
    }

    @CoreMethod(names={"*"}, required=1, lowerFixnumParameters={0}, taintFromSelf=true)
    public static abstract class MulNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.RespondToNode respondToToStrNode;
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization(guards={"isNullArray(array)"})
        public DynamicObject mulEmpty(DynamicObject array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), null, 0);
        }

        @Specialization(guards={"isIntArray(array)"})
        public DynamicObject mulIntegerFixnum(DynamicObject array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            int[] store = (int[])Layouts.ARRAY.getStore(array);
            int storeLength = store.length;
            int newStoreLength = storeLength * count;
            int[] newStore = new int[newStoreLength];
            for (int n = 0; n < count; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), newStore, newStoreLength);
        }

        @Specialization(guards={"isLongArray(array)"})
        public DynamicObject mulLongFixnum(DynamicObject array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            long[] store = (long[])Layouts.ARRAY.getStore(array);
            int storeLength = store.length;
            int newStoreLength = storeLength * count;
            long[] newStore = new long[newStoreLength];
            for (int n = 0; n < count; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), newStore, newStoreLength);
        }

        @Specialization(guards={"isDoubleArray(array)"})
        public DynamicObject mulFloat(DynamicObject array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            double[] store = (double[])Layouts.ARRAY.getStore(array);
            int storeLength = store.length;
            int newStoreLength = storeLength * count;
            double[] newStore = new double[newStoreLength];
            for (int n = 0; n < count; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), newStore, newStoreLength);
        }

        @Specialization(guards={"isObjectArray(array)"})
        public DynamicObject mulObject(DynamicObject array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            Object[] store = (Object[])Layouts.ARRAY.getStore(array);
            int storeLength = store.length;
            int newStoreLength = storeLength * count;
            Object[] newStore = new Object[newStoreLength];
            for (int n = 0; n < count; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(array), newStore, newStoreLength);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object mulObject(VirtualFrame frame, DynamicObject array, DynamicObject string) {
            CompilerDirectives.transferToInterpreter();
            return this.ruby(frame, "join(sep)", "sep", string);
        }

        @Specialization(guards={"!isRubyString(object)"})
        public Object mulObjectCount(VirtualFrame frame, DynamicObject array, Object object) {
            int count;
            CompilerDirectives.transferToInterpreter();
            if (this.respondToToStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToToStrNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            if (this.respondToToStrNode.doesRespondToString(frame, object, Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"to_str", (Encoding)UTF8Encoding.INSTANCE), 16, null), false)) {
                return this.ruby(frame, "join(sep.to_str)", "sep", object);
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((count = this.toIntNode.doInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            if (Layouts.ARRAY.getStore(array) instanceof int[]) {
                return this.mulIntegerFixnum(array, count);
            }
            if (Layouts.ARRAY.getStore(array) instanceof long[]) {
                return this.mulLongFixnum(array, count);
            }
            if (Layouts.ARRAY.getStore(array) instanceof double[]) {
                return this.mulFloat(array, count);
            }
            if (Layouts.ARRAY.getStore(array) == null) {
                return this.mulEmpty(array, count);
            }
            return this.mulObject(array, count);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    @ImportStatic(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="a"), @NodeChild(type=RubyNode.class, value="b")})
    public static abstract class AddNode
    extends CoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"b"})
        public RubyNode coerceOtherToAry(RubyNode other) {
            return ToAryNodeGen.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isNullArray(a)", "isNullArray(b)"})
        public DynamicObject addNull(DynamicObject a, DynamicObject b) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
        }

        @Specialization(guards={"isObjectArray(a)", "isNullArray(b)"})
        public DynamicObject addObjectNull(DynamicObject a, DynamicObject b) {
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOf((Object[])Layouts.ARRAY.getStore(a), Layouts.ARRAY.getSize(a)), Layouts.ARRAY.getSize(a));
        }

        @Specialization(guards={"isIntArray(a)", "isIntArray(b)"})
        public DynamicObject addBothIntegerFixnum(DynamicObject a, DynamicObject b) {
            int combinedSize = Layouts.ARRAY.getSize(a) + Layouts.ARRAY.getSize(b);
            int[] combined = new int[combinedSize];
            System.arraycopy(Layouts.ARRAY.getStore(a), 0, combined, 0, Layouts.ARRAY.getSize(a));
            System.arraycopy(Layouts.ARRAY.getStore(b), 0, combined, Layouts.ARRAY.getSize(a), Layouts.ARRAY.getSize(b));
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), combined, combinedSize);
        }

        @Specialization(guards={"isLongArray(a)", "isLongArray(b)"})
        public DynamicObject addBothLongFixnum(DynamicObject a, DynamicObject b) {
            int combinedSize = Layouts.ARRAY.getSize(a) + Layouts.ARRAY.getSize(b);
            long[] combined = new long[combinedSize];
            System.arraycopy(Layouts.ARRAY.getStore(a), 0, combined, 0, Layouts.ARRAY.getSize(a));
            System.arraycopy(Layouts.ARRAY.getStore(b), 0, combined, Layouts.ARRAY.getSize(a), Layouts.ARRAY.getSize(b));
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), combined, combinedSize);
        }

        @Specialization(guards={"isDoubleArray(a)", "isRubyArray(b)", "isDoubleArray(b)"})
        public DynamicObject addBothFloat(DynamicObject a, DynamicObject b) {
            int combinedSize = Layouts.ARRAY.getSize(a) + Layouts.ARRAY.getSize(b);
            double[] combined = new double[combinedSize];
            System.arraycopy(Layouts.ARRAY.getStore(a), 0, combined, 0, Layouts.ARRAY.getSize(a));
            System.arraycopy(Layouts.ARRAY.getStore(b), 0, combined, Layouts.ARRAY.getSize(a), Layouts.ARRAY.getSize(b));
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), combined, combinedSize);
        }

        @Specialization(guards={"isObjectArray(a)", "isRubyArray(b)", "isObjectArray(b)"})
        public DynamicObject addBothObject(DynamicObject a, DynamicObject b) {
            int combinedSize = Layouts.ARRAY.getSize(a) + Layouts.ARRAY.getSize(b);
            Object[] combined = new Object[combinedSize];
            System.arraycopy(Layouts.ARRAY.getStore(a), 0, combined, 0, Layouts.ARRAY.getSize(a));
            System.arraycopy(Layouts.ARRAY.getStore(b), 0, combined, Layouts.ARRAY.getSize(a), Layouts.ARRAY.getSize(b));
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), combined, combinedSize);
        }

        @Specialization(guards={"isNullArray(a)", "isRubyArray(b)", "isIntArray(b)"})
        public DynamicObject addNullIntegerFixnum(DynamicObject a, DynamicObject b) {
            int size = Layouts.ARRAY.getSize(b);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOf((int[])Layouts.ARRAY.getStore(b), size), size);
        }

        @Specialization(guards={"isNullArray(a)", "isRubyArray(b)", "isLongArray(b)"})
        public DynamicObject addNullLongFixnum(DynamicObject a, DynamicObject b) {
            int size = Layouts.ARRAY.getSize(b);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOf((long[])Layouts.ARRAY.getStore(b), size), size);
        }

        @Specialization(guards={"isNullArray(a)", "isRubyArray(b)", "isObjectArray(b)"})
        public DynamicObject addNullObject(DynamicObject a, DynamicObject b) {
            int size = Layouts.ARRAY.getSize(b);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), Arrays.copyOf((Object[])Layouts.ARRAY.getStore(b), size), size);
        }

        @Specialization(guards={"!isObjectArray(a)", "isRubyArray(b)", "isObjectArray(b)"})
        public DynamicObject addOtherObject(DynamicObject a, DynamicObject b) {
            int combinedSize = Layouts.ARRAY.getSize(a) + Layouts.ARRAY.getSize(b);
            Object[] combined = new Object[combinedSize];
            System.arraycopy(ArrayUtils.box(Layouts.ARRAY.getStore(a)), 0, combined, 0, Layouts.ARRAY.getSize(a));
            System.arraycopy(Layouts.ARRAY.getStore(b), 0, combined, Layouts.ARRAY.getSize(a), Layouts.ARRAY.getSize(b));
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), combined, combinedSize);
        }

        @Specialization(guards={"isObjectArray(a)", "isRubyArray(b)", "!isObjectArray(b)"})
        public DynamicObject addObject(DynamicObject a, DynamicObject b) {
            int combinedSize = Layouts.ARRAY.getSize(a) + Layouts.ARRAY.getSize(b);
            Object[] combined = new Object[combinedSize];
            System.arraycopy(Layouts.ARRAY.getStore(a), 0, combined, 0, Layouts.ARRAY.getSize(a));
            System.arraycopy(ArrayUtils.box(Layouts.ARRAY.getStore(b)), 0, combined, Layouts.ARRAY.getSize(a), Layouts.ARRAY.getSize(b));
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), combined, combinedSize);
        }

        @Specialization(guards={"isEmptyArray(a)", "isRubyArray(b)"})
        public DynamicObject addEmpty(DynamicObject a, DynamicObject b) {
            int size = Layouts.ARRAY.getSize(b);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), ArrayUtils.box(Layouts.ARRAY.getStore(b)), size);
        }

        @Specialization(guards={"isEmptyArray(b)", "isRubyArray(b)"})
        public DynamicObject addOtherEmpty(DynamicObject a, DynamicObject b) {
            int size = Layouts.ARRAY.getSize(a);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), ArrayUtils.box(Layouts.ARRAY.getStore(a)), size);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateNode.allocate(rubyClass, null, 0);
        }
    }
}

