/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.Syntax;
import org.joni.exception.SyntaxException;
import org.joni.exception.ValueException;
import org.jruby.Ruby;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RegexpSupport;
import org.jruby.util.StringSupport;

@CoreClass(name="Regexp")
public abstract class RegexpNodes {
    @CompilerDirectives.TruffleBoundary
    public static DynamicObject makeString(DynamicObject source, int start, int length) {
        assert (RubyGuards.isRubyString(source));
        ByteList bytes = new ByteList(Layouts.STRING.getByteList(source), start, length);
        DynamicObject ret = Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.BASIC_OBJECT.getLogicalClass(source)), bytes, 0, null);
        Layouts.STRING.setCodeRange(ret, Layouts.STRING.getCodeRange(source));
        return ret;
    }

    public static void setFrame(Frame frame, String name, Object value) {
        assert (value != null);
        while (frame != null) {
            FrameSlot slot = frame.getFrameDescriptor().findFrameSlot((Object)name);
            if (slot != null) {
                frame.setObject(slot, value);
                break;
            }
            frame = RubyArguments.getDeclarationFrame(frame.getArguments());
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Object matchCommon(DynamicObject regexp, DynamicObject source, boolean operator, boolean setNamedCaptures) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(source));
        return RegexpNodes.matchCommon(regexp, source, operator, setNamedCaptures, 0);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object matchCommon(DynamicObject regexp, DynamicObject source, boolean operator, boolean setNamedCaptures, int startPos) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(source));
        byte[] stringBytes = Layouts.STRING.getByteList(source).bytes();
        ByteList bl = Layouts.REGEXP.getSource(regexp);
        Encoding enc = RegexpNodes.checkEncoding(regexp, StringOperations.getCodeRangeable(source), true);
        ByteList preprocessed = RegexpSupport.preprocess((Ruby)Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext().getRuntime(), (ByteList)bl, (Encoding)enc, (Encoding[])new Encoding[]{null}, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
        Regex r = new Regex(preprocessed.getUnsafeBytes(), preprocessed.getBegin(), preprocessed.getBegin() + preprocessed.getRealSize(), Layouts.REGEXP.getOptions(regexp).toJoniOptions(), RegexpNodes.checkEncoding(regexp, StringOperations.getCodeRangeable(source), true));
        Matcher matcher = r.matcher(stringBytes);
        int range = stringBytes.length;
        return RegexpNodes.matchCommon(regexp, source, operator, setNamedCaptures, matcher, startPos, range);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object matchCommon(DynamicObject regexp, DynamicObject source, boolean operator, boolean setNamedCaptures, Matcher matcher, int startPos, int range) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(source));
        ByteList bytes = Layouts.STRING.getByteList(source);
        RubyContext context = Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext();
        Frame frame = RubyCallStack.getCallerFrame(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext()).getFrame(FrameInstance.FrameAccess.READ_WRITE, false);
        int match = matcher.search(startPos, range, 0);
        DynamicObject nil = Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext().getCoreLibrary().getNilObject();
        if (match == -1) {
            RegexpNodes.setThread(regexp, "$~", nil);
            if (setNamedCaptures && Layouts.REGEXP.getRegex(regexp).numberOfNames() > 0) {
                Iterator i = Layouts.REGEXP.getRegex(regexp).namedBackrefIterator();
                while (i.hasNext()) {
                    NameEntry e = (NameEntry)i.next();
                    String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                    RegexpNodes.setFrame(frame, name, Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext().getCoreLibrary().getNilObject());
                }
            }
            return Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext().getCoreLibrary().getNilObject();
        }
        Region region = matcher.getEagerRegion();
        Object[] values = new Object[region.numRegs];
        for (int n = 0; n < region.numRegs; ++n) {
            int start = region.beg[n];
            int end = region.end[n];
            if (operator) {
                DynamicObject groupString = start > -1 && end > -1 ? RegexpNodes.makeString(source, start, end - start) : Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext().getCoreLibrary().getNilObject();
                values[n] = groupString;
                continue;
            }
            values[n] = start == -1 || end == -1 ? Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext().getCoreLibrary().getNilObject() : RegexpNodes.makeString(source, start, end - start);
        }
        DynamicObject pre = RegexpNodes.makeString(source, 0, region.beg[0]);
        DynamicObject post = RegexpNodes.makeString(source, region.end[0], bytes.length() - region.end[0]);
        DynamicObject global = RegexpNodes.makeString(source, region.beg[0], region.end[0] - region.beg[0]);
        DynamicObject matchObject = Layouts.MATCH_DATA.createMatchData(Layouts.CLASS.getInstanceFactory(context.getCoreLibrary().getMatchDataClass()), source, regexp, region, values, pre, post, global, matcher.getBegin(), matcher.getEnd(), false, null, null);
        if (operator && values.length > 0) {
            int nonNil = values.length - 1;
            while (values[nonNil] == Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext().getCoreLibrary().getNilObject()) {
                --nonNil;
            }
        }
        RegexpNodes.setThread(regexp, "$~", matchObject);
        if (setNamedCaptures && Layouts.REGEXP.getRegex(regexp).numberOfNames() > 0) {
            Iterator i = Layouts.REGEXP.getRegex(regexp).namedBackrefIterator();
            while (i.hasNext()) {
                DynamicObject value;
                NameEntry e = (NameEntry)i.next();
                String name = new String(e.name, e.nameP, e.nameEnd - e.nameP, StandardCharsets.UTF_8).intern();
                int nth = Layouts.REGEXP.getRegex(regexp).nameToBackrefNumber(e.name, e.nameP, e.nameEnd, region);
                if (nth >= region.numRegs || nth < 0 && (nth += region.numRegs) <= 0) {
                    value = Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext().getCoreLibrary().getNilObject();
                } else {
                    int start = region.beg[nth];
                    int end = region.end[nth];
                    value = start != -1 ? RegexpNodes.makeString(source, start, end - start) : Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext().getCoreLibrary().getNilObject();
                }
                RegexpNodes.setFrame(frame, name, value);
            }
        }
        if (operator) {
            return matcher.getBegin();
        }
        return matchObject;
    }

    public static void setThread(DynamicObject regexp, String name, Object value) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (value != null);
        Layouts.THREAD.getThreadLocals(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext().getThreadManager().getCurrentThread()).define((Object)name, value, 0);
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject gsub(DynamicObject regexp, DynamicObject string, String replacement) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(string));
        RubyContext context = Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext();
        byte[] stringBytes = Layouts.STRING.getByteList(string).bytes();
        Encoding encoding = Layouts.STRING.getByteList(string).getEncoding();
        Matcher matcher = Layouts.REGEXP.getRegex(regexp).matcher(stringBytes);
        int p = Layouts.STRING.getByteList(string).getBegin();
        int end = 0;
        int range = p + Layouts.STRING.getByteList(string).getRealSize();
        int lastMatchEnd = 0;
        int matchedStringIndex = 0;
        StringBuilder builder = new StringBuilder();
        while (true) {
            Object matchData;
            if ((matchData = RegexpNodes.matchCommon(regexp, string, false, false, matcher, p + end, range)) == context.getCoreLibrary().getNilObject()) break;
            Region region = matcher.getEagerRegion();
            int regionStart = region.beg[matchedStringIndex];
            int regionEnd = region.end[matchedStringIndex];
            builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, lastMatchEnd, regionStart - lastMatchEnd)));
            builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(replacement.getBytes(StandardCharsets.UTF_8))));
            lastMatchEnd = regionEnd;
            end = StringSupport.positionEndForScan((ByteList)Layouts.STRING.getByteList(string), (Matcher)matcher, (Encoding)encoding, (int)p, (int)range);
        }
        builder.append(StandardCharsets.UTF_8.decode(ByteBuffer.wrap(stringBytes, lastMatchEnd, range - lastMatchEnd)));
        return Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(context.getCoreLibrary().getStringClass()), RubyString.encodeBytelist((CharSequence)builder.toString(), (Encoding)UTF8Encoding.INSTANCE), 0, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @CompilerDirectives.TruffleBoundary
    public static DynamicObject[] split(DynamicObject regexp, DynamicObject string, boolean useLimit, int limit) {
        assert (RubyGuards.isRubyRegexp(regexp));
        assert (RubyGuards.isRubyString(string));
        RubyContext context = Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext();
        ByteList bytes = Layouts.STRING.getByteList(string);
        byte[] byteArray = bytes.bytes();
        int begin = bytes.getBegin();
        int len = bytes.getRealSize();
        int range = begin + len;
        Encoding encoding = Layouts.STRING.getByteList(string).getEncoding();
        Matcher matcher = Layouts.REGEXP.getRegex(regexp).matcher(byteArray);
        ArrayList<DynamicObject> strings = new ArrayList<DynamicObject>();
        int beg = 0;
        int i = 1;
        boolean lastNull = false;
        int start = begin;
        if (useLimit && limit == 1) {
            strings.add(string);
        } else {
            int end;
            while ((end = matcher.search(start, range, 0)) >= 0) {
                block12: {
                    if (start == end + begin && matcher.getBegin() == matcher.getEnd()) {
                        if (len == 0) {
                            strings.add(Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(context.getCoreLibrary().getStringClass()), RubyString.encodeBytelist((CharSequence)"", (Encoding)UTF8Encoding.INSTANCE), 0, null));
                            break;
                        }
                        if (lastNull) {
                            int substringLength = StringSupport.length((Encoding)encoding, (byte[])byteArray, (int)(begin + beg), (int)range);
                            strings.add(Layouts.STRING.createString(context.getCoreLibrary().getStringFactory(), bytes.makeShared(beg, substringLength).dup(), 0, null));
                            beg = start - begin;
                            break block12;
                        } else {
                            start += start == range ? 1 : StringSupport.length((Encoding)encoding, (byte[])byteArray, (int)start, (int)range);
                            lastNull = true;
                            continue;
                        }
                    }
                    strings.add(Layouts.STRING.createString(context.getCoreLibrary().getStringFactory(), bytes.makeShared(beg, end - beg).dup(), 0, null));
                    beg = matcher.getEnd();
                    start = begin + beg;
                }
                lastNull = false;
                if (!useLimit || limit > ++i) continue;
            }
            if (len > 0 && (useLimit || len > beg || limit < 0)) {
                strings.add(Layouts.STRING.createString(context.getCoreLibrary().getStringFactory(), bytes.makeShared(beg, len - beg).dup(), 0, null));
            }
        }
        if (!useLimit && limit == 0) {
            while (!strings.isEmpty() && StringOperations.length((DynamicObject)strings.get(strings.size() - 1)) == 0) {
                strings.remove(strings.size() - 1);
            }
        }
        return strings.toArray(new DynamicObject[strings.size()]);
    }

    @CompilerDirectives.TruffleBoundary
    public static Regex compile(Node currentNode, RubyContext context, ByteList bytes, RegexpOptions options) {
        try {
            Encoding enc = bytes.getEncoding();
            Encoding[] fixedEnc = new Encoding[]{null};
            ByteList unescaped = RegexpSupport.preprocess((Ruby)context.getRuntime(), (ByteList)bytes, (Encoding)enc, (Encoding[])fixedEnc, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
            if (fixedEnc[0] != null) {
                if (fixedEnc[0] != enc && options.isFixed() || fixedEnc[0] != ASCIIEncoding.INSTANCE && options.isEncodingNone()) {
                    RegexpSupport.raiseRegexpError19((Ruby)context.getRuntime(), (ByteList)bytes, (Encoding)enc, (RegexpOptions)options, (String)"incompatible character encoding");
                }
                if (fixedEnc[0] != ASCIIEncoding.INSTANCE) {
                    options.setFixed(true);
                    enc = fixedEnc[0];
                }
            } else if (!options.isFixed()) {
                enc = USASCIIEncoding.INSTANCE;
            }
            if (fixedEnc[0] != null) {
                options.setFixed(true);
            }
            bytes.setEncoding(enc);
            Regex ret = new Regex(unescaped.getUnsafeBytes(), unescaped.getBegin(), unescaped.getBegin() + unescaped.getRealSize(), options.toJoniOptions(), enc, Syntax.RUBY);
            ret.setUserObject((Object)bytes);
            return ret;
        }
        catch (ValueException e) {
            throw new RaiseException(context.getCoreLibrary().runtimeError("error compiling regex", currentNode));
        }
        catch (SyntaxException e) {
            throw new RaiseException(context.getCoreLibrary().regexpError(e.getMessage(), currentNode));
        }
    }

    public static Object getCachedNames(DynamicObject regexp) {
        return Layouts.REGEXP.getCachedNames(regexp);
    }

    public static void setCachedNames(DynamicObject regexp, Object cachedNames) {
        Layouts.REGEXP.setCachedNames(regexp, cachedNames);
    }

    public static void setRegex(DynamicObject regexp, Regex regex) {
        Layouts.REGEXP.setRegex(regexp, regex);
    }

    public static void setSource(DynamicObject regexp, ByteList source) {
        Layouts.REGEXP.setSource(regexp, source);
    }

    public static void setOptions(DynamicObject regexp, RegexpOptions options) {
        Layouts.REGEXP.setOptions(regexp, options);
    }

    public static Encoding checkEncoding(DynamicObject regexp, CodeRangeable str, boolean warn) {
        assert (RubyGuards.isRubyRegexp(regexp));
        Regex pattern = Layouts.REGEXP.getRegex(regexp);
        Encoding enc = str.getByteList().getEncoding();
        if (!enc.isAsciiCompatible()) {
            if (enc != pattern.getEncoding()) {
                // empty if block
            }
        } else if (Layouts.REGEXP.getOptions(regexp).isFixed()) {
            enc = pattern.getEncoding();
        }
        return enc;
    }

    public static void initialize(DynamicObject regexp, Node currentNode, ByteList setSource, int options) {
        assert (RubyGuards.isRubyRegexp(regexp));
        RegexpNodes.setSource(regexp, setSource);
        RegexpNodes.setOptions(regexp, RegexpOptions.fromEmbeddedOptions((int)options));
        RegexpNodes.setRegex(regexp, RegexpNodes.compile(currentNode, Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexp)).getContext(), setSource, Layouts.REGEXP.getOptions(regexp)));
    }

    public static void initialize(DynamicObject regexp, Regex setRegex, ByteList setSource) {
        assert (RubyGuards.isRubyRegexp(regexp));
        RegexpNodes.setRegex(regexp, setRegex);
        RegexpNodes.setSource(regexp, setSource);
    }

    public static DynamicObject createRubyRegexp(Node currentNode, DynamicObject regexpClass, ByteList regex, RegexpOptions options) {
        return Layouts.REGEXP.createRegexp(Layouts.CLASS.getInstanceFactory(regexpClass), RegexpNodes.compile(currentNode, Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexpClass)).getContext(), regex, options), regex, options, null);
    }

    public static DynamicObject createRubyRegexp(Node currentNode, DynamicObject regexpClass, ByteList regex, int options) {
        DynamicObject regexp = Layouts.REGEXP.createRegexp(Layouts.CLASS.getInstanceFactory(regexpClass), null, null, RegexpOptions.NULL_OPTIONS, null);
        RegexpNodes.setOptions(regexp, RegexpOptions.fromEmbeddedOptions((int)options));
        RegexpNodes.initialize(regexp, RegexpNodes.compile(currentNode, Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(regexpClass)).getContext(), regex, Layouts.REGEXP.getOptions(regexp)), regex);
        return regexp;
    }

    public static DynamicObject createRubyRegexp(DynamicObject regexpClass, Regex regex, ByteList source, RegexpOptions options) {
        DynamicObject regexp = Layouts.REGEXP.createRegexp(Layouts.CLASS.getInstanceFactory(regexpClass), null, null, RegexpOptions.NULL_OPTIONS, null);
        RegexpNodes.setOptions(regexp, options);
        RegexpNodes.initialize(regexp, regex, source);
        return regexp;
    }

    public static DynamicObject createRubyRegexp(DynamicObject regexpClass, Regex regex, ByteList source) {
        DynamicObject regexp = Layouts.REGEXP.createRegexp(Layouts.CLASS.getInstanceFactory(regexpClass), null, null, RegexpOptions.NULL_OPTIONS, null);
        RegexpNodes.initialize(regexp, regex, source);
        return regexp;
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return Layouts.REGEXP.createRegexp(Layouts.CLASS.getInstanceFactory(rubyClass), null, null, RegexpOptions.NULL_OPTIONS, null);
        }
    }

    @NodeChild(value="self")
    public static abstract class RubiniusNamesNode
    extends RubyNode {
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;

        public RubiniusNamesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!anyNames(regexp)"})
        public DynamicObject rubiniusNamesNoCaptures(DynamicObject regexp) {
            return this.nil();
        }

        @Specialization(guards={"anyNames(regexp)"})
        public Object rubiniusNames(VirtualFrame frame, DynamicObject regexp) {
            if (RegexpNodes.getCachedNames(regexp) != null) {
                return RegexpNodes.getCachedNames(regexp);
            }
            if (this.newLookupTableNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.newLookupTableNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (this.lookupTableWriteNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.lookupTableWriteNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            Object namesLookupTable = this.newLookupTableNode.call(frame, this.getContext().getCoreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            Iterator i = Layouts.REGEXP.getRegex(regexp).namedBackrefIterator();
            while (i.hasNext()) {
                NameEntry e = (NameEntry)i.next();
                DynamicObject name = this.getSymbol(new ByteList(e.name, e.nameP, e.nameEnd - e.nameP, false));
                int[] backrefs = e.getBackRefs();
                DynamicObject backrefsRubyArray = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), backrefs, backrefs.length);
                this.lookupTableWriteNode.call(frame, namesLookupTable, "[]=", null, name, backrefsRubyArray);
            }
            RegexpNodes.setCachedNames(regexp, namesLookupTable);
            return namesLookupTable;
        }

        public static boolean anyNames(DynamicObject regexp) {
            return Layouts.REGEXP.getRegex(regexp).numberOfNames() > 0;
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject regexp) {
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), ((RubyString)RubyRegexp.newRegexp((Ruby)this.getContext().getRuntime(), (ByteList)Layouts.REGEXP.getSource(regexp), (int)Layouts.REGEXP.getRegex(regexp).getOptions()).to_s()).getByteList(), 0, null);
        }
    }

    @CoreMethod(names={"source"})
    public static abstract class SourceNode
    extends CoreMethodArrayArgumentsNode {
        public SourceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject source(DynamicObject regexp) {
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), Layouts.REGEXP.getSource(regexp).dup(), 0, null);
        }
    }

    @CoreMethod(names={"search_from"}, required=2)
    public static abstract class SearchFromNode
    extends CoreMethodArrayArgumentsNode {
        public SearchFromNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object searchFrom(DynamicObject regexp, DynamicObject string, int startPos) {
            return RegexpNodes.matchCommon(regexp, string, false, false, startPos);
        }
    }

    @CoreMethod(names={"quote", "escape"}, needsSelf=false, onSingleton=true, required=1)
    public static abstract class QuoteNode
    extends CoreMethodArrayArgumentsNode {
        public QuoteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(raw)"})
        public DynamicObject quoteString(DynamicObject raw) {
            boolean isAsciiOnly = Layouts.STRING.getByteList(raw).getEncoding().isAsciiCompatible() && StringOperations.scanForCodeRange(raw) == 16;
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyRegexp.quote19((ByteList)Layouts.STRING.getByteList(raw), (boolean)isAsciiOnly), 0, null);
        }

        @Specialization(guards={"isRubySymbol(raw)"})
        public DynamicObject quoteSymbol(DynamicObject raw) {
            return this.quoteString(Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(raw)).getContext().getCoreLibrary().getStringClass()), RubyString.encodeBytelist((CharSequence)Layouts.SYMBOL.getString(raw), (Encoding)UTF8Encoding.INSTANCE), 0, null));
        }
    }

    @CoreMethod(names={"match_start"}, required=2)
    public static abstract class MatchStartNode
    extends CoreMethodArrayArgumentsNode {
        public MatchStartNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object matchStart(DynamicObject regexp, DynamicObject string, int startPos) {
            Object matchResult = RegexpNodes.matchCommon(regexp, string, false, false, startPos);
            if (RubyGuards.isRubyMatchData(matchResult) && Layouts.MATCH_DATA.getRegion((DynamicObject)((DynamicObject)matchResult)).numRegs > 0 && Layouts.MATCH_DATA.getRegion((DynamicObject)((DynamicObject)matchResult)).beg[0] == startPos) {
                return matchResult;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int hash(DynamicObject regexp) {
            int options = Layouts.REGEXP.getRegex(regexp).getOptions() & 0xFFFFFFDF;
            return options ^ Layouts.REGEXP.getSource(regexp).hashCode();
        }
    }

    @CoreMethod(names={"escape"}, onSingleton=true, required=1)
    public static abstract class EscapeNode
    extends CoreMethodArrayArgumentsNode {
        public EscapeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(pattern)"})
        public DynamicObject escape(DynamicObject pattern) {
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)RubyRegexp.quote19((ByteList)new ByteList(Layouts.STRING.getByteList(pattern)), (boolean)true).toString(), (Encoding)UTF8Encoding.INSTANCE), 0, null);
        }
    }

    @CoreMethod(names={"=~"}, required=1)
    public static abstract class MatchOperatorNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode toSNode;
        @Node.Child
        private ToStrNode toStrNode;

        public MatchOperatorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(string)"})
        public Object match(DynamicObject regexp, DynamicObject string) {
            return RegexpNodes.matchCommon(regexp, string, true, true);
        }

        @Specialization(guards={"isRubySymbol(symbol)"})
        public Object match(VirtualFrame frame, DynamicObject regexp, DynamicObject symbol) {
            if (this.toSNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toSNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.match(regexp, (DynamicObject)this.toSNode.call(frame, symbol, "to_s", null, new Object[0]));
        }

        @Specialization(guards={"isNil(nil)"})
        public Object match(DynamicObject regexp, Object nil) {
            return this.nil();
        }

        @Specialization(guards={"!isRubyString(other)", "!isRubySymbol(other)", "!isNil(other)"})
        public Object matchGeneric(VirtualFrame frame, DynamicObject regexp, DynamicObject other) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.match(regexp, this.toStrNode.executeToStr(frame, other));
        }
    }
}

