/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jruby.RubyEncoding;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;

@CoreClass(name="Encoding")
public abstract class EncodingNodes {
    private static DynamicObject[] encodingList = new DynamicObject[EncodingDB.getEncodings().size()];
    private static Map<String, DynamicObject> lookup = new HashMap<String, DynamicObject>();

    @CompilerDirectives.TruffleBoundary
    public static synchronized DynamicObject getEncoding(Encoding encoding) {
        return lookup.get(new String(encoding.getName(), StandardCharsets.UTF_8).toLowerCase(Locale.ENGLISH));
    }

    @CompilerDirectives.TruffleBoundary
    public static DynamicObject getEncoding(String name) {
        return lookup.get(name.toLowerCase(Locale.ENGLISH));
    }

    public static DynamicObject getEncoding(int index) {
        return encodingList[index];
    }

    @CompilerDirectives.TruffleBoundary
    public static void storeEncoding(int encodingListIndex, DynamicObject encoding) {
        assert (RubyGuards.isRubyEncoding(encoding));
        EncodingNodes.encodingList[encodingListIndex] = encoding;
        lookup.put(Layouts.ENCODING.getName(encoding).toString().toLowerCase(Locale.ENGLISH), encoding);
    }

    @CompilerDirectives.TruffleBoundary
    public static void storeAlias(String aliasName, DynamicObject encoding) {
        assert (RubyGuards.isRubyEncoding(encoding));
        lookup.put(aliasName.toLowerCase(Locale.ENGLISH), encoding);
    }

    public static DynamicObject newEncoding(DynamicObject encodingClass, Encoding encoding, byte[] name, int p, int end, boolean dummy) {
        return EncodingNodes.createRubyEncoding(encodingClass, encoding, new ByteList(name, p, end), dummy);
    }

    public static DynamicObject[] cloneEncodingList() {
        DynamicObject[] clone = new DynamicObject[encodingList.length];
        System.arraycopy(encodingList, 0, clone, 0, encodingList.length);
        return clone;
    }

    public static DynamicObject createRubyEncoding(DynamicObject encodingClass, Encoding encoding, ByteList name, boolean dummy) {
        return Layouts.ENCODING.createEncoding(Layouts.CLASS.getInstanceFactory(encodingClass), encoding, name, dummy);
    }

    @CoreMethod(names={"name", "to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject encoding) {
            ByteList name = Layouts.ENCODING.getName(encoding).dup();
            name.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), name, 0, null);
        }
    }

    @CoreMethod(names={"encoding_map"}, onSingleton=true)
    public static abstract class EncodingMapNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode upcaseNode;
        @Node.Child
        private CallDispatchHeadNode toSymNode;
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;
        @Node.Child
        private CallDispatchHeadNode newTupleNode;

        public EncodingMapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.upcaseNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.toSymNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.newLookupTableNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupTableWriteNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.newTupleNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object encodingMap(VirtualFrame frame) {
            Object ret = this.newLookupTableNode.call(frame, this.getContext().getCoreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            DynamicObject[] encodings = EncodingNodes.cloneEncodingList();
            for (int i = 0; i < encodings.length; ++i) {
                Object upcased = this.upcaseNode.call(frame, Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), Layouts.ENCODING.getName(encodings[i]), 0, null), "upcase", null, new Object[0]);
                Object key = this.toSymNode.call(frame, upcased, "to_sym", null, new Object[0]);
                Object value = this.newTupleNode.call(frame, this.getContext().getCoreLibrary().getTupleClass(), "create", null, this.nil(), i);
                this.lookupTableWriteNode.call(frame, ret, "[]=", null, key, value);
            }
            CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntryIterator i = this.getContext().getRuntime().getEncodingService().getAliases().entryIterator();
            while (i.hasNext()) {
                CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry e = (CaseInsensitiveBytesHash.CaseInsensitiveBytesHashEntry)i.next();
                Object upcased = this.upcaseNode.call(frame, Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new ByteList(e.bytes, e.p, e.end - e.p), 0, null), "upcase", null, new Object[0]);
                Object key = this.toSymNode.call(frame, upcased, "to_sym", null, new Object[0]);
                DynamicObject alias = Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new ByteList(e.bytes, e.p, e.end - e.p), 0, null);
                int index = ((EncodingDB.Entry)e.value).getIndex();
                Object value = this.newTupleNode.call(frame, this.getContext().getCoreLibrary().getTupleClass(), "create", null, alias, index);
                this.lookupTableWriteNode.call(frame, ret, "[]=", null, key, value);
            }
            Encoding defaultInternalEncoding = this.getContext().getRuntime().getDefaultInternalEncoding();
            Object internalTuple = this.getContext().makeTuple(frame, this.newTupleNode, Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"internal", (Encoding)UTF8Encoding.INSTANCE), 0, null), this.indexLookup(encodings, defaultInternalEncoding));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("INTERNAL"), internalTuple);
            Encoding defaultExternalEncoding = this.getContext().getRuntime().getDefaultExternalEncoding();
            Object externalTuple = this.getContext().makeTuple(frame, this.newTupleNode, Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"external", (Encoding)UTF8Encoding.INSTANCE), 0, null), this.indexLookup(encodings, defaultExternalEncoding));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("EXTERNAL"), externalTuple);
            Encoding localeEncoding = this.getLocaleEncoding();
            Object localeTuple = this.getContext().makeTuple(frame, this.newTupleNode, Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"locale", (Encoding)UTF8Encoding.INSTANCE), 0, null), this.indexLookup(encodings, localeEncoding));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("LOCALE"), localeTuple);
            Encoding filesystemEncoding = this.getLocaleEncoding();
            Object filesystemTuple = this.getContext().makeTuple(frame, this.newTupleNode, Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), RubyString.encodeBytelist((CharSequence)"filesystem", (Encoding)UTF8Encoding.INSTANCE), 0, null), this.indexLookup(encodings, filesystemEncoding));
            this.lookupTableWriteNode.call(frame, ret, "[]=", null, this.getSymbol("FILESYSTEM"), filesystemTuple);
            return ret;
        }

        @CompilerDirectives.TruffleBoundary
        private Encoding getLocaleEncoding() {
            return this.getContext().getRuntime().getEncodingService().getLocaleEncoding();
        }

        @CompilerDirectives.TruffleBoundary
        public Object indexLookup(DynamicObject[] encodings, Encoding encoding) {
            if (encoding == null) {
                return this.nil();
            }
            for (int i = 0; i < encodings.length; ++i) {
                if (Layouts.ENCODING.getEncoding(encodings[i]) != encoding) continue;
                return i;
            }
            throw new UnsupportedOperationException(String.format("Could not find encoding %s in the registered encoding list", encoding.toString()));
        }
    }

    @CoreMethod(names={"dummy?"})
    public static abstract class DummyNode
    extends CoreMethodArrayArgumentsNode {
        public DummyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isDummy(DynamicObject encoding) {
            return Layouts.ENCODING.getDummy(encoding);
        }
    }

    @CoreMethod(names={"locale_charmap"}, onSingleton=true)
    public static abstract class LocaleCharacterMapNode
    extends CoreMethodArrayArgumentsNode {
        public LocaleCharacterMapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject localeCharacterMap() {
            CompilerDirectives.transferToInterpreter();
            ByteList name = new ByteList(this.getContext().getRuntime().getEncodingService().getLocaleEncoding().getName());
            return Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), name, 0, null);
        }
    }

    @CoreMethod(names={"list"}, onSingleton=true)
    public static abstract class ListNode
    extends CoreMethodArrayArgumentsNode {
        public ListNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject list() {
            CompilerDirectives.transferToInterpreter();
            DynamicObject[] encodings = EncodingNodes.cloneEncodingList();
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), encodings, encodings.length);
        }
    }

    @CoreMethod(names={"default_internal_jruby="}, onSingleton=true, required=1)
    public static abstract class SetDefaultInternalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        public SetDefaultInternalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject defaultInternal(DynamicObject encoding) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getRuntime().setDefaultInternalEncoding(Layouts.ENCODING.getEncoding(encoding));
            return encoding;
        }

        @Specialization(guards={"isNil(encoding)"})
        public DynamicObject defaultInternal(Object encoding) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getRuntime().setDefaultInternalEncoding(null);
            return this.nil();
        }

        @Specialization(guards={"!isRubyEncoding(encoding)", "!isNil(encoding)"})
        public DynamicObject defaultInternal(VirtualFrame frame, Object encoding) {
            CompilerDirectives.transferToInterpreter();
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            DynamicObject encodingName = this.toStrNode.executeToStr(frame, encoding);
            this.getContext().getRuntime().setDefaultInternalEncoding(Layouts.ENCODING.getEncoding(EncodingNodes.getEncoding(encodingName.toString())));
            return encodingName;
        }
    }

    @CoreMethod(names={"default_external_jruby="}, onSingleton=true, required=1)
    public static abstract class SetDefaultExternalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode;

        public SetDefaultExternalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject defaultExternalEncoding(DynamicObject encoding) {
            CompilerDirectives.transferToInterpreter();
            this.getContext().getRuntime().setDefaultExternalEncoding(Layouts.ENCODING.getEncoding(encoding));
            return encoding;
        }

        @Specialization(guards={"isRubyString(encodingString)"})
        public DynamicObject defaultExternal(DynamicObject encodingString) {
            CompilerDirectives.transferToInterpreter();
            DynamicObject rubyEncoding = EncodingNodes.getEncoding(encodingString.toString());
            this.getContext().getRuntime().setDefaultExternalEncoding(Layouts.ENCODING.getEncoding(rubyEncoding));
            return rubyEncoding;
        }

        @Specialization(guards={"isNil(nil)"})
        public DynamicObject defaultExternal(Object nil) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("default external can not be nil", this));
        }

        @Specialization(guards={"!isRubyEncoding(encoding)", "!isRubyString(encoding)", "!isNil(encoding)"})
        public DynamicObject defaultExternal(VirtualFrame frame, Object encoding) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.defaultExternal(this.toStrNode.executeToStr(frame, encoding));
        }
    }

    @CoreMethod(names={"compatible?"}, needsSelf=false, onSingleton=true, required=2)
    public static abstract class CompatibleQueryNode
    extends CoreMethodArrayArgumentsNode {
        public CompatibleQueryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(first)", "isRubyString(second)"})
        public Object isCompatibleStringString(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((CodeRangeable)StringOperations.getCodeRangeable(first), (CodeRangeable)StringOperations.getCodeRangeable(second));
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyEncoding(first)", "isRubyEncoding(second)"})
        public Object isCompatibleEncodingEncoding(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.ENCODING.getEncoding(first), (Encoding)Layouts.ENCODING.getEncoding(second));
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(first)", "isRubyRegexp(second)"})
        public Object isCompatibleStringRegexp(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.STRING.getByteList(first).getEncoding(), (Encoding)Layouts.REGEXP.getRegex(second).getEncoding());
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyRegexp(first)", "isRubyString(second)"})
        public Object isCompatibleRegexpString(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.REGEXP.getRegex(first).getEncoding(), (Encoding)Layouts.STRING.getByteList(second).getEncoding());
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyRegexp(first)", "isRubyRegexp(second)"})
        public Object isCompatibleRegexpRegexp(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.REGEXP.getRegex(first).getEncoding(), (Encoding)Layouts.REGEXP.getRegex(second).getEncoding());
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyRegexp(first)", "isRubySymbol(second)"})
        public Object isCompatibleRegexpSymbol(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.REGEXP.getRegex(first).getEncoding(), (Encoding)Layouts.SYMBOL.getByteList(second).getEncoding());
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(first)", "isRubyRegexp(second)"})
        public Object isCompatibleSymbolRegexp(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.SYMBOL.getByteList(first).getEncoding(), (Encoding)Layouts.REGEXP.getRegex(second).getEncoding());
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(first)", "isRubySymbol(second)"})
        public Object isCompatibleStringSymbol(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((CodeRangeable)StringOperations.getCodeRangeable(first), (CodeRangeable)SymbolNodes.getCodeRangeable(second));
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubySymbol(first)", "isRubySymbol(second)"})
        public Object isCompatibleSymbolSymbol(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((CodeRangeable)SymbolNodes.getCodeRangeable(first), (CodeRangeable)SymbolNodes.getCodeRangeable(second));
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(first)", "isRubyEncoding(second)"})
        public Object isCompatibleStringEncoding(DynamicObject first, DynamicObject second) {
            Encoding compatibleEncoding = RubyEncoding.areCompatible((Encoding)Layouts.STRING.getByteList(first).getEncoding(), (Encoding)Layouts.ENCODING.getEncoding(second));
            if (compatibleEncoding != null) {
                return EncodingNodes.getEncoding(compatibleEncoding);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"ascii_compatible?"})
    public static abstract class AsciiCompatibleNode
    extends CoreMethodArrayArgumentsNode {
        public AsciiCompatibleNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object isCompatible(DynamicObject encoding) {
            CompilerDirectives.transferToInterpreter();
            return Layouts.ENCODING.getEncoding(encoding).isAsciiCompatible();
        }
    }
}

