/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.transcode.EConv;
import org.jcodings.transcode.TranscoderDB;
import org.jcodings.util.CaseInsensitiveBytesHash;
import org.jcodings.util.Hash;
import org.jruby.Ruby;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;

@CoreClass(name="Encoding::Converter")
public abstract class EncodingConverterNodes {
    public static DynamicObject createEncodingConverter(DynamicObject rubyClass, EConv econv) {
        return Layouts.ENCODING_CONVERTER.createEncodingConverter(Layouts.CLASS.getInstanceFactory(rubyClass), econv);
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return EncodingConverterNodes.createEncodingConverter(rubyClass, null);
        }
    }

    @CoreMethod(names={"transcoding_map"}, onSingleton=true)
    public static abstract class TranscodingMapNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode upcaseNode;
        @Node.Child
        private CallDispatchHeadNode toSymNode;
        @Node.Child
        private CallDispatchHeadNode newLookupTableNode;
        @Node.Child
        private CallDispatchHeadNode lookupTableWriteNode;
        @Node.Child
        private CallDispatchHeadNode newTranscodingNode;

        public TranscodingMapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.upcaseNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.toSymNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.newLookupTableNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.lookupTableWriteNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.newTranscodingNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public Object transcodingMap(VirtualFrame frame) {
            Object ret = this.newLookupTableNode.call(frame, this.getContext().getCoreLibrary().getLookupTableClass(), "new", null, new Object[0]);
            for (CaseInsensitiveBytesHash sourceEntry : TranscoderDB.transcoders) {
                Object key = null;
                Object value = this.newLookupTableNode.call(frame, this.getContext().getCoreLibrary().getLookupTableClass(), "new", null, new Object[0]);
                for (Hash.HashEntry destinationEntry : sourceEntry.entryIterator()) {
                    TranscoderDB.Entry e = (TranscoderDB.Entry)destinationEntry.value;
                    if (key == null) {
                        Object upcased = this.upcaseNode.call(frame, Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new ByteList(e.getSource()), 0, null), "upcase", null, new Object[0]);
                        key = this.toSymNode.call(frame, upcased, "to_sym", null, new Object[0]);
                    }
                    Object upcasedLookupTableKey = this.upcaseNode.call(frame, Layouts.STRING.createString(this.getContext().getCoreLibrary().getStringFactory(), new ByteList(e.getDestination()), 0, null), "upcase", null, new Object[0]);
                    Object lookupTableKey = this.toSymNode.call(frame, upcasedLookupTableKey, "to_sym", null, new Object[0]);
                    Object lookupTableValue = this.newTranscodingNode.call(frame, this.getContext().getCoreLibrary().getTranscodingClass(), "create", null, key, lookupTableKey);
                    this.lookupTableWriteNode.call(frame, value, "[]=", null, lookupTableKey, lookupTableValue);
                }
                this.lookupTableWriteNode.call(frame, ret, "[]=", null, key, value);
            }
            return ret;
        }
    }

    @CoreMethod(names={"initialize_jruby"}, required=2, optional=1, visibility=Visibility.PRIVATE)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject initialize(DynamicObject self, Object source, Object destination, Object unusedOptions) {
            Ruby runtime = this.getContext().getRuntime();
            Encoding[] encs = new Encoding[]{null, null};
            byte[][] encNames = new byte[][]{null, null};
            int[] ecflags = new int[]{0};
            IRubyObject[] ecopts = new IRubyObject[]{runtime.getNil()};
            IRubyObject sourceAsJRubyObj = this.getContext().toJRuby(source);
            IRubyObject destinationAsJRubyObj = this.getContext().toJRuby(destination);
            EncodingUtils.econvArgs((ThreadContext)runtime.getCurrentContext(), (IRubyObject[])new IRubyObject[]{sourceAsJRubyObj, destinationAsJRubyObj}, (byte[][])encNames, (Encoding[])encs, (int[])ecflags, (IRubyObject[])ecopts);
            ecflags[0] = this.rubiniusToJRubyFlags((Integer)self.get((Object)"@options", (Object)Layouts.MODULE.getFields(Layouts.BASIC_OBJECT.getLogicalClass(self)).getContext().getCoreLibrary().getNilObject()));
            EConv econv = EncodingUtils.econvOpenOpts((ThreadContext)runtime.getCurrentContext(), (byte[])encNames[0], (byte[])encNames[1], (int)ecflags[0], (IRubyObject)ecopts[0]);
            if (econv == null) {
                throw new UnsupportedOperationException();
            }
            if (!EncodingUtils.DECORATOR_P((byte[])encNames[0], (byte[])encNames[1])) {
                if (encs[0] == null) {
                    encs[0] = EncodingDB.dummy((byte[])encNames[0]).getEncoding();
                }
                if (encs[1] == null) {
                    encs[1] = EncodingDB.dummy((byte[])encNames[1]).getEncoding();
                }
            }
            econv.sourceEncoding = encs[0];
            econv.destinationEncoding = encs[1];
            Layouts.ENCODING_CONVERTER.setEconv(self, econv);
            return this.nil();
        }

        private int rubiniusToJRubyFlags(int flags) {
            if ((flags & 0x4000) != 0) {
                flags |= 0x30;
            }
            if ((flags & 0x8000) != 0) {
                flags |= 0x30;
            }
            return flags;
        }
    }
}

