/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.constants;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.constants.GetConstantNode;
import org.jruby.truffle.nodes.constants.GetConstantNodeGen;
import org.jruby.truffle.nodes.constants.LookupConstantNode;
import org.jruby.truffle.nodes.constants.LookupConstantNodeGen;
import org.jruby.truffle.nodes.constants.RestartableReadConstantNode;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;

public class ReadConstantNode
extends RubyNode
implements RestartableReadConstantNode {
    @Node.Child
    RubyNode moduleNode;
    @Node.Child
    RubyNode nameNode;
    @Node.Child
    LookupConstantNode lookupConstantNode;
    @Node.Child
    GetConstantNode getConstantNode;

    public ReadConstantNode(RubyContext context, SourceSection sourceSection, boolean ignoreVisibility, RubyNode moduleNode, RubyNode nameNode) {
        super(context, sourceSection);
        this.moduleNode = moduleNode;
        this.nameNode = nameNode;
        this.lookupConstantNode = LookupConstantNodeGen.create(context, sourceSection, ignoreVisibility, null, null);
        this.getConstantNode = GetConstantNodeGen.create(context, sourceSection, this, null, null, null);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object module = this.moduleNode.execute(frame);
        String name = (String)this.nameNode.execute(frame);
        return this.readConstant(frame, module, name);
    }

    @Override
    public Object readConstant(VirtualFrame frame, Object module, String name) {
        RubyConstant constant = this.lookupConstantNode.executeLookupConstant(frame, module, name);
        return this.getConstantNode.executeGetConstant(frame, module, name, constant);
    }
}

