/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.BooleanCastWithDefaultNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;

@GeneratedBy(value=BooleanCastWithDefaultNode.class)
public final class BooleanCastWithDefaultNodeGen
extends BooleanCastWithDefaultNode
implements SpecializedNode {
    @Node.Child
    private RubyNode value_;
    @CompilerDirectives.CompilationFinal
    private Class<?> valueType_;
    @Node.Child
    private BaseNode_ specialization_;

    private BooleanCastWithDefaultNodeGen(RubyContext context, SourceSection sourceSection, boolean defaultValue, RubyNode value) {
        super(context, sourceSection, defaultValue);
        this.value_ = value;
        this.specialization_ = UninitializedNode_.create(this);
    }

    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue, Object valueValue) {
        return this.specialization_.executeBoolean0(frameValue, valueValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        return this.specialization_.executeBoolean1(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    public Node deepCopy() {
        return SpecializationNode.updateRoot((Node)super.deepCopy());
    }

    public static BooleanCastWithDefaultNode create(RubyContext context, SourceSection sourceSection, boolean defaultValue, RubyNode value) {
        return new BooleanCastWithDefaultNodeGen(context, sourceSection, defaultValue, value);
    }

    @GeneratedBy(methodName="doBasicObject(DynamicObject)", value=BooleanCastWithDefaultNode.class)
    private static final class BasicObjectNode_
    extends BaseNode_ {
        BasicObjectNode_(BooleanCastWithDefaultNodeGen root) {
            super(root, 7);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof DynamicObject && !this.root.isNil(valueValue_ = (DynamicObject)valueValue)) {
                return this.root.doBasicObject(valueValue_);
            }
            return this.getNext().executeBoolean0(frameValue, valueValue);
        }

        @Override
        public boolean executeBoolean1(VirtualFrame frameValue) {
            DynamicObject valueValue_;
            try {
                valueValue_ = this.root.value_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean0(frameValue, ex.getResult());
            }
            if (!this.root.isNil(valueValue_)) {
                return this.root.doBasicObject(valueValue_);
            }
            return this.getNext().executeBoolean0(frameValue, valueValue_);
        }

        static BaseNode_ create(BooleanCastWithDefaultNodeGen root) {
            return new BasicObjectNode_(root);
        }
    }

    @GeneratedBy(methodName="doFloat(double)", value=BooleanCastWithDefaultNode.class)
    private static final class FloatNode_
    extends BaseNode_ {
        FloatNode_(BooleanCastWithDefaultNodeGen root) {
            super(root, 6);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean1(frameValue);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue, Object valueValue) {
            if (valueValue instanceof Double) {
                double valueValue_ = (Double)valueValue;
                return this.root.doFloat(valueValue_);
            }
            return this.getNext().executeBoolean0(frameValue, valueValue);
        }

        @Override
        public boolean executeBoolean1(VirtualFrame frameValue) {
            double valueValue_;
            try {
                valueValue_ = this.root.value_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean0(frameValue, ex.getResult());
            }
            return this.root.doFloat(valueValue_);
        }

        static BaseNode_ create(BooleanCastWithDefaultNodeGen root) {
            return new FloatNode_(root);
        }
    }

    @GeneratedBy(methodName="doLongFixnum(long)", value=BooleanCastWithDefaultNode.class)
    private static final class LongFixnumNode_
    extends BaseNode_ {
        private final Class<?> valueImplicitType;

        LongFixnumNode_(BooleanCastWithDefaultNodeGen root, Object valueValue) {
            super(root, 5);
            this.valueImplicitType = RubyTypesGen.getImplicitLongClass(valueValue);
        }

        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.valueImplicitType == ((LongFixnumNode_)other).valueImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean1(frameValue);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue, Object valueValue) {
            if (RubyTypesGen.isImplicitLong(valueValue, this.valueImplicitType)) {
                long valueValue_ = RubyTypesGen.asImplicitLong(valueValue, this.valueImplicitType);
                return this.root.doLongFixnum(valueValue_);
            }
            return this.getNext().executeBoolean0(frameValue, valueValue);
        }

        @Override
        public boolean executeBoolean1(VirtualFrame frameValue) {
            long valueValue_;
            block4: {
                try {
                    if (this.valueImplicitType == Long.TYPE) {
                        valueValue_ = this.root.value_.executeLong(frameValue);
                        break block4;
                    }
                    if (this.valueImplicitType == Integer.TYPE) {
                        valueValue_ = RubyTypes.int2long(this.root.value_.executeInteger(frameValue));
                        break block4;
                    }
                    Object valueValue__ = this.executeValue_((Frame)frameValue);
                    throw new UnexpectedResultException(valueValue__);
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeBoolean0(frameValue, ex.getResult());
                }
            }
            return this.root.doLongFixnum(valueValue_);
        }

        static BaseNode_ create(BooleanCastWithDefaultNodeGen root, Object valueValue) {
            return new LongFixnumNode_(root, valueValue);
        }
    }

    @GeneratedBy(methodName="doIntegerFixnum(int)", value=BooleanCastWithDefaultNode.class)
    private static final class IntegerFixnumNode_
    extends BaseNode_ {
        IntegerFixnumNode_(BooleanCastWithDefaultNodeGen root) {
            super(root, 4);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean1(frameValue);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue, Object valueValue) {
            if (valueValue instanceof Integer) {
                int valueValue_ = (Integer)valueValue;
                return this.root.doIntegerFixnum(valueValue_);
            }
            return this.getNext().executeBoolean0(frameValue, valueValue);
        }

        @Override
        public boolean executeBoolean1(VirtualFrame frameValue) {
            int valueValue_;
            try {
                valueValue_ = this.root.value_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean0(frameValue, ex.getResult());
            }
            return this.root.doIntegerFixnum(valueValue_);
        }

        static BaseNode_ create(BooleanCastWithDefaultNodeGen root) {
            return new IntegerFixnumNode_(root);
        }
    }

    @GeneratedBy(methodName="doNil(Object)", value=BooleanCastWithDefaultNode.class)
    private static final class NilNode_
    extends BaseNode_ {
        NilNode_(BooleanCastWithDefaultNodeGen root) {
            super(root, 3);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue, Object valueValue) {
            if (this.root.isNil(valueValue)) {
                return this.root.doNil(valueValue);
            }
            return this.getNext().executeBoolean0(frameValue, valueValue);
        }

        @Override
        public boolean executeBoolean1(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            if (this.root.isNil(valueValue_)) {
                return this.root.doNil(valueValue_);
            }
            return this.getNext().executeBoolean0(frameValue, valueValue_);
        }

        static BaseNode_ create(BooleanCastWithDefaultNodeGen root) {
            return new NilNode_(root);
        }
    }

    @GeneratedBy(methodName="doBoolean(boolean)", value=BooleanCastWithDefaultNode.class)
    private static final class BooleanNode_
    extends BaseNode_ {
        BooleanNode_(BooleanCastWithDefaultNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean1(frameValue);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue, Object valueValue) {
            if (valueValue instanceof Boolean) {
                boolean valueValue_ = (Boolean)valueValue;
                return this.root.doBoolean(valueValue_);
            }
            return this.getNext().executeBoolean0(frameValue, valueValue);
        }

        @Override
        public boolean executeBoolean1(VirtualFrame frameValue) {
            boolean valueValue_;
            try {
                valueValue_ = this.root.value_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean0(frameValue, ex.getResult());
            }
            return this.root.doBoolean(valueValue_);
        }

        static BaseNode_ create(BooleanCastWithDefaultNodeGen root) {
            return new BooleanNode_(root);
        }
    }

    @GeneratedBy(methodName="doDefault(NotProvided)", value=BooleanCastWithDefaultNode.class)
    private static final class DefaultNode_
    extends BaseNode_ {
        DefaultNode_(BooleanCastWithDefaultNodeGen root) {
            super(root, 1);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue, Object valueValue) {
            if (valueValue instanceof NotProvided) {
                NotProvided valueValue_ = (NotProvided)valueValue;
                return this.root.doDefault(valueValue_);
            }
            return this.getNext().executeBoolean0(frameValue, valueValue);
        }

        @Override
        public boolean executeBoolean1(VirtualFrame frameValue) {
            NotProvided valueValue_;
            try {
                valueValue_ = this.root.value_.executeNotProvided(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeBoolean0(frameValue, ex.getResult());
            }
            return this.root.doDefault(valueValue_);
        }

        static BaseNode_ create(BooleanCastWithDefaultNodeGen root) {
            return new DefaultNode_(root);
        }
    }

    @GeneratedBy(value=BooleanCastWithDefaultNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(BooleanCastWithDefaultNodeGen root) {
            super(root, 0);
        }

        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object valueValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, valueValue));
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue, Object valueValue) {
            return this.getNext().executeBoolean0(frameValue, valueValue);
        }

        @Override
        public boolean executeBoolean1(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            return this.getNext().executeBoolean0(frameValue, valueValue_);
        }

        static BaseNode_ create(BooleanCastWithDefaultNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=BooleanCastWithDefaultNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(BooleanCastWithDefaultNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public boolean executeBoolean0(VirtualFrame frameValue, Object valueValue) {
            return (Boolean)this.uninitialized((Frame)frameValue, valueValue);
        }

        static BaseNode_ create(BooleanCastWithDefaultNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=BooleanCastWithDefaultNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final BooleanCastWithDefaultNodeGen root;

        BaseNode_(BooleanCastWithDefaultNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.value_};
        }

        public final Object acceptAndExecute(Frame frameValue, Object valueValue) {
            return this.executeBoolean0((VirtualFrame)frameValue, valueValue);
        }

        public abstract boolean executeBoolean0(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object valueValue_ = this.executeValue_((Frame)frameValue);
            return this.executeBoolean0(frameValue, valueValue_);
        }

        public boolean executeBoolean1(VirtualFrame frameValue) {
            return (Boolean)this.execute(frameValue);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.executeBoolean1(frameValue);
        }

        protected final SpecializationNode createNext(Frame frameValue, Object valueValue) {
            DynamicObject valueValue_;
            if (valueValue instanceof NotProvided) {
                return DefaultNode_.create(this.root);
            }
            if (valueValue instanceof Boolean) {
                return BooleanNode_.create(this.root);
            }
            if (this.root.isNil(valueValue)) {
                return NilNode_.create(this.root);
            }
            if (valueValue instanceof Integer) {
                return IntegerFixnumNode_.create(this.root);
            }
            if (RubyTypesGen.isImplicitLong(valueValue)) {
                return LongFixnumNode_.create(this.root, valueValue);
            }
            if (valueValue instanceof Double) {
                return FloatNode_.create(this.root);
            }
            if (valueValue instanceof DynamicObject && !this.root.isNil(valueValue_ = (DynamicObject)valueValue)) {
                return BasicObjectNode_.create(this.root);
            }
            return null;
        }

        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeValue_(Frame frameValue) {
            Object object;
            Class valueType_ = this.root.valueType_;
            if (valueType_ == Boolean.TYPE) {
                return this.root.value_.executeBoolean((VirtualFrame)frameValue);
            }
            if (valueType_ == Double.TYPE) {
                return this.root.value_.executeDouble((VirtualFrame)frameValue);
            }
            if (valueType_ == Integer.TYPE) {
                return this.root.value_.executeInteger((VirtualFrame)frameValue);
            }
            if (valueType_ == Long.TYPE) {
                return this.root.value_.executeLong((VirtualFrame)frameValue);
            }
            if (valueType_ != null) return this.root.value_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.value_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.valueType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.valueType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.valueType_ = _type;
            return object;
        }
    }
}

