/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Map;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.methods.Arity;

public class CheckArityNode
extends RubyNode {
    private final Arity arity;
    private final String[] keywords;
    private final boolean keywordsRest;

    public CheckArityNode(RubyContext context, SourceSection sourceSection, Arity arity) {
        this(context, sourceSection, arity, new String[0], false);
    }

    public CheckArityNode(RubyContext context, SourceSection sourceSection, Arity arity, String[] keywords, boolean keywordsRest) {
        super(context, sourceSection);
        this.arity = arity;
        this.keywords = keywords;
        this.keywordsRest = keywordsRest;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        DynamicObject keywordArguments;
        Object[] frameArguments = frame.getArguments();
        int given = RubyArguments.isKwOptimized(frame.getArguments()) ? RubyArguments.getUserArgumentsCount(frame.getArguments()) - this.arity.getKeywordsCount() - 2 : RubyArguments.getUserArgumentsCount(frame.getArguments());
        if (!this.checkArity(frame, given, keywordArguments = this.arity.acceptsKeywords() ? RubyArguments.getUserKeywordsHash(frameArguments, this.arity.getRequired()) : null)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(given, this.arity.getRequired(), this));
        }
        if (!this.keywordsRest && keywordArguments != null) {
            for (Map.Entry<Object, Object> keyValue : HashOperations.iterableKeyValues(keywordArguments)) {
                if (this.keywordAllowed(keyValue.getKey().toString())) continue;
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("unknown keyword: " + keyValue.getKey().toString(), this));
            }
        }
    }

    private boolean checkArity(VirtualFrame frame, int given, DynamicObject keywordArguments) {
        if (keywordArguments != null) {
            --given;
        }
        if (this.arity.getRequired() != 0 && given < this.arity.getRequired()) {
            return false;
        }
        return this.arity.hasRest() || given <= this.arity.getRequired() + this.arity.getOptional();
    }

    private boolean keywordAllowed(String keyword) {
        for (String allowedKeyword : this.keywords) {
            if (!keyword.equals(allowedKeyword)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.executeVoid(frame);
        return this.nil();
    }
}

