/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes;

import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;

public abstract class StringCachingGuards {
    public static ByteList privatizeByteList(DynamicObject string) {
        if (RubyGuards.isRubyString(string)) {
            return Layouts.STRING.getByteList(string).dup();
        }
        return null;
    }

    public static boolean byteListsEqual(DynamicObject string, ByteList byteList) {
        if (RubyGuards.isRubyString(string)) {
            return Layouts.STRING.getByteList(string).equal(byteList);
        }
        return false;
    }
}

