/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.source.SourceSection;
import jnr.ffi.Runtime;
import jnr.ffi.provider.MemoryManager;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyString;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.instrument.RubyWrapperNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.sockets.NativeSockets;
import org.jruby.util.ByteList;

@ImportStatic(value={RubyGuards.class})
@TypeSystemReference(value=RubyTypes.class)
public abstract class RubyNode
extends Node {
    private final RubyContext context;
    private boolean atNewline = false;

    public RubyNode(RubyContext context, SourceSection sourceSection) {
        super(sourceSection);
        assert (context != null);
        this.context = context;
    }

    public abstract Object execute(VirtualFrame var1);

    public Object isDefined(VirtualFrame frame) {
        return Layouts.STRING.createString(Layouts.CLASS.getInstanceFactory(this.getContext().getCoreLibrary().getStringClass()), RubyString.encodeBytelist((CharSequence)"expression", (Encoding)UTF8Encoding.INSTANCE), 16, null);
    }

    public void executeVoid(VirtualFrame frame) {
        this.execute(frame);
    }

    public NotProvided executeNotProvided(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof NotProvided) {
            return (NotProvided)value;
        }
        throw new UnexpectedResultException(value);
    }

    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new UnexpectedResultException(value);
    }

    public int executeInteger(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    public long executeLong(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new UnexpectedResultException(value);
    }

    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new UnexpectedResultException(value);
    }

    public DynamicObject executeDynamicObject(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof DynamicObject) {
            return (DynamicObject)value;
        }
        throw new UnexpectedResultException(value);
    }

    public Object[] executeObjectArray(VirtualFrame frame) throws UnexpectedResultException {
        Object value = this.execute(frame);
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        throw new UnexpectedResultException(value);
    }

    protected boolean isNil(Object value) {
        return value == this.nil();
    }

    protected boolean isRubiniusUndefined(Object value) {
        return value == this.getContext().getCoreLibrary().getRubiniusUndefined();
    }

    protected DynamicObject nil() {
        return this.getContext().getCoreLibrary().getNilObject();
    }

    public DynamicObject getSymbol(String name) {
        return this.getContext().getSymbol(name);
    }

    public DynamicObject getSymbol(ByteList name) {
        return this.getContext().getSymbol(name);
    }

    protected POSIX posix() {
        return this.getContext().getPosix();
    }

    protected NativeSockets nativeSockets() {
        return this.getContext().getNativeSockets();
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().DISPATCH_POLYMORPHIC_MAX;
    }

    protected DynamicObjectFactory getInstanceFactory(DynamicObject rubyClass) {
        return Layouts.CLASS.getInstanceFactory(rubyClass);
    }

    public boolean isInstrumentable() {
        return true;
    }

    public ProbeNode.WrapperNode createWrapperNode() {
        return new RubyWrapperNode(this);
    }

    public void setAtNewline() {
        this.atNewline = true;
    }

    public boolean isAtNewline() {
        return this.atNewline;
    }

    public RubyNode getNonProxyNode() {
        return this;
    }

    public RubyContext getContext() {
        return this.context;
    }

    public MemoryManager getMemoryManager() {
        return Runtime.getSystemRuntime().getMemoryManager();
    }

    protected Object ruby(VirtualFrame frame, String expression, Object ... arguments) {
        return this.rubyWithSelf(frame, RubyArguments.getSelf(frame.getArguments()), expression, arguments);
    }

    protected Object rubyWithSelf(VirtualFrame frame, Object self, String expression, Object ... arguments) {
        MaterializedFrame evalFrame = this.setupFrame(RubyArguments.getSelf(frame.getArguments()), arguments);
        DynamicObject binding = Layouts.BINDING.createBinding(this.getContext().getCoreLibrary().getBindingFactory(), self, evalFrame);
        return this.getContext().eval(expression, binding, true, "inline-ruby", (Node)this);
    }

    @CompilerDirectives.TruffleBoundary
    private MaterializedFrame setupFrame(Object self, Object ... arguments) {
        MaterializedFrame evalFrame = Truffle.getRuntime().createMaterializedFrame(RubyArguments.pack(null, null, self, null, new Object[0]));
        if (arguments.length % 2 == 1) {
            throw new UnsupportedOperationException("odd number of name-value pairs for arguments");
        }
        for (int n = 0; n < arguments.length; n += 2) {
            evalFrame.setObject(evalFrame.getFrameDescriptor().findOrAddFrameSlot(arguments[n]), arguments[n + 1]);
        }
        return evalFrame;
    }
}

